/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch;

import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.threads.ThreadsParser;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.batch.Attribute;
import org.wildfly.extension.batch.BatchSubsystemDefinition;
import org.wildfly.extension.batch.Element;
import org.wildfly.extension.batch.JobRepositoryDefinition;
import org.wildfly.extension.batch.Namespace;

class BatchSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    static final BatchSubsystemParser INSTANCE = new BatchSubsystemParser();
    private final ThreadsParser threadsParser = ThreadsParser.getInstance();

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{BatchSubsystemDefinition.SUBSYSTEM_PATH});
        list.add(Util.createAddOperation((PathAddress)subsystemAddress));
        while (reader.hasNext() && reader.nextTag() != 2) {
            Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
            if (namespace == Namespace.BATCH_1_0) {
                String localName = reader.getLocalName();
                Element element = Element.forName(localName);
                if (element == Element.JOB_REPOSITORY) {
                    this.parseJobRepository(reader, subsystemAddress, list);
                    continue;
                }
                if (element == Element.THREAD_POOL) {
                    this.threadsParser.parseUnboundedQueueThreadPool(reader, namespace.getUriString(), org.jboss.as.threads.Namespace.THREADS_1_1, subsystemAddress.toModelNode(), list, "thread-pool", "batch");
                    continue;
                }
                if (element == Element.THREAD_FACTORY) {
                    this.threadsParser.parseThreadFactory(reader, namespace.getUriString(), org.jboss.as.threads.Namespace.THREADS_1_1, subsystemAddress.toModelNode(), list, "thread-factory", null);
                    continue;
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseJobRepository(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> list) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            String localName = reader.getLocalName();
            Element element = Element.forName(localName);
            if (element == Element.IN_MEMORY) {
                list.add(Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathAddress)address, (PathElement[])new PathElement[]{JobRepositoryDefinition.IN_MEMORY.getPathElement()})));
                continue;
            }
            if (element == Element.JDBC) {
                if (reader.hasNext() && reader.nextTag() != 2) {
                    String value = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.JNDI_NAME.getLocalName());
                    ModelNode op = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathAddress)address, (PathElement[])new PathElement[]{JobRepositoryDefinition.JDBC.getPathElement()}));
                    JobRepositoryDefinition.JNDI_NAME.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    list.add(op);
                    continue;
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!reader.hasNext() || reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode model = context.getModelNode();
        if (model.hasDefined("job-repository")) {
            writer.writeStartElement("job-repository");
            String value = model.get("job-repository").asProperty().getName();
            if (JobRepositoryDefinition.JDBC.getPathElement().getValue().equals(value)) {
                writer.writeStartElement(Element.JDBC.getLocalName());
                JobRepositoryDefinition.JNDI_NAME.marshallAsAttribute(model.get("job-repository"), (XMLStreamWriter)writer);
                writer.writeEndElement();
            } else {
                writer.writeStartElement(Element.IN_MEMORY.getLocalName());
                writer.writeEndElement();
            }
            writer.writeEndElement();
            this.threadsParser.writeUnboundedQueueThreadPool(writer, model.get("thread-pool").asProperty(), Element.THREAD_POOL.getLocalName(), false);
            if (model.hasDefined("thread-factory")) {
                this.threadsParser.writeThreadFactory(writer, model.get("thread-factory").asProperty());
            }
        } else {
            writer.writeStartElement("job-repository");
            writer.writeStartElement(Element.IN_MEMORY.getLocalName());
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

