/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.batch.BatchSubsystemDefinition;
import org.wildfly.extension.batch._private.BatchMessages;
import org.wildfly.extension.batch.services.BatchPropertiesService;
import org.wildfly.extension.batch.services.BatchServiceNames;

public class JobRepositoryDefinition
extends SimpleResourceDefinition {
    public static final String NAME = "job-repository";
    public static final SimpleAttributeDefinition JNDI_NAME = SimpleAttributeDefinitionBuilder.create((String)"jndi-name", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(0, false, true)).build();
    public static final JobRepositoryDefinition IN_MEMORY = new JobRepositoryDefinition("in-memory", (OperationStepHandler)new JobRepositoryAdd(){

        @Override
        protected void addProperties(OperationContext context, ModelNode model, BatchPropertiesService service) throws OperationFailedException {
            service.addProperty("job-repository-type", "in-memory");
        }
    });
    public static final JobRepositoryDefinition JDBC = new JobRepositoryDefinition("jdbc", (OperationStepHandler)new JobRepositoryAdd(new AttributeDefinition[]{JNDI_NAME}){

        @Override
        protected void addProperties(OperationContext context, ModelNode model, BatchPropertiesService service) throws OperationFailedException {
            String jndiName = JNDI_NAME.resolveModelAttribute(context, model).asString();
            service.addProperty("job-repository-type", "jdbc");
            service.addProperty("datasource-jndi", jndiName);
        }
    }, new AttributeDefinition[]{JNDI_NAME});
    private final Collection<AttributeDefinition> attributes;

    private JobRepositoryDefinition(String name, OperationStepHandler addHandler) {
        this(name, addHandler, Collections.emptyList());
    }

    private JobRepositoryDefinition(String name, OperationStepHandler addHandler, AttributeDefinition ... attributes) {
        this(name, addHandler, Arrays.asList(attributes));
    }

    private JobRepositoryDefinition(String name, OperationStepHandler addHandler, Collection<AttributeDefinition> attributes) {
        super(PathElement.pathElement((String)NAME, (String)name), (ResourceDescriptionResolver)BatchSubsystemDefinition.getResourceDescriptionResolver(NAME, name), addHandler, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
        this.attributes = Collections.unmodifiableCollection(attributes);
    }

    static abstract class JobRepositoryAdd
    extends AbstractAddStepHandler {
        private static final AttributeDefinition[] EMPTY = new AttributeDefinition[0];

        protected JobRepositoryAdd() {
            this(EMPTY);
        }

        protected JobRepositoryAdd(AttributeDefinition ... attributes) {
            super(attributes);
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
                    PathAddress parent = address.subAddress(0, address.size() - 1);
                    Set jobRepositoryResources = context.readResourceFromRoot(parent).getChildren(JobRepositoryDefinition.NAME);
                    if (jobRepositoryResources.isEmpty()) {
                        throw BatchMessages.MESSAGES.jobRepositoryRequired();
                    }
                    if (jobRepositoryResources.size() > 1) {
                        ArrayList<String> found = new ArrayList<String>(jobRepositoryResources.size());
                        for (Resource.ResourceEntry entry : jobRepositoryResources) {
                            found.add(entry.getName());
                        }
                        throw BatchMessages.MESSAGES.multipleJobRepositoriesNotAllowed(found);
                    }
                    context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
                }
            }, OperationContext.Stage.MODEL);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
            BatchPropertiesService service = new BatchPropertiesService();
            this.addProperties(context, model, service);
            ServiceTarget serviceTarget = context.getServiceTarget();
            ServiceBuilder builder = serviceTarget.addService(BatchServiceNames.BATCH_PROPERTIES, (Service)service);
            newControllers.add(builder.install());
        }

        protected abstract void addProperties(OperationContext var1, ModelNode var2, BatchPropertiesService var3) throws OperationFailedException;
    }
}

