/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.deployment;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import javax.enterprise.inject.spi.BeanManager;
import javax.transaction.UserTransaction;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.naming.InjectedEENamespaceContextSelector;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.inject.CastingInjector;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.batch._private.BatchLogger;
import org.wildfly.extension.batch.services.BatchServiceNames;
import org.wildfly.jberet.services.BatchEnvironmentService;

public class BatchEnvironmentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        if (deploymentUnit.hasAttachment(org.jboss.as.server.deployment.Attachments.MODULE) && deploymentUnit.hasAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT)) {
            if (WeldDeploymentMarker.isWeldDeployment((DeploymentUnit)deploymentUnit)) {
                Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
                ModuleClassLoader moduleClassLoader = module.getClassLoader();
                ServiceTarget serviceTarget = phaseContext.getServiceTarget();
                EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
                InjectedEENamespaceContextSelector namespaceContextSelector = moduleDescription.getNamespaceContextSelector();
                BatchEnvironmentService service = new BatchEnvironmentService(namespaceContextSelector);
                ServiceBuilder serviceBuilder = serviceTarget.addService(BatchServiceNames.batchDeploymentServiceName(deploymentUnit), (Service)service);
                serviceBuilder.addDependency(BatchServiceNames.BATCH_PROPERTIES, Properties.class, (Injector)service.getPropertiesInjector());
                serviceBuilder.addDependency(TxnServices.JBOSS_TXN_USER_TRANSACTION, UserTransaction.class, (Injector)service.getUserTransactionInjector());
                serviceBuilder.addDependency(BatchServiceNames.BATCH_THREAD_POOL_NAME, ExecutorService.class, (Injector)service.getExecutorServiceInjector());
                service.getClassLoaderInjector().setValue((Value)new ImmediateValue((Object)moduleClassLoader));
                serviceBuilder.addDependency(BatchServiceNames.beanManagerServiceName(deploymentUnit), (Injector)new CastingInjector((Injector)service.getBeanManagerInjector(), BeanManager.class));
                serviceBuilder.install();
            } else {
                ResourceRoot root = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
                VirtualFile jobXmlFile = root.getRoot().getChild("META-INF/batch.xml");
                VirtualFile batchJobsDir = root.getRoot().getChild("META-INF/batch-jobs");
                if (jobXmlFile.exists() || batchJobsDir.exists() && !batchJobsDir.getChildren().isEmpty()) {
                    BatchLogger.LOGGER.cdiNotEnabled();
                }
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

