/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import com.sun.tools.jconsole.JConsoleContext;
import com.sun.tools.jconsole.JConsolePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServerConnection;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.ConnectDialog;
import org.jboss.as.cli.gui.GuiMain;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.impl.ExistingChannelModelControllerClient;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remotingjmx.RemotingMBeanServerConnection;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.security.manager.GetAccessControlContextAction;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

public class JConsoleCLIPlugin
extends JConsolePlugin {
    private static final int DEFAULT_MAX_THREADS = 6;
    private static final String LABEL = "WildFly CLI";
    private static final AtomicInteger executorCount = new AtomicInteger();
    private ConnectDialog dialog;
    CliGuiContext cliGuiCtx;
    private JPanel jconsolePanel;
    private boolean initComplete = false;
    private boolean isConnected = false;
    private ComponentListener doConnectListener;

    @Override
    public Map<String, JPanel> getTabs() {
        HashMap<String, JPanel> panelMap = new HashMap<String, JPanel>();
        this.jconsolePanel = new JPanel(new BorderLayout());
        this.dialog = new ConnectDialog(this, this.jconsolePanel);
        this.doConnectListener = new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent arg0) {
                try {
                    if (!JConsoleCLIPlugin.this.isConnected) {
                        JConsoleCLIPlugin.this.connect();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error connecting to JBoss AS.", e);
                }
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentHidden(ComponentEvent arg0) {
                if (JConsoleCLIPlugin.this.dialog.isStarted()) {
                    JConsoleCLIPlugin.this.dialog.stop();
                }
            }
        };
        this.jconsolePanel.addComponentListener(this.doConnectListener);
        panelMap.put(LABEL, this.jconsolePanel);
        return panelMap;
    }

    private void connect() throws Exception {
        JConsoleContext jcCtx = this.getContext();
        MBeanServerConnection mbeanServerConn = jcCtx.getMBeanServerConnection();
        if (mbeanServerConn instanceof RemotingMBeanServerConnection) {
            CommandContext cmdCtx = CommandContextFactory.getInstance().newCommandContext();
            this.isConnected = this.connectUsingRemoting(cmdCtx, (RemotingMBeanServerConnection)mbeanServerConn);
        } else {
            this.dialog.start();
        }
    }

    private boolean connectUsingRemoting(CommandContext cmdCtx, RemotingMBeanServerConnection rmtMBeanSvrConn) throws IOException, CliInitializationException {
        Connection conn = rmtMBeanSvrConn.getConnection();
        IoFuture<Channel> futureChannel = conn.openChannel("management", OptionMap.EMPTY);
        IoFuture.Status result = futureChannel.await(5L, TimeUnit.SECONDS);
        if (result != IoFuture.Status.DONE) {
            return false;
        }
        Channel channel = futureChannel.get();
        ModelControllerClient modelCtlrClient = ExistingChannelModelControllerClient.createReceiving(channel, this.createExecutor());
        cmdCtx.bindClient(modelCtlrClient);
        return true;
    }

    private ExecutorService createExecutor() {
        ThreadGroup group = new ThreadGroup("management-client-thread");
        JBossThreadFactory threadFactory = new JBossThreadFactory(group, Boolean.FALSE, null, "%G " + executorCount.incrementAndGet() + "-%t", null, null, AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
        return new ThreadPoolExecutor(2, 6, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        if (!this.initComplete && this.isConnected) {
            this.initComplete = true;
            this.configureMyJInternalFrame();
        }
        return null;
    }

    public void init(CommandContext cmdCtx) {
        this.cliGuiCtx = GuiMain.startEmbedded(cmdCtx);
        JPanel cliGuiPanel = this.cliGuiCtx.getMainPanel();
        this.jconsolePanel.setVisible(false);
        this.dialog.stop();
        this.jconsolePanel.add((Component)GuiMain.makeMenuBar(this.cliGuiCtx), "North");
        this.jconsolePanel.add((Component)cliGuiPanel, "Center");
        this.jconsolePanel.setVisible(true);
        this.jconsolePanel.repaint();
        this.isConnected = true;
    }

    private void configureMyJInternalFrame() {
        ImageIcon icon = new ImageIcon(GuiMain.getJBossIcon());
        Container component = this.jconsolePanel;
        while (component != null) {
            if (!((component = component.getParent()) instanceof JInternalFrame)) continue;
            JInternalFrame frame = (JInternalFrame)component;
            frame.setFrameIcon(icon);
            return;
        }
    }
}

