/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.naming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.jacorb.naming.BindingIteratorImpl;
import org.jacorb.naming.Name;
import org.jacorb.orb.util.CorbaLoc;
import org.jboss.as.jacorb.JacORBLogger;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIteratorHelper;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextExtPOA;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class CorbaNamingContext
extends NamingContextExtPOA
implements Serializable {
    private static final long serialVersionUID = 132820915998903191L;
    private static ORB orb;
    private static POA rootPoa;
    private transient POA poa;
    private Map<Name, java.lang.Object> names = new Hashtable<Name, java.lang.Object>();
    private Map<Name, java.lang.Object> contexts = new Hashtable<Name, java.lang.Object>();
    private static Map<String, CorbaNamingContext> contextImpls;
    private boolean noPing = false;
    private boolean doPurge = false;
    private boolean destroyed = false;
    private int childCount = 0;

    public static void init(ORB orb, POA rootPoa) {
        CorbaNamingContext.orb = orb;
        CorbaNamingContext.rootPoa = rootPoa;
    }

    public void init(POA poa, boolean doPurge, boolean noPing) {
        this.poa = poa;
        this.doPurge = doPurge;
        this.noPing = noPing;
    }

    public void bind(NameComponent[] nc, Object obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nc == null || nc.length == 0) {
            throw new InvalidName();
        }
        if (obj == null) {
            throw new BAD_PARAM();
        }
        Name n = new Name(nc);
        Name ctx = n.ctxName();
        NameComponent nb = n.baseNameComponent();
        if (ctx == null) {
            if (this.names.containsKey(n)) {
                Object ref = (Object)this.names.get(n);
                if (this.isDead(ref)) {
                    this.rebind(n.components(), obj);
                    return;
                }
                throw new AlreadyBound();
            }
            if (this.contexts.containsKey(n)) {
                Object ref = (Object)this.contexts.get(n);
                if (this.isDead(ref)) {
                    this.unbind(n.components());
                }
                throw new AlreadyBound();
            }
            if (this.names.put(n, obj) != null) {
                throw new CannotProceed((NamingContext)this._this(), n.components());
            }
            JacORBLogger.ROOT_LOGGER.debugBoundName(n.toString());
        } else {
            CorbaNamingContext jbossContext;
            NameComponent[] ncx = new NameComponent[]{nb};
            Object context = this.resolve(ctx.components());
            String contextOID = this.getObjectOID(context);
            CorbaNamingContext corbaNamingContext = jbossContext = contextOID == null ? null : contextImpls.get(contextOID);
            if (jbossContext != null) {
                jbossContext.bind(ncx, obj);
            } else {
                NamingContextExtHelper.narrow((Object)context).bind(ncx, obj);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void bind_context(NameComponent[] nc, NamingContext obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        Name n = new Name(nc);
        Name ctx = n.ctxName();
        NameComponent nb = n.baseNameComponent();
        if (ctx == null) {
            if (this.names.containsKey(n)) {
                Object ref = (Object)this.names.get(n);
                if (!this.isDead(ref)) throw new AlreadyBound();
                this.unbind(n.components());
            } else if (this.contexts.containsKey(n)) {
                Object ref = (Object)this.contexts.get(n);
                if (!this.isDead(ref)) throw new AlreadyBound();
                this.rebind_context(n.components(), obj);
                return;
            }
            if (this.contexts.put(n, obj) != null) {
                throw new CannotProceed((NamingContext)this._this(), n.components());
            }
            JacORBLogger.ROOT_LOGGER.debugBoundContext(n.toString());
            return;
        } else {
            CorbaNamingContext jbossContext;
            NameComponent[] ncx = new NameComponent[]{nb};
            Object context = this.resolve(ctx.components());
            String contextOID = this.getObjectOID(context);
            CorbaNamingContext corbaNamingContext = jbossContext = contextOID == null ? null : contextImpls.get(contextOID);
            if (jbossContext != null) {
                jbossContext.bind_context(ncx, obj);
                return;
            } else {
                NamingContextExtHelper.narrow((Object)context).bind_context(ncx, obj);
            }
        }
    }

    public NamingContext bind_new_context(NameComponent[] nc) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nc == null || nc.length == 0) {
            throw new InvalidName();
        }
        NamingContext context = this.new_context();
        if (context == null) {
            throw new CannotProceed();
        }
        this.bind_context(nc, context);
        return context;
    }

    public void destroy() throws NotEmpty {
        if (this.destroyed) {
            return;
        }
        if (!this.names.isEmpty() || !this.contexts.isEmpty()) {
            throw new NotEmpty();
        }
        this.names = null;
        this.contexts = null;
        this.destroyed = true;
    }

    public void list(int how_many, BindingListHolder bl, BindingIteratorHolder bi) {
        Binding[] result;
        int size;
        if (this.destroyed) {
            return;
        }
        this.cleanup();
        Iterator<Name> names = this.names.keySet().iterator();
        Iterator<Name> contexts = this.contexts.keySet().iterator();
        if (how_many < size) {
            Object o;
            int how_many_ctr;
            result = new Binding[how_many];
            for (how_many_ctr = how_many; names.hasNext() && how_many_ctr > 0; --how_many_ctr) {
                result[how_many_ctr - 1] = new Binding(names.next().components(), BindingType.nobject);
            }
            while (contexts.hasNext() && how_many_ctr > 0) {
                result[how_many_ctr - 1] = new Binding(contexts.next().components(), BindingType.ncontext);
                --how_many_ctr;
            }
            Binding[] rest = new Binding[size -= how_many];
            while (names.hasNext() && size > 0) {
                rest[size - 1] = new Binding(names.next().components(), BindingType.nobject);
                --size;
            }
            while (contexts.hasNext() && size > 0) {
                rest[size - 1] = new Binding(contexts.next().components(), BindingType.ncontext);
                --size;
            }
            try {
                byte[] oid = rootPoa.activate_object((Servant)new BindingIteratorImpl(rest));
                o = rootPoa.id_to_reference(oid);
            }
            catch (Exception e) {
                JacORBLogger.ROOT_LOGGER.logInternalError(e);
                throw new INTERNAL(e.toString());
            }
            bi.value = BindingIteratorHelper.narrow((Object)o);
        } else {
            result = new Binding[size];
            for (size = this.how_many(); names.hasNext() && size > 0; --size) {
                result[size - 1] = new Binding(names.next().components(), BindingType.nobject);
            }
            while (contexts.hasNext() && size > 0) {
                result[size - 1] = new Binding(contexts.next().components(), BindingType.ncontext);
                --size;
            }
        }
        bl.value = result;
    }

    public NamingContext new_context() {
        try {
            CorbaNamingContext newContextImpl = new CorbaNamingContext();
            newContextImpl.init(this.poa, this.doPurge, this.noPing);
            String oid = new String(this.poa.servant_to_id((Servant)this)) + "/ctx" + ++this.childCount;
            this.poa.activate_object_with_id(oid.getBytes(), (Servant)newContextImpl);
            contextImpls.put(oid, newContextImpl);
            return NamingContextExtHelper.narrow((Object)this.poa.create_reference_with_id(oid.getBytes(), "IDL:omg.org/CosNaming/NamingContextExt:1.0"));
        }
        catch (Exception e) {
            JacORBLogger.ROOT_LOGGER.failedToCreateNamingContext(e);
            return null;
        }
    }

    public void rebind(NameComponent[] nc, Object obj) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nc == null || nc.length == 0) {
            throw new InvalidName();
        }
        if (obj == null) {
            throw new BAD_PARAM();
        }
        Name n = new Name(nc);
        Name ctx = n.ctxName();
        NameComponent nb = n.baseNameComponent();
        if (ctx == null) {
            if (this.contexts.containsKey(n)) {
                throw new NotFound(NotFoundReason.not_object, new NameComponent[]{nb});
            }
            Object ref = (Object)this.names.remove(n);
            if (ref != null) {
                ref._release();
            }
            this.names.put(n, obj);
            JacORBLogger.ROOT_LOGGER.debugBoundName(n.toString());
        } else {
            CorbaNamingContext jbossContext;
            NameComponent[] ncx = new NameComponent[]{nb};
            Object context = this.resolve(ctx.components());
            String contextOID = this.getObjectOID(context);
            CorbaNamingContext corbaNamingContext = jbossContext = contextOID == null ? null : contextImpls.get(contextOID);
            if (jbossContext != null) {
                jbossContext.rebind(ncx, obj);
            } else {
                NamingContextExtHelper.narrow((Object)context).rebind(ncx, obj);
            }
        }
    }

    public void rebind_context(NameComponent[] nc, NamingContext obj) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nc == null || nc.length == 0) {
            throw new InvalidName();
        }
        if (obj == null) {
            throw new BAD_PARAM();
        }
        Name n = new Name(nc);
        Name ctx = n.ctxName();
        NameComponent nb = n.baseNameComponent();
        if (ctx == null) {
            if (this.names.containsKey(n)) {
                throw new NotFound(NotFoundReason.not_context, new NameComponent[]{nb});
            }
            Object ref = (Object)this.contexts.remove(n);
            if (ref != null) {
                ref._release();
                String oid = this.getObjectOID(ref);
                if (oid != null) {
                    contextImpls.remove(oid);
                }
            }
            this.contexts.put(n, obj);
            JacORBLogger.ROOT_LOGGER.debugBoundContext(n.baseNameComponent().id);
        } else {
            CorbaNamingContext jbossContext;
            NameComponent[] ncx = new NameComponent[]{nb};
            Object context = this.resolve(ctx.components());
            String contextOID = this.getObjectOID(context);
            CorbaNamingContext corbaNamingContext = jbossContext = contextOID == null ? null : contextImpls.get(contextOID);
            if (jbossContext != null) {
                jbossContext.rebind_context(ncx, obj);
            } else {
                NamingContextExtHelper.narrow((Object)context).rebind_context(ncx, obj);
            }
        }
    }

    public Object resolve(NameComponent[] nc) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nc == null || nc.length == 0) {
            throw new InvalidName();
        }
        Name n = new Name(nc[0]);
        if (nc.length > 1) {
            CorbaNamingContext jbossContext;
            Object next_context = (Object)this.contexts.get(n);
            if (next_context == null || this.isDead(next_context)) {
                throw new NotFound(NotFoundReason.missing_node, nc);
            }
            NameComponent[] nc_prime = new NameComponent[nc.length - 1];
            System.arraycopy(nc, 1, nc_prime, 0, nc_prime.length);
            String contextOID = this.getObjectOID(next_context);
            CorbaNamingContext corbaNamingContext = jbossContext = contextOID == null ? null : contextImpls.get(contextOID);
            if (jbossContext != null) {
                return jbossContext.resolve(nc_prime);
            }
            return NamingContextExtHelper.narrow((Object)next_context).resolve(nc_prime);
        }
        Object result = (Object)this.contexts.get(n);
        if (result == null) {
            result = (Object)this.names.get(n);
        }
        if (result == null) {
            throw new NotFound(NotFoundReason.missing_node, n.components());
        }
        if (!this.noPing && this.isDead(result)) {
            throw new NotFound(NotFoundReason.missing_node, n.components());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void unbind(NameComponent[] nc) throws NotFound, CannotProceed, InvalidName {
        CorbaNamingContext jbossContext;
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nc == null) throw new InvalidName();
        if (nc.length == 0) {
            throw new InvalidName();
        }
        Name n = new Name(nc);
        Name ctx = n.ctxName();
        NameComponent nb = n.baseNameComponent();
        if (ctx == null) {
            if (this.names.containsKey(n)) {
                Object ref = (Object)this.names.remove(n);
                ref._release();
                JacORBLogger.ROOT_LOGGER.debugUnboundObject(n.toString());
                return;
            }
            if (!this.contexts.containsKey(n)) {
                JacORBLogger.ROOT_LOGGER.failedToUnbindObject(n.toString());
                throw new NotFound(NotFoundReason.not_context, n.components());
            }
            Object ref = (Object)this.contexts.remove(n);
            ref._release();
            String oid = this.getObjectOID(ref);
            if (oid != null) {
                contextImpls.remove(oid);
            }
            JacORBLogger.ROOT_LOGGER.debugUnboundObject(n.toString());
            return;
        }
        NameComponent[] ncx = new NameComponent[]{nb};
        Object context = this.resolve(ctx.components());
        String contextOID = this.getObjectOID(context);
        CorbaNamingContext corbaNamingContext = jbossContext = contextOID == null ? null : contextImpls.get(contextOID);
        if (jbossContext != null) {
            jbossContext.unbind(ncx);
            return;
        }
        NamingContextExtHelper.narrow((Object)context).unbind(ncx);
    }

    public Object resolve_str(String n) throws NotFound, CannotProceed, InvalidName {
        return this.resolve(this.to_name(n));
    }

    public NameComponent[] to_name(String sn) throws InvalidName {
        return Name.toName((String)sn);
    }

    public String to_string(NameComponent[] n) throws InvalidName {
        return Name.toString((NameComponent[])n);
    }

    public String to_url(String addr, String sn) throws InvalidAddress, InvalidName {
        try {
            CorbaLoc corbaLoc = new CorbaLoc((org.jacorb.orb.ORB)orb, addr);
            return corbaLoc.toCorbaName(sn);
        }
        catch (IllegalArgumentException ia) {
            throw new InvalidAddress();
        }
    }

    private void cleanup() {
        if (!this.doPurge) {
            return;
        }
        for (Name key : this.names.keySet()) {
            if (!this.isDead((Object)this.names.get(key))) continue;
            this.names.remove(key);
        }
        for (Name key : this.contexts.keySet()) {
            Object object = (Object)this.contexts.get(key);
            if (!this.isDead(object)) continue;
            this.contexts.remove(key);
            String oid = this.getObjectOID(object);
            if (oid == null) continue;
            contextImpls.remove(oid);
        }
    }

    private String getObjectOID(Object object) {
        String oid = null;
        try {
            byte[] oidBytes = this.poa.reference_to_id(object);
            if (oidBytes != null) {
                oid = new String(oidBytes);
            }
        }
        catch (Exception e) {
            JacORBLogger.ROOT_LOGGER.failedToObtainIdFromObject(e);
        }
        return oid;
    }

    private int how_many() {
        if (this.destroyed) {
            return 0;
        }
        return this.names.size() + this.contexts.size();
    }

    private boolean isDead(Object o) {
        boolean non_exist;
        try {
            non_exist = o._non_existent();
        }
        catch (SystemException e) {
            non_exist = true;
        }
        return non_exist;
    }

    private void readObject(ObjectInputStream in) throws Exception {
        String ref;
        in.defaultReadObject();
        for (Name key : this.contexts.keySet()) {
            ref = (String)this.contexts.remove(key);
            this.contexts.put(key, orb.string_to_object(ref));
        }
        for (Name key : this.names.keySet()) {
            ref = (String)this.names.remove(key);
            this.names.put(key, orb.string_to_object(ref));
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Object o;
        for (Name key : this.contexts.keySet()) {
            o = (Object)this.contexts.remove(key);
            this.contexts.put(key, orb.object_to_string(o));
        }
        for (Name key : this.names.keySet()) {
            o = (Object)this.names.remove(key);
            this.names.put(key, orb.object_to_string(o));
        }
        out.defaultWriteObject();
    }

    static {
        contextImpls = new Hashtable<String, CorbaNamingContext>();
    }
}

