/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.server.session.Session;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.wildfly.clustering.web.session.ImmutableSession;

public abstract class AbstractSessionAdapter<S extends ImmutableSession>
implements Session {
    protected abstract S getSession();

    public String getId() {
        return this.getSession().getId();
    }

    public long getCreationTime() {
        return this.getSession().getMetaData().getCreationTime().getTime();
    }

    public long getLastAccessedTime() {
        return this.getSession().getMetaData().getLastAccessedTime().getTime();
    }

    public int getMaxInactiveInterval() {
        return (int)this.getSession().getMetaData().getMaxInactiveInterval(TimeUnit.SECONDS);
    }

    public Object getAttribute(String name) {
        return this.getSession().getAttributes().getAttribute(name);
    }

    public Set<String> getAttributeNames() {
        return this.getSession().getAttributes().getAttributeNames();
    }
}

