/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspContext;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperMessages;
import org.apache.jasper.el.ELContextImpl;
import org.apache.jasper.el.JasperELResolver;

public class JspApplicationContextImpl
implements JspApplicationContext {
    private static final String KEY = JspApplicationContextImpl.class.getName();
    private final ExpressionFactory expressionFactory = ExpressionFactory.newInstance();
    private final List<ELContextListener> contextListeners = new ArrayList<ELContextListener>();
    private final List<ELResolver> resolvers = new ArrayList<ELResolver>();
    private boolean instantiated = false;
    private ELResolver resolver;

    public void addELContextListener(ELContextListener listener) {
        if (listener == null) {
            throw JasperMessages.MESSAGES.nullElContextListener();
        }
        this.contextListeners.add(listener);
    }

    public static JspApplicationContextImpl getInstance(ServletContext context) {
        if (context == null) {
            throw JasperMessages.MESSAGES.nullServletContext();
        }
        JspApplicationContextImpl impl = (JspApplicationContextImpl)context.getAttribute(KEY);
        if (impl == null) {
            impl = new JspApplicationContextImpl();
            context.setAttribute(KEY, (Object)impl);
        }
        return impl;
    }

    public ELContextImpl createELContext(JspContext context) {
        if (context == null) {
            throw JasperMessages.MESSAGES.nullJspContext();
        }
        final ELResolver r = this.createELResolver();
        ELContextImpl ctx = Constants.IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedAction<ELContextImpl>(){

            @Override
            public ELContextImpl run() {
                return new ELContextImpl(r);
            }
        }) : new ELContextImpl(r);
        ctx.putContext(JspContext.class, context);
        ELContextEvent event = new ELContextEvent((ELContext)ctx);
        for (int i = 0; i < this.contextListeners.size(); ++i) {
            this.contextListeners.get(i).contextCreated(event);
        }
        return ctx;
    }

    private ELResolver createELResolver() {
        this.instantiated = true;
        if (this.resolver == null) {
            this.resolver = new JasperELResolver(this.resolvers);
        }
        return this.resolver;
    }

    public void addELResolver(ELResolver resolver) throws IllegalStateException {
        if (resolver == null) {
            throw JasperMessages.MESSAGES.nullElResolver();
        }
        if (this.instantiated) {
            throw JasperMessages.MESSAGES.cannotAddElResolver();
        }
        this.resolvers.add(resolver);
    }

    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }
}

