/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.xts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.webservices.injection.WSEndpointHandlersMapping;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.as.xts.XTSDeploymentMarker;
import org.jboss.as.xts.XTSException;
import org.jboss.as.xts.jandex.BridgeType;
import org.jboss.as.xts.jandex.EndpointMetaData;
import org.jboss.as.xts.jandex.TransactionalAnnotation;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

public class XTSHandlerDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final String TX_BRIDGE_HANDLER = "org.jboss.jbossts.txbridge.inbound.JaxWSTxInboundBridgeHandler";
    private static final String TX_CONTEXT_HANDLER = "com.arjuna.mw.wst11.service.JaxWSHeaderContextProcessor";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        WebservicesMetaData webservicesMetaData = new WebservicesMetaData();
        boolean modifiedWSMeta = false;
        for (String endpoint : this.getDeploymentClasses(unit)) {
            try {
                EndpointMetaData endpointMetaData = EndpointMetaData.build(unit, endpoint);
                if (!endpointMetaData.isTXFrameworkEnabled()) continue;
                XTSDeploymentMarker.mark(unit);
                if (!endpointMetaData.isWebservice()) continue;
                ArrayList<String> handlers = new ArrayList<String>();
                TransactionalAnnotation TransactionalAnnotation2 = endpointMetaData.getTransactionalAnnotation();
                if (this.shouldBridge(TransactionalAnnotation2)) {
                    handlers.add(TX_BRIDGE_HANDLER);
                }
                handlers.add(TX_CONTEXT_HANDLER);
                this.addHandlerToEndpoint(webservicesMetaData, endpointMetaData, endpoint, handlers);
                this.registerHandlersWithAS(unit, endpoint, handlers);
                modifiedWSMeta = true;
            }
            catch (XTSException e) {
                throw new DeploymentUnitProcessingException("Error processing endpoint '" + endpoint + "'", (Throwable)e);
            }
        }
        if (modifiedWSMeta) {
            unit.putAttachment(WSAttachmentKeys.WEBSERVICES_METADATA_KEY, (Object)webservicesMetaData);
        }
    }

    private boolean shouldBridge(TransactionalAnnotation TransactionalAnnotation2) {
        if (TransactionalAnnotation2 == null) {
            return false;
        }
        if (TransactionalAnnotation2.getBridgeType() == null) {
            return false;
        }
        BridgeType bridgeType = TransactionalAnnotation2.getBridgeType();
        return bridgeType.equals((Object)BridgeType.JTA) || bridgeType.equals((Object)BridgeType.DEFAULT);
    }

    private void addHandlerToEndpoint(WebservicesMetaData wsWebservicesMetaData, EndpointMetaData endpointMetaData, String endpointClass, List<String> handlers) {
        WebserviceDescriptionMetaData descriptionMetaData = new WebserviceDescriptionMetaData(wsWebservicesMetaData);
        UnifiedHandlerChainsMetaData unifiedHandlerChainsMetaData = this.buildHandlerChains(handlers);
        QName portQname = endpointMetaData.getWebServiceAnnotation().buildPortQName();
        PortComponentMetaData portComponent = this.buildPortComponent(endpointMetaData.isEJB(), endpointClass, portQname, unifiedHandlerChainsMetaData, descriptionMetaData);
        descriptionMetaData.addPortComponent(portComponent);
        wsWebservicesMetaData.addWebserviceDescription(descriptionMetaData);
    }

    private PortComponentMetaData buildPortComponent(boolean isEJB, String endpointClass, QName portQname, UnifiedHandlerChainsMetaData unifiedHandlerChainsMetaData, WebserviceDescriptionMetaData descriptionMetaData) {
        PortComponentMetaData portComponent = new PortComponentMetaData(descriptionMetaData);
        portComponent.setHandlerChains(unifiedHandlerChainsMetaData);
        portComponent.setServiceEndpointInterface(endpointClass);
        portComponent.setWsdlPort(portQname);
        if (isEJB) {
            portComponent.setEjbLink(this.getClassName(endpointClass));
        } else {
            portComponent.setServletLink(endpointClass);
        }
        return portComponent;
    }

    private UnifiedHandlerChainsMetaData buildHandlerChains(List<String> handlerClasses) {
        UnifiedHandlerChainMetaData unifiedHandlerChainMetaData = new UnifiedHandlerChainMetaData();
        for (String handlerClass : handlerClasses) {
            UnifiedHandlerMetaData handlerMetaData = new UnifiedHandlerMetaData();
            handlerMetaData.setHandlerClass(handlerClass);
            unifiedHandlerChainMetaData.addHandler(handlerMetaData);
        }
        UnifiedHandlerChainsMetaData unifiedHandlerChainsMetaData = new UnifiedHandlerChainsMetaData();
        unifiedHandlerChainsMetaData.addHandlerChain(unifiedHandlerChainMetaData);
        return unifiedHandlerChainsMetaData;
    }

    private void registerHandlersWithAS(DeploymentUnit unit, String endpointClass, List<String> handlersToAdd) {
        HashSet<String> existingHandlers;
        WSEndpointHandlersMapping mapping = (WSEndpointHandlersMapping)unit.getAttachment(WSAttachmentKeys.WS_ENDPOINT_HANDLERS_MAPPING_KEY);
        if (mapping == null) {
            mapping = new WSEndpointHandlersMapping();
            unit.putAttachment(WSAttachmentKeys.WS_ENDPOINT_HANDLERS_MAPPING_KEY, (Object)mapping);
        }
        existingHandlers = (existingHandlers = mapping.getHandlers(endpointClass)) == null ? new HashSet<String>() : new HashSet(existingHandlers);
        for (String handler : handlersToAdd) {
            if (existingHandlers.contains(handler)) {
                return;
            }
            existingHandlers.add(handler);
        }
        mapping.registerEndpointHandlers(endpointClass, existingHandlers);
    }

    private String getClassName(String fQClass) {
        String[] split = fQClass.split("\\.");
        return split[split.length - 1];
    }

    private Set<String> getDeploymentClasses(DeploymentUnit unit) {
        HashSet<String> endpoints = new HashSet<String>();
        this.addEndpointsToList(endpoints, ASHelper.getAnnotations((DeploymentUnit)unit, (DotName)DotName.createSimple((String)"org.jboss.narayana.txframework.api.annotation.transaction.Compensatable")));
        this.addEndpointsToList(endpoints, ASHelper.getAnnotations((DeploymentUnit)unit, (DotName)DotName.createSimple((String)"org.jboss.narayana.compensations.api.Compensatable")));
        this.addEndpointsToList(endpoints, ASHelper.getAnnotations((DeploymentUnit)unit, (DotName)DotName.createSimple((String)"org.jboss.narayana.txframework.api.annotation.transaction.Transactional")));
        return endpoints;
    }

    private void addEndpointsToList(Set<String> endpoints, List<AnnotationInstance> annotations) {
        for (AnnotationInstance annotationInstance : annotations) {
            String endpointClass;
            AnnotationTarget target = annotationInstance.target();
            if (target instanceof ClassInfo) {
                ClassInfo classInfo = (ClassInfo)annotationInstance.target();
                endpointClass = classInfo.name().toString();
                endpoints.add(endpointClass);
                continue;
            }
            if (!(target instanceof MethodInfo)) continue;
            MethodInfo methodInfo = (MethodInfo)target;
            endpointClass = methodInfo.declaringClass().name().toString();
            endpoints.add(endpointClass);
        }
    }

    public void undeploy(DeploymentUnit unit) {
    }
}

