/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.xts;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.xts.Attribute;
import org.jboss.as.xts.Element;
import org.jboss.as.xts.Namespace;
import org.jboss.as.xts.XTSExtension;
import org.jboss.as.xts.XTSSubsystemDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class XTSSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    XTSSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        ModelNode subsystem = Util.getEmptyOperation((String)"add", (ModelNode)PathAddress.pathAddress((PathElement[])new PathElement[]{XTSExtension.SUBSYSTEM_PATH}).toModelNode());
        list.add(subsystem);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case HOST: {
                    this.parseHostElement(reader, subsystem);
                    continue block5;
                }
                case XTS_ENVIRONMENT: {
                    this.parseXTSEnvironmentElement(reader, subsystem);
                    continue block5;
                }
                case DEFAULT_CONTEXT_PROPAGATION: {
                    this.parseDefaultContextPropagationElement(reader, subsystem);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        if (node.hasDefined(XTSSubsystemDefinition.HOST_NAME.getName())) {
            writer.writeStartElement(Element.HOST.getLocalName());
            XTSSubsystemDefinition.HOST_NAME.marshallAsAttribute(node, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (node.hasDefined(XTSSubsystemDefinition.ENVIRONMENT_URL.getName())) {
            writer.writeStartElement(Element.XTS_ENVIRONMENT.getLocalName());
            XTSSubsystemDefinition.ENVIRONMENT_URL.marshallAsAttribute(node, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (node.hasDefined(XTSSubsystemDefinition.DEFAULT_CONTEXT_PROPAGATION.getName())) {
            writer.writeStartElement(Element.DEFAULT_CONTEXT_PROPAGATION.getLocalName());
            XTSSubsystemDefinition.DEFAULT_CONTEXT_PROPAGATION.marshallAsAttribute(node, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void parseHostElement(XMLExtendedStreamReader reader, ModelNode subsystem) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    XTSSubsystemDefinition.HOST_NAME.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
    }

    private void parseXTSEnvironmentElement(XMLExtendedStreamReader reader, ModelNode subsystem) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case URL: {
                    XTSSubsystemDefinition.ENVIRONMENT_URL.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseDefaultContextPropagationElement(XMLExtendedStreamReader reader, ModelNode subsystem) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (value == null || !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                    XTSSubsystemDefinition.DEFAULT_CONTEXT_PROPAGATION.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }
}

