/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.annotation.Resources;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.FieldInjectionTarget;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.component.MethodInjectionTarget;
import org.jboss.as.ee.component.OptionalLookupInjectionSource;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.ee.component.deployers.EEResourceReferenceProcessor;
import org.jboss.as.ee.component.deployers.EEResourceReferenceProcessorRegistry;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.modules.Module;

public class ResourceInjectionAnnotationParsingProcessor
implements DeploymentUnitProcessor {
    private static final DotName RESOURCE_ANNOTATION_NAME = DotName.createSimple((String)Resource.class.getName());
    private static final DotName RESOURCES_ANNOTATION_NAME = DotName.createSimple((String)Resources.class.getName());
    private static final String JAVAX_NAMING_CONTEXT = "javax.naming.Context";
    public static final Map<String, String> FIXED_LOCATIONS;
    public static final Set<String> SIMPLE_ENTRIES;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (module == null) {
            return;
        }
        List resourceAnnotations = index.getAnnotations(RESOURCE_ANNOTATION_NAME);
        for (AnnotationInstance annotation : resourceAnnotations) {
            EEModuleClassDescription classDescription;
            ClassInfo classInfo;
            String type;
            AnnotationTarget annotationTarget = annotation.target();
            AnnotationValue nameValue = annotation.value("name");
            String name = nameValue != null ? nameValue.asString() : null;
            AnnotationValue typeValue = annotation.value("type");
            String string = type = typeValue != null ? typeValue.asClass().name().toString() : null;
            if (annotationTarget instanceof FieldInfo) {
                FieldInfo fieldInfo = (FieldInfo)annotationTarget;
                classInfo = fieldInfo.declaringClass();
                classDescription = eeModuleDescription.addOrGetLocalClassDescription(classInfo.name().toString());
                this.processFieldResource(phaseContext, fieldInfo, name, type, classDescription, annotation, eeModuleDescription, module, applicationClasses);
                continue;
            }
            if (annotationTarget instanceof MethodInfo) {
                MethodInfo methodInfo = (MethodInfo)annotationTarget;
                classInfo = methodInfo.declaringClass();
                classDescription = eeModuleDescription.addOrGetLocalClassDescription(classInfo.name().toString());
                this.processMethodResource(phaseContext, methodInfo, name, type, classDescription, annotation, eeModuleDescription, module, applicationClasses);
                continue;
            }
            if (!(annotationTarget instanceof ClassInfo)) continue;
            ClassInfo classInfo2 = (ClassInfo)annotationTarget;
            EEModuleClassDescription classDescription2 = eeModuleDescription.addOrGetLocalClassDescription(classInfo2.name().toString());
            this.processClassResource(phaseContext, name, type, classDescription2, annotation, eeModuleDescription, module, applicationClasses);
        }
        List resourcesAnnotations = index.getAnnotations(RESOURCES_ANNOTATION_NAME);
        for (AnnotationInstance outerAnnotation : resourcesAnnotations) {
            AnnotationInstance[] values;
            AnnotationTarget annotationTarget = outerAnnotation.target();
            if (!(annotationTarget instanceof ClassInfo)) continue;
            ClassInfo classInfo = (ClassInfo)annotationTarget;
            for (AnnotationInstance annotation : values = outerAnnotation.value("value").asNestedArray()) {
                AnnotationValue nameValue = annotation.value("name");
                String name = nameValue != null ? nameValue.asString() : null;
                AnnotationValue typeValue = annotation.value("type");
                String type = typeValue != null ? typeValue.asClass().name().toString() : null;
                EEModuleClassDescription classDescription = eeModuleDescription.addOrGetLocalClassDescription(classInfo.name().toString());
                this.processClassResource(phaseContext, name, type, classDescription, annotation, eeModuleDescription, module, applicationClasses);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    protected void processFieldResource(DeploymentPhaseContext phaseContext, FieldInfo fieldInfo, String name, String type, EEModuleClassDescription classDescription, AnnotationInstance annotation, EEModuleDescription eeModuleDescription, Module module, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        String fieldName = fieldInfo.name();
        String injectionType = this.isEmpty(type) || type.equals(Object.class.getName()) ? fieldInfo.type().name().toString() : type;
        String localContextName = this.isEmpty(name) ? fieldInfo.declaringClass().name().toString() + "/" + fieldName : name;
        FieldInjectionTarget targetDescription = new FieldInjectionTarget(fieldInfo.declaringClass().name().toString(), fieldName, fieldInfo.type().name().toString());
        this.process(phaseContext, classDescription, annotation, injectionType, localContextName, targetDescription, eeModuleDescription, module, applicationClasses);
    }

    protected void processMethodResource(DeploymentPhaseContext phaseContext, MethodInfo methodInfo, String name, String type, EEModuleClassDescription classDescription, AnnotationInstance annotation, EEModuleDescription eeModuleDescription, Module module, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        String methodName = methodInfo.name();
        if (!methodName.startsWith("set") || methodInfo.args().length != 1) {
            throw EeMessages.MESSAGES.setterMethodOnly("@Resource", methodInfo);
        }
        String contextNameSuffix = methodName.substring(3, 4).toLowerCase(Locale.ENGLISH) + methodName.substring(4);
        String localContextName = this.isEmpty(name) ? methodInfo.declaringClass().name().toString() + "/" + contextNameSuffix : name;
        String injectionType = this.isEmpty(type) || type.equals(Object.class.getName()) ? methodInfo.args()[0].name().toString() : type;
        MethodInjectionTarget targetDescription = new MethodInjectionTarget(methodInfo.declaringClass().name().toString(), methodName, methodInfo.args()[0].name().toString());
        this.process(phaseContext, classDescription, annotation, injectionType, localContextName, targetDescription, eeModuleDescription, module, applicationClasses);
    }

    protected void processClassResource(DeploymentPhaseContext phaseContext, String name, String type, EEModuleClassDescription classDescription, AnnotationInstance annotation, EEModuleDescription eeModuleDescription, Module module, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        if (this.isEmpty(name)) {
            throw EeMessages.MESSAGES.annotationAttributeMissing("@Resource", "name");
        }
        String realType = this.isEmpty(type) ? Object.class.getName() : type;
        this.process(phaseContext, classDescription, annotation, realType, name, null, eeModuleDescription, module, applicationClasses);
    }

    protected void process(DeploymentPhaseContext phaseContext, EEModuleClassDescription classDescription, AnnotationInstance annotation, String injectionType, String localContextName, InjectionTarget targetDescription, EEModuleDescription eeModuleDescription, Module module, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        EEResourceReferenceProcessor resourceReferenceProcessor;
        String lookup;
        EEResourceReferenceProcessorRegistry registry = (EEResourceReferenceProcessorRegistry)phaseContext.getDeploymentUnit().getAttachment(Attachments.RESOURCE_REFERENCE_PROCESSOR_REGISTRY);
        AnnotationValue lookupAnnotation = annotation.value("lookup");
        String string = lookup = lookupAnnotation == null ? null : lookupAnnotation.asString();
        if (this.isEmpty(lookup)) {
            AnnotationValue mappedNameAnnotationValue = annotation.value("mappedName");
            String string2 = lookup = mappedNameAnnotationValue == null ? null : mappedNameAnnotationValue.asString();
        }
        if (this.isEmpty(lookup) && FIXED_LOCATIONS.containsKey(injectionType)) {
            lookup = FIXED_LOCATIONS.get(injectionType);
        }
        InjectionSource valueSource = null;
        boolean isEnvEntryType = this.isEnvEntryType(injectionType, module);
        if (!this.isEmpty(lookup)) {
            valueSource = JAVAX_NAMING_CONTEXT.equals(injectionType) ? new OptionalLookupInjectionSource(lookup) : new LookupInjectionSource(lookup);
        } else if (!isEnvEntryType && (resourceReferenceProcessor = registry.getResourceReferenceProcessor(injectionType)) != null) {
            valueSource = resourceReferenceProcessor.getResourceReferenceBindingSource();
        }
        if (valueSource == null) {
            if (targetDescription != null) {
                OptionalLookupInjectionSource optionalInjection = new OptionalLookupInjectionSource(localContextName);
                ResourceInjectionConfiguration injectionConfiguration = new ResourceInjectionConfiguration(targetDescription, optionalInjection, true);
                classDescription.addResourceInjection(injectionConfiguration);
            }
        } else {
            LookupInjectionSource injectionSource = new LookupInjectionSource(localContextName);
            ResourceInjectionConfiguration injectionConfiguration = targetDescription != null ? new ResourceInjectionConfiguration(targetDescription, injectionSource) : null;
            BindingConfiguration bindingConfiguration = new BindingConfiguration(localContextName, valueSource);
            classDescription.getBindingConfigurations().add(bindingConfiguration);
            if (injectionConfiguration != null) {
                classDescription.addResourceInjection(injectionConfiguration);
            }
        }
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private boolean isEnvEntryType(String type, Module module) {
        if (SIMPLE_ENTRIES.contains(type)) {
            return true;
        }
        try {
            return module.getClassLoader().loadClass(type).isEnum();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static {
        HashMap<String, String> locations = new HashMap<String, String>();
        locations.put("javax.transaction.UserTransaction", "java:jboss/UserTransaction");
        locations.put("javax.transaction.TransactionSynchronizationRegistry", "java:jboss/TransactionSynchronizationRegistry");
        locations.put("org.osgi.framework.BundleContext", "java:jboss/osgi/BundleContext");
        locations.put("javax.enterprise.inject.spi.BeanManager", "java:comp/BeanManager");
        locations.put("javax.ejb.TimerService", "java:comp/TimerService");
        locations.put("org.omg.CORBA.ORB", "java:comp/ORB");
        FIXED_LOCATIONS = Collections.unmodifiableMap(locations);
        HashSet<String> simpleEntries = new HashSet<String>();
        simpleEntries.add("boolean");
        simpleEntries.add("char");
        simpleEntries.add("byte");
        simpleEntries.add("short");
        simpleEntries.add("int");
        simpleEntries.add("long");
        simpleEntries.add("double");
        simpleEntries.add("float");
        simpleEntries.add("java.lang.Boolean");
        simpleEntries.add("java.lang.Character");
        simpleEntries.add("java.lang.Byte");
        simpleEntries.add("java.lang.Short");
        simpleEntries.add("java.lang.Integer");
        simpleEntries.add("java.lang.Long");
        simpleEntries.add("java.lang.Double");
        simpleEntries.add("java.lang.Float");
        simpleEntries.add("java.lang.String");
        simpleEntries.add("java.lang.Class");
        SIMPLE_ENTRIES = Collections.unmodifiableSet(simpleEntries);
    }
}

