/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.deployers;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;

public class EEConcurrentDefaultBindingProcessor
implements DeploymentUnitProcessor {
    public static final String COMP_DEFAULT_CONTEXT_SERVICE_JNDI_NAME = "java:comp/DefaultContextService";
    public static final String MODULE_DEFAULT_CONTEXT_SERVICE_JNDI_NAME = "java:module/DefaultContextService";
    public static final String COMP_DEFAULT_MANAGED_EXECUTOR_SERVICE_JNDI_NAME = "java:comp/DefaultManagedExecutorService";
    public static final String MODULE_DEFAULT_MANAGED_EXECUTOR_SERVICE_JNDI_NAME = "java:module/DefaultManagedExecutorService";
    public static final String COMP_DEFAULT_MANAGED_SCHEDULED_EXECUTOR_SERVICE_JNDI_NAME = "java:comp/DefaultManagedScheduledExecutorService";
    public static final String MODULE_DEFAULT_MANAGED_SCHEDULED_EXECUTOR_SERVICE_JNDI_NAME = "java:module/DefaultManagedScheduledExecutorService";
    public static final String COMP_DEFAULT_MANAGED_THREAD_FACTORY_JNDI_NAME = "java:comp/DefaultManagedThreadFactory";
    public static final String MODULE_DEFAULT_MANAGED_THREAD_FACTORY_JNDI_NAME = "java:module/DefaultManagedThreadFactory";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit)) {
            return;
        }
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        String contextService = moduleDescription.getDefaultResourceJndiNames().getContextService();
        String managedExecutorService = moduleDescription.getDefaultResourceJndiNames().getManagedExecutorService();
        String managedScheduledExecutorService = moduleDescription.getDefaultResourceJndiNames().getManagedScheduledExecutorService();
        String managedThreadFactory = moduleDescription.getDefaultResourceJndiNames().getManagedThreadFactory();
        if (DeploymentTypeMarker.isType(DeploymentType.WAR, deploymentUnit)) {
            if (contextService != null) {
                moduleDescription.getBindingConfigurations().add(new BindingConfiguration(MODULE_DEFAULT_CONTEXT_SERVICE_JNDI_NAME, new LookupInjectionSource(contextService)));
            }
            if (managedExecutorService != null) {
                moduleDescription.getBindingConfigurations().add(new BindingConfiguration(MODULE_DEFAULT_MANAGED_EXECUTOR_SERVICE_JNDI_NAME, new LookupInjectionSource(managedExecutorService)));
            }
            if (managedScheduledExecutorService != null) {
                moduleDescription.getBindingConfigurations().add(new BindingConfiguration(MODULE_DEFAULT_MANAGED_SCHEDULED_EXECUTOR_SERVICE_JNDI_NAME, new LookupInjectionSource(managedScheduledExecutorService)));
            }
            if (managedThreadFactory != null) {
                moduleDescription.getBindingConfigurations().add(new BindingConfiguration(MODULE_DEFAULT_MANAGED_THREAD_FACTORY_JNDI_NAME, new LookupInjectionSource(managedThreadFactory)));
            }
        } else {
            for (ComponentDescription componentDescription : moduleDescription.getComponentDescriptions()) {
                if (componentDescription.getNamingMode() != ComponentNamingMode.CREATE) continue;
                if (contextService != null) {
                    componentDescription.getBindingConfigurations().add(new BindingConfiguration(COMP_DEFAULT_CONTEXT_SERVICE_JNDI_NAME, new LookupInjectionSource(contextService)));
                }
                if (managedExecutorService != null) {
                    componentDescription.getBindingConfigurations().add(new BindingConfiguration(COMP_DEFAULT_MANAGED_EXECUTOR_SERVICE_JNDI_NAME, new LookupInjectionSource(managedExecutorService)));
                }
                if (managedScheduledExecutorService != null) {
                    componentDescription.getBindingConfigurations().add(new BindingConfiguration(COMP_DEFAULT_MANAGED_SCHEDULED_EXECUTOR_SERVICE_JNDI_NAME, new LookupInjectionSource(managedScheduledExecutorService)));
                }
                if (managedThreadFactory == null) continue;
                componentDescription.getBindingConfigurations().add(new BindingConfiguration(COMP_DEFAULT_MANAGED_THREAD_FACTORY_JNDI_NAME, new LookupInjectionSource(managedThreadFactory)));
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

