/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.service;

import java.util.concurrent.TimeUnit;
import org.glassfish.enterprise.concurrent.AbstractManagedExecutorService;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedScheduledExecutorServiceAdapter;
import org.glassfish.enterprise.concurrent.ManagedScheduledExecutorServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.concurrent.service.EEConcurrentAbstractService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ManagedScheduledExecutorServiceService
extends EEConcurrentAbstractService<ManagedScheduledExecutorServiceAdapter> {
    private volatile ManagedScheduledExecutorServiceImpl executorService;
    private final String name;
    private final InjectedValue<ManagedThreadFactoryImpl> managedThreadFactoryInjectedValue;
    private final long hungTaskThreshold;
    private final boolean longRunningTasks;
    private final int corePoolSize;
    private final long keepAliveTime;
    private final TimeUnit keepAliveTimeUnit;
    private final long threadLifeTime;
    private final InjectedValue<ContextServiceImpl> contextService;
    private final AbstractManagedExecutorService.RejectPolicy rejectPolicy;

    public ManagedScheduledExecutorServiceService(String name, String jndiName, long hungTaskThreshold, boolean longRunningTasks, int corePoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, long threadLifeTime, AbstractManagedExecutorService.RejectPolicy rejectPolicy) {
        super(jndiName);
        this.name = name;
        this.managedThreadFactoryInjectedValue = new InjectedValue();
        this.hungTaskThreshold = hungTaskThreshold;
        this.longRunningTasks = longRunningTasks;
        this.corePoolSize = corePoolSize;
        this.keepAliveTime = keepAliveTime;
        this.keepAliveTimeUnit = keepAliveTimeUnit;
        this.threadLifeTime = threadLifeTime;
        this.contextService = new InjectedValue();
        this.rejectPolicy = rejectPolicy;
    }

    @Override
    void startValue(StartContext context) throws StartException {
        ManagedThreadFactoryImpl managedThreadFactory = (ManagedThreadFactoryImpl)this.managedThreadFactoryInjectedValue.getOptionalValue();
        if (managedThreadFactory == null) {
            String threadFactoryName = "EE-ManagedScheduledExecutorService-" + this.name;
            managedThreadFactory = new ManagedThreadFactoryImpl(threadFactoryName, null, 5);
        }
        this.executorService = new ManagedScheduledExecutorServiceImpl(this.name, managedThreadFactory, this.hungTaskThreshold, this.longRunningTasks, this.corePoolSize, this.keepAliveTime, this.keepAliveTimeUnit, this.threadLifeTime, (ContextServiceImpl)this.contextService.getOptionalValue(), this.rejectPolicy);
    }

    @Override
    void stopValue(StopContext context) {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            if (this.managedThreadFactoryInjectedValue.getOptionalValue() == null) {
                this.executorService.getManagedThreadFactory().stop();
            }
            this.executorService = null;
        }
    }

    public ManagedScheduledExecutorServiceAdapter getValue() throws IllegalStateException {
        if (this.executorService == null) {
            throw EeMessages.MESSAGES.concurrentServiceValueUninitialized();
        }
        return this.executorService.getAdapter();
    }

    public Injector<ManagedThreadFactoryImpl> getManagedThreadFactoryInjector() {
        return this.managedThreadFactoryInjectedValue;
    }

    public Injector<ContextServiceImpl> getContextServiceInjector() {
        return this.contextService;
    }
}

