/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.threadpool;

import org.jboss.logging.Logger;
import org.jboss.util.threadpool.TaskWrapper;

public class RunnableTaskWrapper
implements TaskWrapper {
    private static final Logger log = Logger.getLogger(RunnableTaskWrapper.class);
    private Runnable runnable;
    private boolean started;
    private Thread runThread;
    private long startTimeout;
    private long completionTimeout;

    public RunnableTaskWrapper(Runnable runnable) {
        this(runnable, 0L, 0L);
    }

    public RunnableTaskWrapper(Runnable runnable, long startTimeout, long completeTimeout) {
        if (runnable == null) {
            throw new IllegalArgumentException("Null runnable");
        }
        this.runnable = runnable;
        this.startTimeout = startTimeout;
        this.completionTimeout = completeTimeout;
    }

    @Override
    public int getTaskWaitType() {
        return 0;
    }

    @Override
    public int getTaskPriority() {
        return 5;
    }

    @Override
    public long getTaskStartTimeout() {
        return this.startTimeout;
    }

    @Override
    public long getTaskCompletionTimeout() {
        return this.completionTimeout;
    }

    @Override
    public void acceptTask() {
    }

    @Override
    public void rejectTask(RuntimeException t) {
        throw t;
    }

    @Override
    public void stopTask() {
        boolean trace = log.isTraceEnabled();
        if (this.runThread != null && !this.runThread.isInterrupted()) {
            this.runThread.interrupt();
            if (trace) {
                log.trace((Object)("stopTask, interrupted thread=" + this.runThread));
            }
        } else if (this.runThread != null) {
            this.runThread.stop();
            if (trace) {
                log.trace((Object)("stopTask, stopped thread=" + this.runThread));
            }
        }
    }

    @Override
    public void waitForTask() {
    }

    @Override
    public boolean isComplete() {
        return this.started && this.runThread == null;
    }

    @Override
    public void run() {
        boolean trace = log.isTraceEnabled();
        try {
            if (trace) {
                log.trace((Object)("Begin run, wrapper=" + this));
            }
            this.runThread = Thread.currentThread();
            this.started = true;
            this.runnable.run();
            this.runThread = null;
            if (trace) {
                log.trace((Object)("End run, wrapper=" + this));
            }
        }
        catch (Throwable t) {
            log.warn((Object)("Unhandled throwable for runnable: " + this.runnable), t);
        }
    }
}

