/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.HttpRequestParser;
import io.undertow.server.protocol.http.HttpServerConnection;
import io.undertow.server.protocol.http.HttpTransferEncoding;
import io.undertow.server.protocol.http.ParseState;
import io.undertow.util.StringWriteChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.XnioExecutor;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;

final class HttpReadListener
implements ChannelListener<StreamSourceChannel>,
ExchangeCompletionListener,
Runnable {
    private static final String BAD_REQUEST = "HTTP/1.1 400 Bad Request\r\nContent-Length: 0\r\nConnection: close\r\n\r\n";
    private final HttpServerConnection connection;
    private final ParseState state = new ParseState();
    private final HttpRequestParser parser;
    private HttpServerExchange httpServerExchange;
    private int read = 0;
    private final int maxRequestSize;
    private final long maxEntitySize;

    HttpReadListener(HttpServerConnection connection, HttpRequestParser parser) {
        this.connection = connection;
        this.parser = parser;
        this.maxRequestSize = connection.getUndertowOptions().get(UndertowOptions.MAX_HEADER_SIZE, 51200);
        this.maxEntitySize = connection.getUndertowOptions().get(UndertowOptions.MAX_ENTITY_SIZE, 0L);
    }

    public void newRequest() {
        this.state.reset();
        this.read = 0;
        this.httpServerExchange = new HttpServerExchange(this.connection, this.maxEntitySize);
        this.httpServerExchange.addExchangeCompleteListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(StreamSourceChannel channel) {
        Pooled existing = this.connection.getExtraBytes();
        Pooled pooled = existing == null ? this.connection.getBufferPool().allocate() : existing;
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        boolean free = true;
        try {
            do {
                int total;
                int res;
                if (existing == null) {
                    buffer.clear();
                    try {
                        res = channel.read(buffer);
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_IO_LOGGER.debug("Error reading request", e);
                        IoUtils.safeClose((Closeable)((Object)this.connection));
                        if (free) {
                            pooled.free();
                        }
                        return;
                    }
                } else {
                    res = buffer.remaining();
                }
                if (res == 0) {
                    if (!channel.isReadResumed()) {
                        channel.getReadSetter().set((ChannelListener)this);
                        channel.resumeReads();
                    }
                    return;
                }
                if (res == -1) {
                    try {
                        channel.suspendReads();
                        channel.shutdownReads();
                        ConduitStreamSinkChannel responseChannel = this.connection.getChannel().getSinkChannel();
                        responseChannel.shutdownWrites();
                        if (!responseChannel.flush()) {
                            responseChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                            responseChannel.resumeWrites();
                        }
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_IO_LOGGER.debug("Error reading request", e);
                        IoUtils.safeClose((Closeable)((Object)this.connection));
                        if (free) {
                            pooled.free();
                        }
                        return;
                    }
                    return;
                }
                if (existing != null) {
                    existing = null;
                    this.connection.setExtraBytes(null);
                } else {
                    buffer.flip();
                }
                this.parser.handle(buffer, this.state, this.httpServerExchange);
                if (buffer.hasRemaining()) {
                    free = false;
                    this.connection.setExtraBytes((Pooled<ByteBuffer>)pooled);
                }
                this.read = total = this.read + res;
                if (this.read <= this.maxRequestSize) continue;
                UndertowLogger.REQUEST_LOGGER.requestHeaderWasTooLarge(this.connection.getPeerAddress(), this.maxRequestSize);
                IoUtils.safeClose((Closeable)((Object)this.connection));
                return;
            } while (!this.state.isComplete());
            channel.getReadSetter().set(null);
            channel.suspendReads();
            HttpServerExchange httpServerExchange = this.httpServerExchange;
            httpServerExchange.putAttachment(UndertowOptions.ATTACHMENT_KEY, this.connection.getUndertowOptions());
            httpServerExchange.setRequestScheme(this.connection.getSslSession() != null ? "https" : "http");
            this.httpServerExchange = null;
            HttpTransferEncoding.setupRequest(httpServerExchange);
            HttpHandlers.executeRootHandler(this.connection.getRootHandler(), httpServerExchange, Thread.currentThread() instanceof XnioExecutor);
        }
        catch (Exception e) {
            this.sendBadRequestAndClose(this.connection.getChannel(), e);
            return;
        }
        finally {
            if (free) {
                pooled.free();
            }
        }
    }

    private void sendBadRequestAndClose(final StreamConnection channel, Exception exception) {
        UndertowLogger.REQUEST_IO_LOGGER.failedToParseRequest(exception);
        channel.getSourceChannel().suspendReads();
        new StringWriteChannelListener(BAD_REQUEST){

            @Override
            protected void writeDone(StreamSinkChannel c) {
                IoUtils.safeClose((Closeable)channel);
            }
        }.setup((StreamSinkChannel)channel.getSinkChannel());
    }

    @Override
    public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
        this.connection.resetChannel();
        HttpServerConnection connection = this.connection;
        if (exchange.isPersistent() && !exchange.isUpgrade()) {
            this.newRequest();
            StreamConnection channel = connection.getChannel();
            if (connection.getExtraBytes() == null) {
                channel.getSourceChannel().getReadSetter().set((ChannelListener)this);
                channel.getSourceChannel().resumeReads();
            } else {
                if (channel.getSourceChannel().isReadResumed()) {
                    channel.getSourceChannel().suspendReads();
                }
                if (exchange.isInIoThread()) {
                    channel.getIoThread().execute((Runnable)this);
                } else {
                    Executor executor = exchange.getDispatchExecutor();
                    if (executor == null) {
                        executor = exchange.getConnection().getWorker();
                    }
                    executor.execute(this);
                }
            }
        } else if (!exchange.isPersistent()) {
            IoUtils.safeClose((Closeable)((Object)connection));
        }
        nextListener.proceed();
    }

    @Override
    public void run() {
        this.handleEvent((StreamSourceChannel)this.connection.getChannel().getSourceChannel());
    }
}

