/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.LinkedList;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.mgmt.UndertowHttpManagementService;
import org.jboss.as.server.mgmt.domain.HttpManagement;
import org.jboss.as.web.host.CommonWebServer;
import org.jboss.as.web.host.WebHost;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.AccessLogService;
import org.wildfly.extension.undertow.ConsoleRedirectService;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.HostDefinition;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.WebHostService;

class HostAdd
extends AbstractAddStepHandler {
    static final HostAdd INSTANCE = new HostAdd();

    private HostAdd() {
        super(new AttributeDefinition[]{HostDefinition.ALIAS, HostDefinition.DEFAULT_WEB_MODULE});
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceController consoleServiceServiceController;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress parent = address.subAddress(0, address.size() - 1);
        String name = address.getLastElement().getValue();
        List aliases = HostDefinition.ALIAS.unwrap(context, model);
        String defaultWebModule = HostDefinition.DEFAULT_WEB_MODULE.resolveModelAttribute(context, model).asString();
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        Resource accessLog = resource.getChild(UndertowExtension.PATH_ACCESS_LOG);
        String serverName = parent.getLastElement().getValue();
        ServiceName virtualHostServiceName = UndertowService.virtualHostName(serverName, name);
        ServiceName accessLogServiceName = UndertowService.accessLogServiceName(serverName, name);
        Host service = new Host(name, aliases == null ? new LinkedList() : aliases, defaultWebModule);
        ServiceBuilder builder = context.getServiceTarget().addService(virtualHostServiceName, (Service)service).addDependency(UndertowService.SERVER.append(new String[]{serverName}), Server.class, service.getServerInjection()).addDependency(UndertowService.UNDERTOW, UndertowService.class, service.getUndertowService()).addDependency(accessLog != null ? ServiceBuilder.DependencyType.REQUIRED : ServiceBuilder.DependencyType.OPTIONAL, accessLogServiceName, AccessLogService.class, service.getAccessLogService());
        builder.addListener((ServiceListener)verificationHandler);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        ServiceController<WebHost> commonController = this.addCommonHost(context, verificationHandler, name, aliases, serverName, virtualHostServiceName);
        ServiceController serviceController = builder.install();
        ServiceName consoleRedirectName = UndertowService.consoleRedirectServiceName(serverName, name);
        if (context.getProcessType() == ProcessType.STANDALONE_SERVER) {
            ConsoleRedirectService redirectService = new ConsoleRedirectService();
            ServiceBuilder redirectBuilder = context.getServiceTarget().addService(consoleRedirectName, (Service)redirectService).addDependency(UndertowHttpManagementService.SERVICE_NAME, HttpManagement.class, redirectService.getHttpManagementInjector()).addDependency(virtualHostServiceName, Host.class, redirectService.getHostInjector()).setInitialMode(ServiceController.Mode.PASSIVE);
            consoleServiceServiceController = redirectBuilder.install();
        } else {
            ConsoleRedirectService redirectService = new ConsoleRedirectService();
            ServiceBuilder redirectBuilder = context.getServiceTarget().addService(consoleRedirectName, (Service)redirectService).addDependency(virtualHostServiceName, Host.class, redirectService.getHostInjector()).setInitialMode(ServiceController.Mode.PASSIVE);
            consoleServiceServiceController = redirectBuilder.install();
        }
        if (newControllers != null) {
            newControllers.add(serviceController);
            newControllers.add(consoleServiceServiceController);
            newControllers.add(commonController);
        }
    }

    private ServiceController<WebHost> addCommonHost(OperationContext context, ServiceVerificationHandler verificationHandler, String hostName, List<String> aliases, String serverName, ServiceName virtualHostServiceName) {
        WebHostService service = new WebHostService();
        ServiceBuilder builder = context.getServiceTarget().addService(WebHost.SERVICE_NAME.append(new String[]{hostName}), (Service)service).addDependency(UndertowService.SERVER.append(new String[]{serverName}), Server.class, service.getServer()).addDependency(CommonWebServer.SERVICE_NAME).addDependency(virtualHostServiceName, Host.class, service.getHost());
        if (aliases != null) {
            for (String alias : aliases) {
                builder.addAliases(new ServiceName[]{WebHost.SERVICE_NAME.append(new String[]{alias})});
            }
        }
        builder.addListener((ServiceListener)verificationHandler);
        builder.setInitialMode(ServiceController.Mode.PASSIVE);
        return builder.install();
    }
}

