/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import java.util.Map;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.CDIProvider;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.weld.Container;
import org.jboss.weld.Weld;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.Reflections;

public class WeldProvider
implements CDIProvider {
    private final Weld weld = new EnhancedWeld();

    public CDI<Object> getCDI() {
        return this.weld;
    }

    private static class EnhancedWeld
    extends Weld {
        private EnhancedWeld() {
        }

        protected BeanManagerImpl unsatisfiedBeanManager(String callerClassName) {
            BeanDeploymentArchiveImpl rootBda = this.findRootBda();
            if (rootBda == null) {
                return super.unsatisfiedBeanManager(callerClassName);
            }
            Class callingClass = null;
            try {
                callingClass = rootBda.getModule().getClassLoader().loadClass(callerClassName);
            }
            catch (ClassNotFoundException e) {
                return (BeanManagerImpl)Container.instance().beanDeploymentArchives().get(rootBda);
            }
            BeanManagerImpl additionalBdaManager = this.findBeanManagerForAdditionalBdaWithMatchingClassloader(callingClass.getClassLoader());
            if (additionalBdaManager != null) {
                return additionalBdaManager;
            }
            return (BeanManagerImpl)Container.instance().beanDeploymentArchives().get(rootBda);
        }

        private BeanDeploymentArchiveImpl findRootBda() {
            for (Map.Entry entry : Container.instance().beanDeploymentArchives().entrySet()) {
                BeanDeploymentArchiveImpl bda;
                if (!(entry.getKey() instanceof BeanDeploymentArchiveImpl) || !(bda = (BeanDeploymentArchiveImpl)Reflections.cast(entry.getKey())).isRoot()) continue;
                return bda;
            }
            return null;
        }

        private BeanManagerImpl findBeanManagerForAdditionalBdaWithMatchingClassloader(ClassLoader classLoader) {
            for (Map.Entry entry : Container.instance().beanDeploymentArchives().entrySet()) {
                BeanDeploymentArchiveImpl bda;
                if (!(entry.getKey() instanceof BeanDeploymentArchiveImpl) || !(bda = (BeanDeploymentArchiveImpl)Reflections.cast(entry.getKey())).getId().endsWith(".additionalClasses") || bda.getModule() == null || bda.getModule().getClassLoader() == null || !bda.getModule().getClassLoader().equals((Object)classLoader)) continue;
                return (BeanManagerImpl)entry.getValue();
            }
            return null;
        }
    }
}

