/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import org.jboss.weld.bootstrap.BeanDeploymentArchiveMapping;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.events.AbstractAnnotatedTypeRegisteringEvent;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.literal.InterceptorBindingTypeLiteral;
import org.jboss.weld.literal.NormalScopeLiteral;
import org.jboss.weld.literal.QualifierLiteral;
import org.jboss.weld.literal.ScopeLiteral;
import org.jboss.weld.literal.StereotypeLiteral;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.util.annotated.AnnotatedTypeWrapper;

public class BeforeBeanDiscoveryImpl
extends AbstractAnnotatedTypeRegisteringEvent
implements BeforeBeanDiscovery {
    public static void fire(BeanManagerImpl beanManager, Deployment deployment, BeanDeploymentArchiveMapping bdaMapping, Collection<ContextHolder<? extends Context>> contexts) {
        new BeforeBeanDiscoveryImpl(beanManager, deployment, bdaMapping, contexts).fire();
    }

    protected BeforeBeanDiscoveryImpl(BeanManagerImpl beanManager, Deployment deployment, BeanDeploymentArchiveMapping bdaMapping, Collection<ContextHolder<? extends Context>> contexts) {
        super(beanManager, (Type)((Object)BeforeBeanDiscovery.class), bdaMapping, deployment, contexts);
    }

    public void addQualifier(Class<? extends Annotation> bindingType) {
        this.getTypeStore().add(bindingType, (Annotation)QualifierLiteral.INSTANCE);
        ((ClassTransformer)this.getBeanManager().getServices().get(ClassTransformer.class)).clearAnnotationData(bindingType);
        ((MetaAnnotationStore)this.getBeanManager().getServices().get(MetaAnnotationStore.class)).clearAnnotationData(bindingType);
    }

    public void addInterceptorBinding(Class<? extends Annotation> bindingType, Annotation ... bindingTypeDef) {
        TypeStore typeStore = this.getTypeStore();
        typeStore.add(bindingType, (Annotation)InterceptorBindingTypeLiteral.INSTANCE);
        for (Annotation a : bindingTypeDef) {
            typeStore.add(bindingType, a);
        }
        ((ClassTransformer)this.getBeanManager().getServices().get(ClassTransformer.class)).clearAnnotationData(bindingType);
        ((MetaAnnotationStore)this.getBeanManager().getServices().get(MetaAnnotationStore.class)).clearAnnotationData(bindingType);
    }

    public void addScope(Class<? extends Annotation> scopeType, boolean normal, boolean passivating) {
        if (normal) {
            this.getTypeStore().add(scopeType, (Annotation)((Object)new NormalScopeLiteral(passivating)));
        } else {
            if (passivating) {
                throw BootstrapLogger.LOG.passivatingNonNormalScopeIllegal(scopeType);
            }
            this.getTypeStore().add(scopeType, (Annotation)ScopeLiteral.INSTANCE);
        }
        ((ClassTransformer)this.getBeanManager().getServices().get(ClassTransformer.class)).clearAnnotationData(scopeType);
        ((MetaAnnotationStore)this.getBeanManager().getServices().get(MetaAnnotationStore.class)).clearAnnotationData(scopeType);
        ((ReflectionCache)this.getBeanManager().getServices().get(ReflectionCache.class)).cleanup();
    }

    public void addStereotype(Class<? extends Annotation> stereotype, Annotation ... stereotypeDef) {
        TypeStore typeStore = this.getTypeStore();
        typeStore.add(stereotype, (Annotation)StereotypeLiteral.INSTANCE);
        for (Annotation a : stereotypeDef) {
            typeStore.add(stereotype, a);
        }
        ((ClassTransformer)this.getBeanManager().getServices().get(ClassTransformer.class)).clearAnnotationData(stereotype);
        ((MetaAnnotationStore)this.getBeanManager().getServices().get(MetaAnnotationStore.class)).clearAnnotationData(stereotype);
    }

    public void addAnnotatedType(AnnotatedType<?> source) {
        this.addAnnotatedType(source, null);
    }

    public void addAnnotatedType(AnnotatedType<?> type, String id) {
        this.addSyntheticAnnotatedType(type, id);
    }

    public void addQualifier(AnnotatedType<? extends Annotation> qualifier) {
        this.addSyntheticAnnotation(qualifier, (Annotation)QualifierLiteral.INSTANCE);
    }

    public void addInterceptorBinding(AnnotatedType<? extends Annotation> bindingType) {
        this.addSyntheticAnnotation(bindingType, (Annotation)InterceptorBindingTypeLiteral.INSTANCE);
    }

    private <A extends Annotation> void addSyntheticAnnotation(AnnotatedType<A> annotation, Annotation requiredMetaAnnotation) {
        if (requiredMetaAnnotation != null && !annotation.isAnnotationPresent(requiredMetaAnnotation.annotationType())) {
            annotation = new AnnotatedTypeWrapper<A>(annotation, requiredMetaAnnotation);
        }
        ((ClassTransformer)this.getBeanManager().getServices().get(ClassTransformer.class)).addSyntheticAnnotation(annotation, this.getBeanManager().getId());
        ((MetaAnnotationStore)this.getBeanManager().getServices().get(MetaAnnotationStore.class)).clearAnnotationData(annotation.getJavaClass());
    }
}

