/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.jboss.as.clustering.jgroups.LogFactory;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemDescribe;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemRootResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemXMLWriter;
import org.jboss.as.clustering.jgroups.subsystem.Namespace;
import org.jboss.as.clustering.jgroups.subsystem.PropertyResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RelayResource;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResource;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.RejectExpressionValuesTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class JGroupsExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "jgroups";
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"jgroups");
    public static final String RESOURCE_NAME = JGroupsExtension.class.getPackage().getName() + "." + "LocalDescriptions";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 2;
    private static final int MANAGEMENT_API_MINOR_VERSION = 0;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;

    static ResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, JGroupsExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, 2, 0, 0);
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        ManagementResourceRegistration subsystem = registration.registerSubsystemModel((ResourceDefinition)new JGroupsSubsystemRootResourceDefinition());
        subsystem.registerOperationHandler(JGroupsSubsystemDescribe.DEFINITON, (OperationStepHandler)JGroupsSubsystemDescribe.INSTANCE);
        subsystem.registerSubModel((ResourceDefinition)new StackResourceDefinition(registerRuntimeOnly));
        registration.registerXMLElementWriter((XMLElementWriter)new JGroupsSubsystemXMLWriter());
        if (context.isRegisterTransformers()) {
            JGroupsExtension.registerTransformers(registration);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace namespace : Namespace.values()) {
            XMLElementReader<List<ModelNode>> reader = namespace.getXMLReader();
            if (reader == null) continue;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, namespace.getUri(), reader);
        }
    }

    private static void registerTransformers(SubsystemRegistration subsystem) {
        JGroupsExtension.registerTransformers_1_1_0(subsystem);
        JGroupsExtension.registerTransformers_1_2_0(subsystem);
    }

    private static void registerTransformers_1_2_0(SubsystemRegistration subsystem) {
        ModelVersion version = ModelVersion.create((int)1, (int)2, (int)0);
        TransformersSubRegistration registration = subsystem.registerModelTransformers((ModelVersionRange)version, ResourceTransformer.DEFAULT);
        TransformersSubRegistration stack = registration.registerSubResource(StackResourceDefinition.STACK_PATH);
        JGroupsExtension.registerRelayTransformers(stack);
    }

    private static void registerTransformers_1_1_0(SubsystemRegistration subsystem) {
        RejectExpressionValuesTransformer transformer;
        ModelVersion version = ModelVersion.create((int)1, (int)1, (int)0);
        RejectExpressionValuesTransformer resourceTransformer = transformer = new RejectExpressionValuesTransformer(new AttributeDefinition[]{PropertyResourceDefinition.VALUE, TransportResourceDefinition.PROPERTIES, ProtocolResourceDefinition.PROPERTIES, TransportResourceDefinition.SHARED});
        TransformersSubRegistration registration = subsystem.registerModelTransformers((ModelVersionRange)version, ResourceTransformer.DEFAULT);
        TransformersSubRegistration stack = registration.registerSubResource(StackResourceDefinition.STACK_PATH);
        TransformersSubRegistration transport = stack.registerSubResource(TransportResourceDefinition.TRANSPORT_PATH, (ResourceTransformer)resourceTransformer);
        transport.registerOperationTransformer("add", (OperationTransformer)transformer);
        transport.registerOperationTransformer("write-attribute", transformer.getWriteAttributeTransformer());
        TransformersSubRegistration transport_property = transport.registerSubResource(PropertyResourceDefinition.PROPERTY_PATH);
        transport_property.registerOperationTransformer("add", (OperationTransformer)transformer);
        transport_property.registerOperationTransformer("write-attribute", transformer.getWriteAttributeTransformer());
        TransformersSubRegistration protocol = stack.registerSubResource(ProtocolResourceDefinition.PROTOCOL_PATH, (ResourceTransformer)resourceTransformer);
        protocol.registerOperationTransformer("add", (OperationTransformer)transformer);
        TransformersSubRegistration protocol_property = protocol.registerSubResource(PropertyResourceDefinition.PROPERTY_PATH);
        protocol_property.registerOperationTransformer("add", (OperationTransformer)transformer);
        protocol_property.registerOperationTransformer("write-attribute", transformer.getWriteAttributeTransformer());
        JGroupsExtension.registerRelayTransformers(stack);
    }

    private static void registerRelayTransformers(TransformersSubRegistration stack) {
        TransformersSubRegistration relay = stack.registerSubResource(RelayResource.PATH, true);
        relay.discardOperations(new String[]{"add", "write-attribute"});
        TransformersSubRegistration remoteSite = relay.registerSubResource(RemoteSiteResource.PATH, true);
        remoteSite.discardOperations(new String[]{"add", "write-attribute"});
    }

    static {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (System.getProperty("jgroups.logging.log_factory_class") == null) {
                    System.setProperty("jgroups.logging.log_factory_class", LogFactory.class.getName());
                }
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }
}

