/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.Property;
import org.jgroups.auth.AuthToken;
import org.jgroups.util.Util;

public class FixedMembershipToken
extends AuthToken {
    private List<String> memberList = null;
    private String token = "emptyToken";
    @Property
    private String fixed_members_seperator = ",";

    public FixedMembershipToken() {
    }

    public FixedMembershipToken(String token) {
        this.token = token;
    }

    @Override
    public String getName() {
        return "org.jgroups.auth.FixedMembershipToken";
    }

    @Property
    public void setFixedMembersSeparator(String value) {
        this.fixed_members_seperator = value;
    }

    @Override
    public boolean authenticate(AuthToken token, Message msg) {
        if (token != null && token instanceof FixedMembershipToken && this.memberList != null) {
            PhysicalAddress src = (PhysicalAddress)this.auth.down(new Event(87, msg.getSrc()));
            if (src == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("didn't find physical address for " + msg.getSrc());
                }
                return false;
            }
            String sourceAddressWithPort = src.toString();
            String sourceAddressWithoutPort = sourceAddressWithPort.substring(0, sourceAddressWithPort.indexOf(":"));
            if (this.log.isDebugEnabled()) {
                this.log.debug("AUTHToken received from " + sourceAddressWithPort);
            }
            for (String member : this.memberList) {
                if (!(FixedMembershipToken.hasPort(member) ? member.equals(sourceAddressWithPort) : member.equals(sourceAddressWithoutPort))) continue;
                return true;
            }
            return false;
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn("Invalid AuthToken instance - wrong type or null");
        }
        return false;
    }

    private static boolean hasPort(String member) {
        return member.contains(":");
    }

    @Property(name="fixed_members_value")
    public void setMemberList(String list) {
        this.memberList = new ArrayList<String>();
        StringTokenizer memberListTokenizer = new StringTokenizer(list, this.fixed_members_seperator);
        while (memberListTokenizer.hasMoreTokens()) {
            this.memberList.add(memberListTokenizer.nextToken().replace('/', ':'));
        }
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("SimpleToken writeTo()");
        }
        Util.writeString(this.token, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("SimpleToken readFrom()");
        }
        this.token = Util.readString(in);
    }

    @Override
    public int size() {
        return Util.size(this.token);
    }
}

