/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.txframework.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jboss.narayana.txframework.api.exception.TransactionDataUnavailableException;
import org.jboss.narayana.txframework.api.management.TXDataMap;

public class TXDataMapImpl<K, V>
implements TXDataMap<K, V> {
    static final ThreadLocal<Map> mapThreadLocal = new ThreadLocal();

    public static void resume(Map map) {
        mapThreadLocal.set(map);
    }

    public static void suspend() {
        mapThreadLocal.remove();
    }

    private Map<K, V> getMap() {
        if (mapThreadLocal.get() == null) {
            throw new TransactionDataUnavailableException("There is no transaction data associated with this thread");
        }
        return mapThreadLocal.get();
    }

    @Override
    public int size() {
        return this.getMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.getMap().containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.getMap().containsValue(o);
    }

    @Override
    public V get(Object key) {
        return this.getMap().get(key);
    }

    @Override
    public V put(K k, V v) {
        return this.getMap().put(k, v);
    }

    @Override
    public V remove(Object o) {
        return this.getMap().remove(o);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.getMap().putAll(map);
    }

    @Override
    public void clear() {
        this.getMap().clear();
    }

    @Override
    public Set<K> keySet() {
        return this.getMap().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.getMap().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.getMap().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.getMap()).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.getMap()).hashCode();
    }

    public static Map getState() {
        return mapThreadLocal.get();
    }

    public static boolean isActive() {
        return mapThreadLocal.get() != null;
    }
}

