/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.txframework.impl.handlers.restat.client;

import org.jboss.jbossts.star.util.TxSupport;
import org.jboss.narayana.txframework.impl.handlers.restat.client.TransactionRolledBackException;

public class UserTransaction {
    private static final String coordinatorUrl = UserTransaction.getBaseUrl() + "/rest-tx/tx/transaction-manager";
    private static ThreadLocal<TxSupport> threadTX = new ThreadLocal();

    public void begin() throws IllegalStateException {
        if (threadTX.get() != null) {
            throw new IllegalStateException("Transaction already running");
        }
        TxSupport txSupport = new TxSupport();
        txSupport.startTx();
        threadTX.set(txSupport);
    }

    public void commit() throws TransactionRolledBackException {
        if (threadTX.get() == null) {
            throw new IllegalStateException("Transaction not running");
        }
        TxSupport txSupport = threadTX.get();
        txSupport.commitTx();
        threadTX.remove();
    }

    public void rollback() {
        if (threadTX.get() == null) {
            throw new IllegalStateException("Transaction not running");
        }
        TxSupport txSupport = threadTX.get();
        txSupport.rollbackTx();
        threadTX.remove();
    }

    public static TxSupport getTXSupport() {
        return threadTX.get();
    }

    private static String getBaseUrl() {
        String baseAddress = System.getProperty("jboss.bind.address");
        String basePort = System.getProperty("jboss.bind.port");
        if (baseAddress == null) {
            baseAddress = "http://localhost";
        } else if (!baseAddress.toLowerCase().startsWith("http://") && !baseAddress.toLowerCase().startsWith("https://")) {
            baseAddress = "http://" + baseAddress;
        }
        if (basePort == null) {
            basePort = "8080";
        }
        return baseAddress + ":" + basePort;
    }
}

