/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.txframework.impl.handlers.restat.service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.HEAD;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.jbossts.star.util.TxStatus;
import org.jboss.jbossts.star.util.TxSupport;
import org.jboss.narayana.txframework.impl.Participant;
import org.jboss.narayana.txframework.impl.ServiceInvocationMeta;
import org.jboss.narayana.txframework.impl.handlers.ParticipantRegistrationException;
import org.jboss.narayana.txframework.impl.handlers.restat.service.RESTAT2PCParticipant;

@Path(value="/rest-participant-endpoint")
public class RestParticipantEndpointImpl {
    static final String PATH_SEGMENT = "rest-participant-endpoint";
    private static String FAIL_COMMIT;
    private static AtomicInteger currentParticipantId;
    private static Map<Integer, RESTAT2PCParticipant> participants;

    public static Participant enlistParticipant(String txid, UriInfo info, String enlistUrl, ServiceInvocationMeta serviceInvocationMeta) throws ParticipantRegistrationException {
        RestParticipantEndpointImpl.checkNotNull(info, "txid");
        RestParticipantEndpointImpl.checkNotNull(info, "info");
        RestParticipantEndpointImpl.checkNotNull(enlistUrl, "enlistUrl");
        RestParticipantEndpointImpl.checkNotNull(serviceInvocationMeta, "serviceImpl");
        int pid = currentParticipantId.getAndIncrement();
        RESTAT2PCParticipant participant = new RESTAT2PCParticipant(serviceInvocationMeta);
        participants.put(pid, participant);
        participant.resume();
        TxSupport txSupport = new TxSupport();
        String baseUrl = info.getBaseUri().toString() + PATH_SEGMENT;
        String linkHeader = txSupport.makeTwoPhaseAwareParticipantLinkHeader(baseUrl, txid, String.valueOf(pid));
        String recoveryUri = txSupport.enlistParticipant(enlistUrl, linkHeader);
        return participant;
    }

    private static void checkNotNull(Object object, String name) throws ParticipantRegistrationException {
        if (object == null) {
            throw new ParticipantRegistrationException(name + " is null");
        }
    }

    @PUT
    @Path(value="{txid}/{pId}/terminator")
    public Response terminate(@PathParam(value="pId") @DefaultValue(value="") Integer pId, String content) {
        RESTAT2PCParticipant participant = participants.get(pId);
        participant.resume();
        TxStatus status = TxSupport.toTxStatus((String)content);
        if (status.isPrepare()) {
            if (!participant.prepare()) {
                return Response.ok((Object)409).build();
            }
        } else if (status.isCommit()) {
            participant.commit();
        } else if (status.isAbort()) {
            participant.rollback();
        } else {
            return Response.status((int)400).build();
        }
        RESTAT2PCParticipant.suspend();
        return Response.ok((Object)TxSupport.toStatusContent((String)status.name())).build();
    }

    @HEAD
    @Path(value="{txid}/{pId}/participant")
    public Response getTerminator(@Context UriInfo info, @PathParam(value="pId") @DefaultValue(value="") String wId) {
        String serviceURL = info.getBaseUri() + info.getPath();
        String linkHeader = new TxSupport().makeTwoPhaseAwareParticipantLinkHeader(serviceURL, false, wId, null);
        return Response.ok().header("Link", (Object)linkHeader).build();
    }

    static {
        currentParticipantId = new AtomicInteger(0);
        participants = new ConcurrentHashMap<Integer, RESTAT2PCParticipant>();
    }
}

