/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQConnectionTimedOutException;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQInterruptedException;
import org.hornetq.api.core.HornetQNotConnectedException;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.FailoverEventListener;
import org.hornetq.api.core.client.FailoverEventType;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.api.core.client.SessionFailureListener;
import org.hornetq.core.client.HornetQClientLogger;
import org.hornetq.core.client.HornetQClientMessageBundle;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.ChannelHandler;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.PacketDecoder;
import org.hornetq.core.protocol.core.impl.RemotingConnectionImpl;
import org.hornetq.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage_V2;
import org.hornetq.core.protocol.core.impl.wireformat.DisconnectMessage;
import org.hornetq.core.protocol.core.impl.wireformat.NodeAnnounceMessage;
import org.hornetq.core.protocol.core.impl.wireformat.Ping;
import org.hornetq.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessageV2;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.spi.core.remoting.Connector;
import org.hornetq.spi.core.remoting.ConnectorFactory;
import org.hornetq.utils.ClassloadingUtil;
import org.hornetq.utils.ConcurrentHashSet;
import org.hornetq.utils.ConfigurationHelper;
import org.hornetq.utils.ConfirmationWindowWarning;
import org.hornetq.utils.ExecutorFactory;
import org.hornetq.utils.OrderedExecutorFactory;
import org.hornetq.utils.VersionLoader;

public class ClientSessionFactoryImpl
implements ClientSessionFactoryInternal,
ConnectionLifeCycleListener {
    private static final boolean isTrace = HornetQClientLogger.LOGGER.isTraceEnabled();
    private static final boolean isDebug = HornetQClientLogger.LOGGER.isDebugEnabled();
    private final ServerLocatorInternal serverLocator;
    private TransportConfiguration connectorConfig;
    private TransportConfiguration backupConfig;
    private ConnectorFactory connectorFactory;
    private transient boolean finalizeCheck = true;
    private final long callTimeout;
    private final long callFailoverTimeout;
    private final long clientFailureCheckPeriod;
    private final long connectionTTL;
    private final Set<ClientSessionInternal> sessions = new HashSet<ClientSessionInternal>();
    private final Object createSessionLock = new Object();
    private final Object failoverLock = new Object();
    private final Object connectionLock = new Object();
    private final ExecutorFactory orderedExecutorFactory;
    private final Executor threadPool;
    private final ScheduledExecutorService scheduledThreadPool;
    private final Executor closeExecutor;
    private CoreRemotingConnection connection;
    private final long retryInterval;
    private final double retryIntervalMultiplier;
    private final long maxRetryInterval;
    private int reconnectAttempts;
    private final Set<SessionFailureListener> listeners = new ConcurrentHashSet();
    private final Set<FailoverEventListener> failoverListeners = new ConcurrentHashSet();
    private Connector connector;
    private Future<?> pingerFuture;
    private PingRunnable pingRunnable;
    private volatile boolean exitLoop;
    private final Object inCreateSessionGuard = new Object();
    private boolean inCreateSession;
    private CountDownLatch inCreateSessionLatch;
    private final List<Interceptor> incomingInterceptors;
    private final List<Interceptor> outgoingInterceptors;
    private volatile boolean stopPingingAfterOne;
    private volatile boolean closed;
    public final Exception traceException = new Exception();
    private final CountDownLatch waitLatch = new CountDownLatch(1);
    public static final Set<CloseRunnable> CLOSE_RUNNABLES = Collections.synchronizedSet(new HashSet());
    private final PacketDecoder packetDecoder;
    private final ConfirmationWindowWarning confirmationWindowWarning;

    ClientSessionFactoryImpl(ServerLocatorInternal serverLocator, TransportConfiguration connectorConfig, long callTimeout, long callFailoverTimeout, long clientFailureCheckPeriod, long connectionTTL, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, Executor threadPool, ScheduledExecutorService scheduledThreadPool, List<Interceptor> incomingInterceptors, List<Interceptor> outgoingInterceptors, PacketDecoder packetDecoder) {
        this.traceException.fillInStackTrace();
        this.serverLocator = serverLocator;
        this.connectorConfig = connectorConfig;
        this.connectorFactory = this.instantiateConnectorFactory(connectorConfig.getFactoryClassName());
        this.checkTransportKeys(this.connectorFactory, connectorConfig.getParams());
        this.callTimeout = callTimeout;
        this.callFailoverTimeout = callFailoverTimeout;
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
        this.connectionTTL = connectionTTL;
        this.retryInterval = retryInterval;
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        this.maxRetryInterval = maxRetryInterval;
        this.reconnectAttempts = reconnectAttempts;
        this.scheduledThreadPool = scheduledThreadPool;
        this.threadPool = threadPool;
        this.orderedExecutorFactory = new OrderedExecutorFactory(threadPool);
        this.closeExecutor = this.orderedExecutorFactory.getExecutor();
        this.incomingInterceptors = incomingInterceptors;
        this.outgoingInterceptors = outgoingInterceptors;
        this.packetDecoder = packetDecoder;
        this.confirmationWindowWarning = new ConfirmationWindowWarning(serverLocator.getConfirmationWindowSize() < 0);
    }

    @Override
    public void disableFinalizeCheck() {
        this.finalizeCheck = false;
    }

    @Override
    public void connect(int initialConnectAttempts, boolean failoverOnInitialConnection) throws HornetQException {
        this.getConnectionWithRetry(initialConnectAttempts);
        if (this.connection == null) {
            StringBuilder msg = new StringBuilder("Unable to connect to server using configuration ").append(this.connectorConfig);
            if (this.backupConfig != null) {
                msg.append(" and backup configuration ").append(this.backupConfig);
            }
            throw new HornetQNotConnectedException(msg.toString());
        }
    }

    @Override
    public TransportConfiguration getConnectorConfiguration() {
        return this.connectorConfig;
    }

    @Override
    public void setBackupConnector(TransportConfiguration live, TransportConfiguration backUp) {
        Connector localConnector = this.connector;
        if (localConnector == null) {
            localConnector = this.connectorFactory.createConnector(this.connectorConfig.getParams(), new DelegatingBufferHandler(), this, this.closeExecutor, this.threadPool, this.scheduledThreadPool);
        }
        if (localConnector.isEquivalent(live.getParams()) && backUp != null && !localConnector.isEquivalent(backUp.getParams())) {
            if (isDebug) {
                HornetQClientLogger.LOGGER.debug("Setting up backup config = " + backUp + " for live = " + live);
            }
            this.backupConfig = backUp;
        } else if (isDebug) {
            HornetQClientLogger.LOGGER.debug("ClientSessionFactoryImpl received backup update for live/backup pair = " + live + " / " + backUp + " but it didn't belong to " + this.connectorConfig);
        }
    }

    @Override
    public Object getBackupConnector() {
        return this.backupConfig;
    }

    @Override
    public ClientSession createSession(String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int ackBatchSize) throws HornetQException {
        return this.createSessionInternal(username, password, xa, autoCommitSends, autoCommitAcks, preAcknowledge, ackBatchSize);
    }

    @Override
    public ClientSession createSession(boolean autoCommitSends, boolean autoCommitAcks, int ackBatchSize) throws HornetQException {
        return this.createSessionInternal(null, null, false, autoCommitSends, autoCommitAcks, this.serverLocator.isPreAcknowledge(), ackBatchSize);
    }

    @Override
    public ClientSession createXASession() throws HornetQException {
        return this.createSessionInternal(null, null, true, false, false, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
    }

    @Override
    public ClientSession createTransactedSession() throws HornetQException {
        return this.createSessionInternal(null, null, false, false, false, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
    }

    @Override
    public ClientSession createSession() throws HornetQException {
        return this.createSessionInternal(null, null, false, true, true, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
    }

    @Override
    public ClientSession createSession(boolean autoCommitSends, boolean autoCommitAcks) throws HornetQException {
        return this.createSessionInternal(null, null, false, autoCommitSends, autoCommitAcks, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
    }

    @Override
    public ClientSession createSession(boolean xa, boolean autoCommitSends, boolean autoCommitAcks) throws HornetQException {
        return this.createSessionInternal(null, null, xa, autoCommitSends, autoCommitAcks, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
    }

    @Override
    public ClientSession createSession(boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge) throws HornetQException {
        return this.createSessionInternal(null, null, xa, autoCommitSends, autoCommitAcks, preAcknowledge, this.serverLocator.getAckBatchSize());
    }

    @Override
    public void connectionCreated(HornetQComponent component, Connection connection, String protocol) {
    }

    @Override
    public void connectionDestroyed(final Object connectionID) {
        HornetQNotConnectedException ex = HornetQClientMessageBundle.BUNDLE.channelDisconnected();
        this.closeExecutor.execute(new Runnable((HornetQException)ex){
            final /* synthetic */ HornetQException val$ex;
            {
                this.val$ex = hornetQException;
            }

            @Override
            public void run() {
                ClientSessionFactoryImpl.this.handleConnectionFailure(connectionID, this.val$ex);
            }
        });
    }

    @Override
    public void connectionException(Object connectionID, HornetQException me) {
        this.handleConnectionFailure(connectionID, me);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(ClientSessionInternal session, boolean failingOver) {
        Set<ClientSessionInternal> set = this.sessions;
        synchronized (set) {
            this.sessions.remove(session);
        }
    }

    @Override
    public void connectionReadyForWrites(Object connectionID, boolean ready) {
    }

    @Override
    public synchronized int numConnections() {
        return this.connection != null ? 1 : 0;
    }

    @Override
    public int numSessions() {
        return this.sessions.size();
    }

    @Override
    public void addFailureListener(SessionFailureListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeFailureListener(SessionFailureListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void addFailoverListener(FailoverEventListener listener) {
        this.failoverListeners.add(listener);
    }

    @Override
    public boolean removeFailoverListener(FailoverEventListener listener) {
        return this.failoverListeners.remove(listener);
    }

    @Override
    public void causeExit() {
        this.exitLoop = true;
        this.waitLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptConnectAndCloseAllSessions(boolean close) {
        this.exitLoop = true;
        Object object = this.inCreateSessionGuard;
        synchronized (object) {
            if (this.inCreateSessionLatch != null) {
                this.inCreateSessionLatch.countDown();
            }
        }
        this.forceReturnChannel1();
        this.causeExit();
        object = this.createSessionLock;
        synchronized (object) {
            this.closeCleanSessions(close);
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCleanSessions(boolean close) {
        HashSet<ClientSessionInternal> sessionsToClose;
        Set<ClientSessionInternal> set = this.sessions;
        synchronized (set) {
            sessionsToClose = new HashSet<ClientSessionInternal>(this.sessions);
        }
        for (ClientSessionInternal session : sessionsToClose) {
            try {
                if (close) {
                    session.close();
                    continue;
                }
                session.cleanUp(false);
            }
            catch (Exception e1) {
                HornetQClientLogger.LOGGER.unableToCloseSession(e1);
            }
        }
        this.checkCloseConnection();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.interruptConnectAndCloseAllSessions(true);
        this.serverLocator.factoryClosed(this);
    }

    @Override
    public void cleanup() {
        if (this.closed) {
            return;
        }
        this.interruptConnectAndCloseAllSessions(false);
    }

    @Override
    public boolean isClosed() {
        return this.closed || this.serverLocator.isClosed();
    }

    @Override
    public ServerLocator getServerLocator() {
        return this.serverLocator;
    }

    public void stopPingingAfterOne() {
        this.stopPingingAfterOne = true;
    }

    private void handleConnectionFailure(Object connectionID, HornetQException me) {
        try {
            this.failoverOrReconnect(connectionID, me);
        }
        catch (HornetQInterruptedException e1) {
            HornetQClientLogger.LOGGER.debug(e1.getMessage(), e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failoverOrReconnect(Object connectionID, HornetQException me) {
        HashSet<ClientSessionInternal> sessionsToClose = null;
        if (this.exitLoop) {
            return;
        }
        Object object = this.failoverLock;
        synchronized (object) {
            if (this.connection == null || this.connection.getID() != connectionID || this.exitLoop) {
                return;
            }
            if (isTrace) {
                HornetQClientLogger.LOGGER.trace("Client Connection failed, calling failure listeners and trying to reconnect, reconnectAttempts=" + this.reconnectAttempts);
            }
            this.callFailoverListeners(FailoverEventType.FAILURE_DETECTED);
            this.callSessionFailureListeners(me, false, false);
            if (this.reconnectAttempts != 0) {
                if (this.lockChannel1()) {
                    CountDownLatch exitLockLatch;
                    boolean needToInterrupt;
                    Object object2 = this.inCreateSessionGuard;
                    synchronized (object2) {
                        needToInterrupt = this.inCreateSession;
                        exitLockLatch = this.inCreateSessionLatch;
                    }
                    this.unlockChannel1();
                    if (needToInterrupt) {
                        this.forceReturnChannel1();
                        while (this.inCreateSession && !this.exitLoop) {
                            try {
                                exitLockLatch.await(500L, TimeUnit.MILLISECONDS);
                            }
                            catch (InterruptedException e1) {
                                throw new HornetQInterruptedException((Throwable)e1);
                            }
                        }
                    }
                    CoreRemotingConnection oldConnection = this.connection;
                    this.connection = null;
                    Connector localConnector = this.connector;
                    if (localConnector != null) {
                        try {
                            localConnector.close();
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                    this.cancelScheduledTasks();
                    this.connector = null;
                    this.reconnectSessions(oldConnection, this.reconnectAttempts);
                    if (oldConnection != null) {
                        oldConnection.destroy();
                    }
                    if (this.connection != null) {
                        this.callFailoverListeners(FailoverEventType.FAILOVER_COMPLETED);
                    }
                }
            } else {
                CoreRemotingConnection connectionToDestory = this.connection;
                if (connectionToDestory != null) {
                    connectionToDestory.destroy();
                }
                this.connection = null;
            }
            if (this.connection == null) {
                Set<ClientSessionInternal> connectionToDestory = this.sessions;
                synchronized (connectionToDestory) {
                    sessionsToClose = new HashSet<ClientSessionInternal>(this.sessions);
                }
                this.callFailoverListeners(FailoverEventType.FAILOVER_FAILED);
                this.callSessionFailureListeners(me, true, false);
            }
        }
        if (this.connection != null) {
            this.callSessionFailureListeners(me, true, true);
        }
        if (sessionsToClose != null) {
            for (ClientSessionInternal session : sessionsToClose) {
                try {
                    session.cleanUp(true);
                }
                catch (Exception cause) {
                    HornetQClientLogger.LOGGER.failedToCleanupSession(cause);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private ClientSession createSessionInternal(String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int ackBatchSize) throws HornetQException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void callSessionFailureListeners(HornetQException me, boolean afterReconnect, boolean failedOver) {
        ArrayList<SessionFailureListener> listenersClone = new ArrayList<SessionFailureListener>(this.listeners);
        for (SessionFailureListener listener : listenersClone) {
            try {
                if (afterReconnect) {
                    listener.connectionFailed(me, failedOver);
                    continue;
                }
                listener.beforeReconnect(me);
            }
            catch (Throwable t) {
                HornetQClientLogger.LOGGER.failedToExecuteListener(t);
            }
        }
    }

    private void callFailoverListeners(FailoverEventType type) {
        ArrayList<FailoverEventListener> listenersClone = new ArrayList<FailoverEventListener>(this.failoverListeners);
        for (FailoverEventListener listener : listenersClone) {
            try {
                listener.failoverEvent(type);
            }
            catch (Throwable t) {
                HornetQClientLogger.LOGGER.failedToExecuteListener(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnectSessions(CoreRemotingConnection oldConnection, int reconnectAttempts) {
        HashSet<ClientSessionInternal> sessionsToFailover;
        Set<ClientSessionInternal> set = this.sessions;
        synchronized (set) {
            sessionsToFailover = new HashSet<ClientSessionInternal>(this.sessions);
        }
        for (ClientSessionInternal session : sessionsToFailover) {
            session.preHandleFailover(this.connection);
        }
        this.getConnectionWithRetry(reconnectAttempts);
        if (this.connection == null) {
            if (!this.exitLoop) {
                HornetQClientLogger.LOGGER.failedToConnectToServer();
            }
            return;
        }
        List<FailureListener> oldListeners = oldConnection.getFailureListeners();
        ArrayList<FailureListener> newListeners = new ArrayList<FailureListener>(this.connection.getFailureListeners());
        for (FailureListener listener : oldListeners) {
            if (listener instanceof DelegatingFailureListener) continue;
            newListeners.add(listener);
        }
        this.connection.setFailureListeners(newListeners);
        for (ClientSessionInternal session : sessionsToFailover) {
            session.handleFailover(this.connection);
        }
    }

    private void getConnectionWithRetry(int reconnectAttempts) {
        if (this.exitLoop) {
            return;
        }
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("getConnectionWithRetry::" + reconnectAttempts + " with retryInterval = " + this.retryInterval + " multiplier = " + this.retryIntervalMultiplier, new Exception("trace"));
        }
        long interval = this.retryInterval;
        int count = 0;
        while (!this.exitLoop) {
            if (isDebug) {
                HornetQClientLogger.LOGGER.debug("Trying reconnection attempt " + count + "/" + reconnectAttempts);
            }
            this.getConnection();
            if (this.connection == null) {
                if (reconnectAttempts != 0) {
                    if (reconnectAttempts != -1 && ++count == reconnectAttempts) {
                        if (reconnectAttempts != 1) {
                            HornetQClientLogger.LOGGER.failedToConnectToServer(reconnectAttempts);
                        } else if (reconnectAttempts == 1) {
                            HornetQClientLogger.LOGGER.debug("Trying to connect towards " + this);
                        }
                        return;
                    }
                    if (isTrace) {
                        HornetQClientLogger.LOGGER.waitingForRetry(interval, this.retryInterval, this.retryIntervalMultiplier);
                    }
                    try {
                        if (this.waitLatch.await(interval, TimeUnit.MILLISECONDS)) {
                            return;
                        }
                    }
                    catch (InterruptedException ignore) {
                        throw new HornetQInterruptedException((Throwable)this.traceException);
                    }
                    long newInterval = (long)((double)interval * this.retryIntervalMultiplier);
                    if (newInterval > this.maxRetryInterval) {
                        newInterval = this.maxRetryInterval;
                    }
                    interval = newInterval;
                    continue;
                }
                HornetQClientLogger.LOGGER.debug("Could not connect to any server. Didn't have reconnection configured on the ClientSessionFactory");
                return;
            }
            if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
                HornetQClientLogger.LOGGER.debug("Reconnection successful");
            }
            return;
        }
    }

    private void cancelScheduledTasks() {
        PingRunnable pingRunnableLocal;
        Future<?> pingerFutureLocal = this.pingerFuture;
        if (pingerFutureLocal != null) {
            pingerFutureLocal.cancel(false);
        }
        if ((pingRunnableLocal = this.pingRunnable) != null) {
            pingRunnableLocal.cancel();
        }
        this.pingerFuture = null;
        this.pingRunnable = null;
    }

    private void checkCloseConnection() {
        if (this.connection != null && this.sessions.size() == 0) {
            this.cancelScheduledTasks();
            try {
                this.connection.destroy();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            this.connection = null;
            try {
                if (this.connector != null) {
                    this.connector.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoreRemotingConnection getConnection() {
        if (this.closed) {
            throw new IllegalStateException("ClientSessionFactory is closed!");
        }
        if (this.exitLoop) {
            return null;
        }
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.connection == null) {
                Connection tc;
                block38: {
                    tc = null;
                    try {
                        DelegatingBufferHandler handler = new DelegatingBufferHandler();
                        this.connector = this.connectorFactory.createConnector(this.connectorConfig.getParams(), handler, this, this.closeExecutor, this.threadPool, this.scheduledThreadPool);
                        if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
                            HornetQClientLogger.LOGGER.debug("Trying to connect with connector = " + this.connectorFactory + ", parameters = " + this.connectorConfig.getParams() + " connector = " + this.connector);
                        }
                        if (this.connector != null) {
                            this.connector.start();
                            if (isDebug) {
                                HornetQClientLogger.LOGGER.debug("Trying to connect at the main server using connector :" + this.connectorConfig);
                            }
                            if ((tc = this.connector.createConnection()) == null) {
                                if (isDebug) {
                                    HornetQClientLogger.LOGGER.debug("Main server is not up. Hopefully there's a backup configured now!");
                                }
                                try {
                                    this.connector.close();
                                }
                                catch (Throwable t) {
                                    // empty catch block
                                }
                                this.connector = null;
                            }
                        }
                        if (this.connector != null) break block38;
                        if (this.backupConfig != null) {
                            if (isDebug) {
                                HornetQClientLogger.LOGGER.debug("Trying backup config = " + this.backupConfig);
                            }
                            ConnectorFactory backupConnectorFactory = this.instantiateConnectorFactory(this.backupConfig.getFactoryClassName());
                            this.connector = backupConnectorFactory.createConnector(this.backupConfig.getParams(), handler, this, this.closeExecutor, this.threadPool, this.scheduledThreadPool);
                            if (this.connector == null) break block38;
                            this.connector.start();
                            tc = this.connector.createConnection();
                            if (tc == null) {
                                if (isDebug) {
                                    HornetQClientLogger.LOGGER.debug("Backup is not active yet");
                                }
                                try {
                                    this.connector.close();
                                }
                                catch (Throwable t) {
                                    // empty catch block
                                }
                                this.connector = null;
                                break block38;
                            }
                            if (isDebug) {
                                HornetQClientLogger.LOGGER.debug("Connected to the backup at " + this.backupConfig);
                            }
                            this.connectorConfig = this.backupConfig;
                            this.backupConfig = null;
                            this.connectorFactory = backupConnectorFactory;
                            break block38;
                        }
                        if (isTrace) {
                            HornetQClientLogger.LOGGER.trace("No Backup configured!", new Exception("trace"));
                        }
                    }
                    catch (Exception cause) {
                        HornetQClientLogger.LOGGER.createConnectorException(cause);
                        if (tc != null) {
                            try {
                                tc.close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        if (this.connector != null) {
                            try {
                                this.connector.close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        tc = null;
                        this.connector = null;
                    }
                }
                if (tc == null) {
                    if (isTrace) {
                        HornetQClientLogger.LOGGER.trace("returning connection = " + this.connection + " as tc == null");
                    }
                    return this.connection;
                }
                this.connection = new RemotingConnectionImpl(this.packetDecoder, tc, this.callTimeout, this.callFailoverTimeout, this.incomingInterceptors, this.outgoingInterceptors);
                this.connection.addFailureListener(new DelegatingFailureListener(this.connection.getID()));
                Channel channel0 = this.connection.getChannel(0L, -1);
                channel0.setHandler(new Channel0Handler(this.connection));
                if (this.clientFailureCheckPeriod != -1L) {
                    if (this.pingerFuture == null) {
                        this.pingRunnable = new PingRunnable();
                        this.pingerFuture = this.scheduledThreadPool.scheduleWithFixedDelay(new ActualScheduledPinger(this.pingRunnable), 0L, this.clientFailureCheckPeriod, TimeUnit.MILLISECONDS);
                        this.pingRunnable.send();
                    } else {
                        this.pingRunnable.run();
                    }
                }
                if (this.serverLocator.getTopology() != null) {
                    if (isTrace) {
                        HornetQClientLogger.LOGGER.trace(this + "::Subscribing Topology");
                    }
                    channel0.send(new SubscribeClusterTopologyUpdatesMessageV2(this.serverLocator.isClusterConnection(), VersionLoader.getVersion().getIncrementingVersion()));
                }
            }
            if (this.serverLocator.getAfterConnectInternalListener() != null) {
                this.serverLocator.getAfterConnectInternalListener().onConnection(this);
            }
            if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
                HornetQClientLogger.LOGGER.trace("returning " + this.connection);
            }
            return this.connection;
        }
    }

    @Override
    public void sendNodeAnnounce(long currentEventID, String nodeID, String nodeName, boolean isBackup, TransportConfiguration config, TransportConfiguration backupConfig) {
        Channel channel0 = this.connection.getChannel(0L, -1);
        if (isDebug) {
            HornetQClientLogger.LOGGER.debug("Announcing node " + this.serverLocator.getNodeID() + ", isBackup=" + isBackup);
        }
        channel0.send(new NodeAnnounceMessage(currentEventID, nodeID, nodeName, isBackup, config, backupConfig));
    }

    protected void finalize() throws Throwable {
        if (!this.closed && this.finalizeCheck) {
            HornetQClientLogger.LOGGER.factoryLeftOpen(this.traceException, System.identityHashCode(this));
            this.close();
        }
        super.finalize();
    }

    private ConnectorFactory instantiateConnectorFactory(final String connectorFactoryClassName) {
        return AccessController.doPrivileged(new PrivilegedAction<ConnectorFactory>(){

            @Override
            public ConnectorFactory run() {
                return (ConnectorFactory)ClassloadingUtil.newInstanceFromClassLoader((String)connectorFactoryClassName);
            }
        });
    }

    private boolean lockChannel1() {
        CoreRemotingConnection connection0 = this.connection;
        if (connection0 == null) {
            return false;
        }
        Channel channel1 = connection0.getChannel(1L, -1);
        if (channel1 == null) {
            return false;
        }
        try {
            while (!channel1.getLock().tryLock(200L, TimeUnit.MILLISECONDS)) {
                if (!this.exitLoop) continue;
                return false;
            }
            return true;
        }
        catch (InterruptedException cause) {
            return false;
        }
    }

    private void unlockChannel1() {
        Channel channel1;
        if (this.connection != null && (channel1 = this.connection.getChannel(1L, -1)) != null) {
            channel1.getLock().unlock();
        }
    }

    private void forceReturnChannel1() {
        Channel channel1;
        if (this.connection != null && (channel1 = this.connection.getChannel(1L, -1)) != null) {
            channel1.returnBlocking();
        }
    }

    private void checkTransportKeys(ConnectorFactory factory, Map<String, Object> params) {
        Set<String> invalid;
        if (params != null && !(invalid = ConfigurationHelper.checkKeys(factory.getAllowableProperties(), params.keySet())).isEmpty()) {
            String msg = "The following keys are invalid for configuring a connector: " + ConfigurationHelper.stringSetToCommaListString(invalid);
            throw new IllegalStateException(msg);
        }
    }

    public String toString() {
        return "ClientSessionFactoryImpl [serverLocator=" + this.serverLocator + ", connectorConfig=" + this.connectorConfig + ", backupConfig=" + this.backupConfig + "]";
    }

    @Override
    public void setReconnectAttempts(int attempts) {
        this.reconnectAttempts = attempts;
    }

    @Override
    public Object getConnector() {
        return this.connector;
    }

    @Override
    public ConfirmationWindowWarning getConfirmationWindowWarning() {
        return this.confirmationWindowWarning;
    }

    private final class PingRunnable
    implements Runnable {
        private boolean cancelled;
        private boolean first;
        private long lastCheck = System.currentTimeMillis();

        private PingRunnable() {
        }

        @Override
        public synchronized void run() {
            if (this.cancelled || ClientSessionFactoryImpl.this.stopPingingAfterOne && !this.first) {
                return;
            }
            this.first = false;
            long now = System.currentTimeMillis();
            if (ClientSessionFactoryImpl.this.clientFailureCheckPeriod != -1L && ClientSessionFactoryImpl.this.connectionTTL != -1L && now >= this.lastCheck + ClientSessionFactoryImpl.this.connectionTTL) {
                if (!ClientSessionFactoryImpl.this.connection.checkDataReceived()) {
                    HornetQConnectionTimedOutException me = HornetQClientMessageBundle.BUNDLE.connectionTimedOut(ClientSessionFactoryImpl.this.connection.getTransportConnection());
                    this.cancelled = true;
                    ClientSessionFactoryImpl.this.threadPool.execute(new Runnable((HornetQException)me){
                        final /* synthetic */ HornetQException val$me;
                        {
                            this.val$me = hornetQException;
                        }

                        @Override
                        public void run() {
                            ClientSessionFactoryImpl.this.connection.fail(this.val$me);
                        }
                    });
                    return;
                }
                this.lastCheck = now;
            }
            this.send();
        }

        public void send() {
            Ping ping = new Ping(ClientSessionFactoryImpl.this.connectionTTL);
            Channel channel0 = ClientSessionFactoryImpl.this.connection.getChannel(0L, -1);
            channel0.send(ping);
            ClientSessionFactoryImpl.this.connection.flush();
        }

        public synchronized void cancel() {
            this.cancelled = true;
        }
    }

    private static final class ActualScheduledPinger
    implements Runnable {
        private final WeakReference<PingRunnable> pingRunnable;

        ActualScheduledPinger(PingRunnable runnable) {
            this.pingRunnable = new WeakReference<PingRunnable>(runnable);
        }

        @Override
        public void run() {
            PingRunnable runnable = (PingRunnable)this.pingRunnable.get();
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    private final class DelegatingFailureListener
    implements FailureListener {
        private final Object connectionID;

        DelegatingFailureListener(Object connectionID) {
            this.connectionID = connectionID;
        }

        @Override
        public void connectionFailed(HornetQException me, boolean failedOver) {
            ClientSessionFactoryImpl.this.handleConnectionFailure(this.connectionID, me);
        }

        public String toString() {
            return DelegatingFailureListener.class.getSimpleName() + "('reconnectsOrFailover', hash=" + super.hashCode() + ")";
        }
    }

    private class DelegatingBufferHandler
    implements BufferHandler {
        private DelegatingBufferHandler() {
        }

        @Override
        public void bufferReceived(Object connectionID, HornetQBuffer buffer) {
            CoreRemotingConnection theConn = ClientSessionFactoryImpl.this.connection;
            if (theConn != null && connectionID == theConn.getID()) {
                theConn.bufferReceived(connectionID, buffer);
            }
        }
    }

    public class CloseRunnable
    implements Runnable {
        private final CoreRemotingConnection conn;

        private CloseRunnable(CoreRemotingConnection conn) {
            this.conn = conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CLOSE_RUNNABLES.add(this);
                this.conn.fail((HornetQException)HornetQClientMessageBundle.BUNDLE.disconnected());
            }
            finally {
                CLOSE_RUNNABLES.remove(this);
            }
        }

        public ClientSessionFactoryImpl stop() {
            ClientSessionFactoryImpl.this.causeExit();
            CLOSE_RUNNABLES.remove(this);
            return ClientSessionFactoryImpl.this;
        }
    }

    private final class Channel0Handler
    implements ChannelHandler {
        private final CoreRemotingConnection conn;

        private Channel0Handler(CoreRemotingConnection conn) {
            this.conn = conn;
        }

        @Override
        public void handlePacket(Packet packet) {
            byte type = packet.getType();
            if (type == 11) {
                DisconnectMessage msg = (DisconnectMessage)packet;
                SimpleString nodeID = msg.getNodeID();
                if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
                    HornetQClientLogger.LOGGER.trace("Disconnect being called on client:" + msg + " server locator = " + ClientSessionFactoryImpl.this.serverLocator + " notifying node " + nodeID + " as down", new Exception("trace"));
                }
                if (nodeID != null) {
                    ClientSessionFactoryImpl.this.serverLocator.notifyNodeDown(System.currentTimeMillis(), msg.getNodeID().toString());
                }
                ClientSessionFactoryImpl.this.closeExecutor.execute(new CloseRunnable(this.conn));
            } else if (type == 110) {
                ClusterTopologyChangeMessage topMessage = (ClusterTopologyChangeMessage)packet;
                this.notifyTopologyChange(topMessage);
            } else if (type == 114) {
                ClusterTopologyChangeMessage_V2 topMessage = (ClusterTopologyChangeMessage_V2)packet;
                this.notifyTopologyChange(topMessage);
            }
        }

        private void notifyTopologyChange(final ClusterTopologyChangeMessage topMessage) {
            ClientSessionFactoryImpl.this.threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    Pair transportConfig;
                    String nodeName;
                    long eventUID;
                    if (topMessage instanceof ClusterTopologyChangeMessage_V2) {
                        eventUID = ((ClusterTopologyChangeMessage_V2)topMessage).getUniqueEventID();
                        nodeName = ((ClusterTopologyChangeMessage_V2)topMessage).getNodeName();
                    } else {
                        eventUID = System.currentTimeMillis();
                        nodeName = null;
                    }
                    if (topMessage.isExit()) {
                        if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
                            HornetQClientLogger.LOGGER.debug("Notifying " + topMessage.getNodeID() + " going down");
                        }
                        ClientSessionFactoryImpl.this.serverLocator.notifyNodeDown(eventUID, topMessage.getNodeID());
                        return;
                    }
                    if (isTrace) {
                        HornetQClientLogger.LOGGER.trace("Node " + topMessage.getNodeID() + " going up, connector = " + topMessage.getPair() + ", isLast=" + topMessage.isLast() + " csf created at\nserverLocator=" + ClientSessionFactoryImpl.this.serverLocator, ClientSessionFactoryImpl.this.traceException);
                    }
                    if ((transportConfig = topMessage.getPair()).getA() == null && transportConfig.getB() == null) {
                        transportConfig = new Pair((Object)Channel0Handler.this.conn.getTransportConnection().getConnectorConfig(), null);
                    }
                    ClientSessionFactoryImpl.this.serverLocator.notifyNodeUp(eventUID, topMessage.getNodeID(), nodeName, (Pair<TransportConfiguration, TransportConfiguration>)transportConfig, topMessage.isLast());
                }
            });
        }
    }
}

