/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import org.infinispan.Cache;
import org.infinispan.io.FileChunkMapper;
import org.infinispan.io.GridFile;
import org.infinispan.io.ModularArithmetic;

public class WritableGridFileChannel
implements WritableByteChannel {
    private int position;
    private int localIndex;
    private byte[] currentBuffer;
    private boolean closed;
    private final FileChunkMapper fileChunkMapper;
    private final int chunkSize;
    private GridFile file;

    WritableGridFileChannel(GridFile file, Cache<String, byte[]> cache, boolean append) {
        this.fileChunkMapper = new FileChunkMapper(file, cache);
        this.chunkSize = this.fileChunkMapper.getChunkSize();
        this.file = file;
        if (append) {
            this.initForAppending();
        } else {
            this.initForOverwriting();
        }
    }

    private void initForOverwriting() {
        this.currentBuffer = this.createEmptyChunk();
        this.position = 0;
        this.localIndex = 0;
    }

    private void initForAppending() {
        this.currentBuffer = this.lastChunkIsFull() ? this.createEmptyChunk() : this.fetchLastChunk();
        this.position = (int)this.file.length();
        this.localIndex = ModularArithmetic.mod(this.position, this.chunkSize);
    }

    private byte[] createEmptyChunk() {
        return new byte[this.chunkSize];
    }

    private byte[] fetchLastChunk() {
        byte[] chunk = this.fileChunkMapper.fetchChunk(this.getLastChunkNumber());
        return this.createFullSizeCopy(chunk);
    }

    private int getLastChunkNumber() {
        return this.getChunkNumber((int)this.file.length() - 1);
    }

    private byte[] createFullSizeCopy(byte[] val) {
        byte[] chunk = this.createEmptyChunk();
        if (val != null) {
            System.arraycopy(val, 0, chunk, 0, val.length);
        }
        return chunk;
    }

    private boolean lastChunkIsFull() {
        return ModularArithmetic.mod(this.file.length(), this.chunkSize) == 0L;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.checkOpen();
        int bytesWritten = 0;
        while (src.remaining() > 0) {
            int bytesWrittenToChunk = this.writeToChunk(src);
            bytesWritten += bytesWrittenToChunk;
        }
        return bytesWritten;
    }

    private int writeToChunk(ByteBuffer src) throws IOException {
        int remainingInChunk = this.getBytesRemainingInChunk();
        if (remainingInChunk == 0) {
            this.flush();
            this.localIndex = 0;
            remainingInChunk = this.chunkSize;
        }
        int bytesToWrite = Math.min(remainingInChunk, src.remaining());
        src.get(this.currentBuffer, this.localIndex, bytesToWrite);
        this.localIndex += bytesToWrite;
        this.position += bytesToWrite;
        return bytesToWrite;
    }

    private int getBytesRemainingInChunk() {
        return this.currentBuffer.length - this.localIndex;
    }

    public void flush() throws IOException {
        this.storeChunkInCache();
        this.updateFileLength();
    }

    private void updateFileLength() {
        this.file.setLength(this.position);
    }

    private void storeChunkInCache() {
        this.fileChunkMapper.storeChunk(this.getChunkNumberOfPreviousByte(), this.currentBuffer, this.localIndex);
    }

    private int getChunkNumberOfPreviousByte() {
        return this.getChunkNumber(this.position - 1);
    }

    private int getChunkNumber(int position) {
        return position / this.chunkSize;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.localIndex = 0;
        this.position = 0;
        this.closed = true;
    }

    private void checkOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }
}

