/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.async;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.GuardedBy;
import org.infinispan.Cache;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.CacheLoaderException;
import org.infinispan.persistence.async.BufferLock;
import org.infinispan.persistence.async.State;
import org.infinispan.persistence.modifications.Modification;
import org.infinispan.persistence.modifications.Remove;
import org.infinispan.persistence.modifications.Store;
import org.infinispan.persistence.spi.CacheWriter;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.support.DelegatingCacheWriter;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AsyncCacheWriter
extends DelegatingCacheWriter {
    private static final Log log = LogFactory.getLog(AsyncCacheWriter.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final AtomicInteger threadId = new AtomicInteger(0);
    private ExecutorService executor;
    private Thread coordinator;
    private int concurrencyLevel;
    private long shutdownTimeout;
    private String cacheName;
    protected BufferLock stateLock;
    @GuardedBy(value="stateLock")
    protected final AtomicReference<State> state = new AtomicReference();
    protected AsyncStoreConfiguration asyncConfiguration;

    public AsyncCacheWriter(CacheWriter delegate) {
        super(delegate);
    }

    @Override
    public void init(InitializationContext ctx) {
        super.init(ctx);
        this.asyncConfiguration = ctx.getConfiguration().async();
        Cache cache = ctx.getCache();
        Configuration cacheCfg = cache != null ? cache.getCacheConfiguration() : null;
        this.concurrencyLevel = cacheCfg != null ? cacheCfg.locking().concurrencyLevel() : 16;
        long cacheStopTimeout = cacheCfg != null ? cacheCfg.transaction().cacheStopTimeout() : 30000L;
        Long configuredAsyncStopTimeout = this.asyncConfiguration.shutdownTimeout();
        String string = this.cacheName = cache != null ? cache.getName() : null;
        if (configuredAsyncStopTimeout >= cacheStopTimeout) {
            this.shutdownTimeout = Math.round((double)cacheStopTimeout * 0.9);
            log.asyncStoreShutdownTimeoutTooHigh(configuredAsyncStopTimeout, cacheStopTimeout, this.shutdownTimeout);
        } else {
            this.shutdownTimeout = configuredAsyncStopTimeout;
        }
    }

    @Override
    public void start() {
        log.debugf("Async cache loader starting %s", this);
        this.state.set(this.newState(false, null));
        this.stateLock = new BufferLock(this.asyncConfiguration.modificationQueueSize());
        int poolSize = this.asyncConfiguration.threadPoolSize();
        this.executor = new ThreadPoolExecutor(0, poolSize, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "AsyncStoreProcessor-" + AsyncCacheWriter.this.cacheName + "-" + threadId.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        });
        this.coordinator = new Thread((Runnable)new AsyncStoreCoordinator(), "AsyncStoreCoordinator-" + this.cacheName);
        this.coordinator.setDaemon(true);
        this.coordinator.start();
    }

    @Override
    public void stop() {
        if (trace) {
            log.tracef("Stop async store %s", this);
        }
        this.stateLock.writeLock(1);
        this.state.get().stopped = true;
        this.stateLock.writeUnlock();
        try {
            this.coordinator.join(this.shutdownTimeout);
            if (this.coordinator.isAlive()) {
                log.error("Async store executor did not stop properly");
            }
        }
        catch (InterruptedException e) {
            log.interruptedWaitingAsyncStorePush(e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void write(MarshalledEntry entry) {
        this.put(new Store(entry.getKey(), entry), 1);
    }

    @Override
    public boolean delete(Object key) {
        this.put(new Remove(key), 1);
        return true;
    }

    protected void applyModificationsSync(List<Modification> mods) throws CacheLoaderException {
        block4: for (Modification m : mods) {
            switch (m.getType()) {
                case STORE: {
                    this.actual.write(((Store)m).getStoredValue());
                    continue block4;
                }
                case REMOVE: {
                    this.actual.delete(((Remove)m).getKey());
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unknown modification type " + (Object)((Object)m.getType()));
        }
    }

    State newState(boolean clear, State next) {
        ConcurrentMap map = CollectionFactory.makeConcurrentMap((int)64, (int)this.concurrencyLevel);
        return new State(clear, map, next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(Modification mod, int count) {
        this.stateLock.writeLock(count);
        try {
            if (log.isTraceEnabled()) {
                log.tracef("Queue modification: %s", mod);
            }
            this.state.get().put(mod);
        }
        finally {
            this.stateLock.writeUnlock();
        }
    }

    public AtomicReference<State> getState() {
        return this.state;
    }

    private class AsyncStoreProcessor
    implements Runnable {
        private final List<Modification> modifications;
        private final State myState;

        AsyncStoreProcessor(List<Modification> modifications, State myState) {
            this.modifications = modifications;
            this.myState = myState;
        }

        @Override
        public void run() {
            this.retryWork(3);
            this.myState.workerThreads.countDown();
            if (this.myState.workerThreads.getCount() == 0L) {
                State s = AsyncCacheWriter.this.state.get();
                while (s != null) {
                    if (s.next == this.myState) {
                        s.next = null;
                    }
                    s = s.next;
                }
            }
        }

        private void retryWork(int maxRetries) {
            for (int attempt = 0; attempt < maxRetries; ++attempt) {
                if (attempt > 0 && log.isDebugEnabled()) {
                    log.debugf("Retrying due to previous failure. %s attempts left.", maxRetries - attempt);
                }
                try {
                    AsyncCacheWriter.this.applyModificationsSync(this.modifications);
                    return;
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Failed to process async modifications", e);
                    continue;
                }
            }
            log.unableToProcessAsyncModifications(maxRetries);
        }
    }

    private class AsyncStoreCoordinator
    implements Runnable {
        private AsyncStoreCoordinator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LogFactory.pushNDC(AsyncCacheWriter.this.cacheName, trace);
            try {
                while (true) {
                    State head;
                    State tail;
                    State s;
                    if (this.shouldStop(s = AsyncCacheWriter.this.state.get())) {
                        return;
                    }
                    AsyncCacheWriter.this.stateLock.readLock();
                    try {
                        s = AsyncCacheWriter.this.state.get();
                        tail = s.next;
                        assert (tail == null || tail.next == null) : "State chain longer than 3 entries!";
                        head = AsyncCacheWriter.this.newState(false, s);
                        AsyncCacheWriter.this.state.set(head);
                    }
                    finally {
                        AsyncCacheWriter.this.stateLock.reset(0);
                        AsyncCacheWriter.this.stateLock.readUnlock();
                    }
                    try {
                        ArrayList<Object> mods;
                        if (s.clear && tail != null) {
                            this.workerThreadsAwait(tail.workerThreads);
                        }
                        if (tail != null) {
                            mods = new ArrayList();
                            for (Map.Entry e : s.modifications.entrySet()) {
                                if (!tail.modifications.containsKey(e.getKey())) {
                                    mods.add(e.getValue());
                                    continue;
                                }
                                if (!head.clear && head.modifications.putIfAbsent(e.getKey(), (Modification)e.getValue()) == null) {
                                    AsyncCacheWriter.this.stateLock.add(1);
                                }
                                s.modifications.remove(e.getKey());
                            }
                        } else {
                            mods = new ArrayList(s.modifications.values());
                        }
                        int threads = Math.min(mods.size(), AsyncCacheWriter.this.asyncConfiguration.threadPoolSize());
                        s.workerThreads = new CountDownLatch(threads);
                        if (threads > 0) {
                            int start = 0;
                            int quotient = mods.size() / threads;
                            int remainder = mods.size() % threads;
                            for (int i = 0; i < threads; ++i) {
                                int end = start + quotient + (i < remainder ? 1 : 0);
                                AsyncCacheWriter.this.executor.execute(new AsyncStoreProcessor(mods.subList(start, end), s));
                                start = end;
                            }
                            assert (start == mods.size()) : "Thread distribution is broken!";
                        }
                        if (tail != null) {
                            this.workerThreadsAwait(tail.workerThreads);
                            s.next = null;
                        }
                        if (this.shouldStop(s)) {
                            this.workerThreadsAwait(s.workerThreads);
                            return;
                        }
                    }
                    catch (InterruptedException e) {
                        log.asyncStoreCoordinatorInterrupted(e);
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        log.unexpectedErrorInAsyncStoreCoordinator(e);
                    }
                }
            }
            finally {
                try {
                    boolean workersTerminated = false;
                    try {
                        AsyncCacheWriter.this.executor.shutdown();
                        workersTerminated = AsyncCacheWriter.this.executor.awaitTermination(AsyncCacheWriter.this.shutdownTimeout, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if (!workersTerminated) {
                        AsyncCacheWriter.this.executor.shutdownNow();
                    }
                }
                finally {
                    LogFactory.popNDC(trace);
                }
            }
        }

        private boolean shouldStop(State s) {
            return s.stopped && s.modifications.isEmpty();
        }

        private void workerThreadsAwait(CountDownLatch latch) throws InterruptedException {
            boolean await = latch.await(AsyncCacheWriter.this.shutdownTimeout, TimeUnit.MILLISECONDS);
            if (!await) {
                throw log.waitingForWorkerThreadsFailed(latch);
            }
        }
    }
}

