/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.session.Session;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.util.IteratorEnumeration;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class HttpSessionImpl
implements HttpSession {
    private final Session session;
    private final ServletContext servletContext;
    private final boolean newSession;
    private volatile boolean invalid;

    private HttpSessionImpl(Session session, ServletContext servletContext, boolean newSession) {
        this.session = session;
        this.servletContext = servletContext;
        this.newSession = newSession;
    }

    public static HttpSessionImpl forSession(Session session, ServletContext servletContext, boolean newSession) {
        ServletRequestContext current = ServletRequestContext.current();
        if (current == null) {
            return new HttpSessionImpl(session, servletContext, newSession);
        }
        HttpSessionImpl httpSession = current.getSession();
        if (httpSession == null) {
            httpSession = new HttpSessionImpl(session, servletContext, newSession);
            current.setSession(httpSession);
        } else if (httpSession.session != session) {
            httpSession = new HttpSessionImpl(session, servletContext, newSession);
        }
        return httpSession;
    }

    public long getCreationTime() {
        return this.session.getCreationTime();
    }

    public String getId() {
        return this.session.getId();
    }

    public long getLastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int interval) {
        this.session.setMaxInactiveInterval(interval);
    }

    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String name) {
        return this.session.getAttribute(name);
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new IteratorEnumeration<String>(this.session.getAttributeNames().iterator());
    }

    public String[] getValueNames() {
        Set names = this.session.getAttributeNames();
        String[] ret = new String[names.size()];
        int i = 0;
        for (String name : names) {
            ret[i++] = name;
        }
        return ret;
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
        } else {
            this.session.setAttribute(name, value);
        }
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.session.removeAttribute(name);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        this.invalid = true;
        ServletRequestContext current = ServletRequestContext.current();
        if (current == null) {
            this.session.invalidate(null);
        } else {
            this.session.invalidate(current.getOriginalRequest().getExchange());
        }
    }

    public boolean isNew() {
        if (this.invalid) {
            throw UndertowServletMessages.MESSAGES.sessionIsInvalid();
        }
        return this.newSession;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isInvalid() {
        return this.invalid;
    }
}

