/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.management;

import java.util.Set;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.access.Authorizer;
import org.jboss.as.controller.access.Caller;
import org.jboss.as.controller.access.CustomAuthorizer;
import org.jboss.as.controller.access.Environment;
import org.jboss.as.controller.access.JmxAction;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.management.JmxAuthorizer;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.controller.access.rbac.StandardRBACAuthorizer;
import org.jboss.as.controller.access.rbac.SuperUserRoleMapper;

public final class DelegatingConfigurableAuthorizer
implements JmxAuthorizer {
    private final WritableAuthorizerConfiguration writableAuthorizerConfiguration = new WritableAuthorizerConfiguration(StandardRBACAuthorizer.AUTHORIZER_DESCRIPTION);
    private volatile Authorizer delegate = StandardRBACAuthorizer.create(this.writableAuthorizerConfiguration, new SuperUserRoleMapper(this.writableAuthorizerConfiguration));

    public WritableAuthorizerConfiguration getWritableAuthorizerConfiguration() {
        return this.writableAuthorizerConfiguration;
    }

    public void setDelegate(Authorizer delegate) {
        assert (delegate != null) : "null delegate";
        Authorizer currentDelegate = this.delegate;
        if (delegate instanceof CustomAuthorizer) {
            Authorizer.AuthorizerDescription description = ((CustomAuthorizer)delegate).setAuthorizerConfiguration(this.writableAuthorizerConfiguration);
            this.writableAuthorizerConfiguration.setAuthorizerDescription(description);
        } else {
            this.writableAuthorizerConfiguration.setAuthorizerDescription(delegate.getDescription());
        }
        this.delegate = delegate;
        if (currentDelegate instanceof CustomAuthorizer) {
            ((CustomAuthorizer)currentDelegate).shutdown();
        } else if (currentDelegate instanceof StandardRBACAuthorizer) {
            ((StandardRBACAuthorizer)currentDelegate).shutdown();
        }
    }

    @Override
    public Set<String> getCallerRoles(Caller caller, Environment callEnvironment, Set<String> runAsroles) {
        return this.delegate.getCallerRoles(caller, callEnvironment, runAsroles);
    }

    @Override
    public Authorizer.AuthorizerDescription getDescription() {
        return this.delegate.getDescription();
    }

    @Override
    public AuthorizationResult authorize(Caller caller, Environment callEnvironment, Action action, TargetAttribute target) {
        return this.delegate.authorize(caller, callEnvironment, action, target);
    }

    @Override
    public AuthorizationResult authorize(Caller caller, Environment callEnvironment, Action action, TargetResource target) {
        return this.delegate.authorize(caller, callEnvironment, action, target);
    }

    @Override
    public AuthorizationResult authorizeJmxOperation(Caller caller, Environment callEnvironment, JmxAction action) {
        return this.delegate.authorizeJmxOperation(caller, callEnvironment, action);
    }

    @Override
    public void setNonFacadeMBeansSensitive(boolean sensitive) {
        this.writableAuthorizerConfiguration.setNonFacadeMBeansSensitive(sensitive);
    }

    public void shutdown() {
        if (this.delegate instanceof CustomAuthorizer) {
            ((CustomAuthorizer)this.delegate).shutdown();
        } else if (this.delegate instanceof StandardRBACAuthorizer) {
            ((StandardRBACAuthorizer)this.delegate).shutdown();
        }
    }
}

