/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.spi;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.cfg.Configuration;
import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.internal.EntitiesConfigurator;
import org.hibernate.envers.configuration.internal.GlobalConfiguration;
import org.hibernate.envers.configuration.internal.RevisionInfoConfiguration;
import org.hibernate.envers.configuration.internal.RevisionInfoConfigurationResult;
import org.hibernate.envers.internal.entities.EntitiesConfigurations;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.revisioninfo.ModifiedEntityNamesReader;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoNumberReader;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoQueryCreator;
import org.hibernate.envers.internal.synchronization.AuditProcessManager;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.envers.strategy.ValidityAuditStrategy;
import org.hibernate.internal.util.ClassLoaderHelper;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.Getter;

public class AuditConfiguration {
    private final GlobalConfiguration globalCfg;
    private final AuditEntitiesConfiguration auditEntCfg;
    private final AuditProcessManager auditProcessManager;
    private final AuditStrategy auditStrategy;
    private final EntitiesConfigurations entCfg;
    private final RevisionInfoQueryCreator revisionInfoQueryCreator;
    private final RevisionInfoNumberReader revisionInfoNumberReader;
    private final ModifiedEntityNamesReader modifiedEntityNamesReader;
    private ClassLoaderService classLoaderService;
    private static final Map<Configuration, AuditConfiguration> CFGS = new WeakHashMap<Configuration, AuditConfiguration>();

    public AuditEntitiesConfiguration getAuditEntCfg() {
        return this.auditEntCfg;
    }

    public AuditProcessManager getSyncManager() {
        return this.auditProcessManager;
    }

    public GlobalConfiguration getGlobalCfg() {
        return this.globalCfg;
    }

    public EntitiesConfigurations getEntCfg() {
        return this.entCfg;
    }

    public RevisionInfoQueryCreator getRevisionInfoQueryCreator() {
        return this.revisionInfoQueryCreator;
    }

    public RevisionInfoNumberReader getRevisionInfoNumberReader() {
        return this.revisionInfoNumberReader;
    }

    public ModifiedEntityNamesReader getModifiedEntityNamesReader() {
        return this.modifiedEntityNamesReader;
    }

    public AuditStrategy getAuditStrategy() {
        return this.auditStrategy;
    }

    public ClassLoaderService getClassLoaderService() {
        return this.classLoaderService;
    }

    public AuditConfiguration(Configuration cfg) {
        this(cfg, null);
    }

    public AuditConfiguration(Configuration cfg, ClassLoaderService classLoaderService) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ClassLoaderHelper.getContextClassLoader());
        Properties properties = cfg.getProperties();
        ReflectionManager reflectionManager = cfg.getReflectionManager();
        this.globalCfg = new GlobalConfiguration(properties, classLoaderService);
        RevisionInfoConfiguration revInfoCfg = new RevisionInfoConfiguration(this.globalCfg);
        RevisionInfoConfigurationResult revInfoCfgResult = revInfoCfg.configure(cfg, reflectionManager);
        this.auditEntCfg = new AuditEntitiesConfiguration(properties, revInfoCfgResult.getRevisionInfoEntityName());
        this.auditProcessManager = new AuditProcessManager(revInfoCfgResult.getRevisionInfoGenerator());
        this.revisionInfoQueryCreator = revInfoCfgResult.getRevisionInfoQueryCreator();
        this.revisionInfoNumberReader = revInfoCfgResult.getRevisionInfoNumberReader();
        this.modifiedEntityNamesReader = revInfoCfgResult.getModifiedEntityNamesReader();
        this.classLoaderService = classLoaderService;
        this.auditStrategy = this.initializeAuditStrategy(revInfoCfgResult.getRevisionInfoClass(), revInfoCfgResult.getRevisionInfoTimestampData());
        this.entCfg = new EntitiesConfigurator().configure(cfg, reflectionManager, this.globalCfg, this.auditEntCfg, this.auditStrategy, classLoaderService, revInfoCfgResult.getRevisionInfoXmlMapping(), revInfoCfgResult.getRevisionInfoRelationMapping());
        Thread.currentThread().setContextClassLoader(tccl);
    }

    private AuditStrategy initializeAuditStrategy(Class<?> revisionInfoClass, PropertyData revisionInfoTimestampData) {
        AuditStrategy strategy;
        try {
            Class<Object> auditStrategyClass = null;
            try {
                auditStrategyClass = this.getClass().getClassLoader().loadClass(this.auditEntCfg.getAuditStrategyName());
            }
            catch (Exception e) {
                auditStrategyClass = ReflectionTools.loadClass(this.auditEntCfg.getAuditStrategyName(), this.classLoaderService);
            }
            strategy = (AuditStrategy)ReflectHelper.getDefaultConstructor(auditStrategyClass).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new MappingException(String.format("Unable to create AuditStrategy[%s] instance.", this.auditEntCfg.getAuditStrategyName()), (Throwable)e);
        }
        if (strategy instanceof ValidityAuditStrategy) {
            Getter revisionTimestampGetter = ReflectionTools.getGetter(revisionInfoClass, revisionInfoTimestampData);
            ((ValidityAuditStrategy)strategy).setRevisionTimestampGetter(revisionTimestampGetter);
        }
        return strategy;
    }

    public static synchronized AuditConfiguration getFor(Configuration cfg) {
        return AuditConfiguration.getFor(cfg, null);
    }

    public static synchronized AuditConfiguration getFor(Configuration cfg, ClassLoaderService classLoaderService) {
        AuditConfiguration verCfg = CFGS.get(cfg);
        if (verCfg == null) {
            verCfg = new AuditConfiguration(cfg, classLoaderService);
            CFGS.put(cfg, verCfg);
            cfg.buildMappings();
        }
        return verCfg;
    }

    public void destroy() {
        for (Map.Entry<Configuration, AuditConfiguration> c : new HashSet<Map.Entry<Configuration, AuditConfiguration>>(CFGS.entrySet())) {
            if (c.getValue() != this) continue;
            CFGS.remove(c.getKey());
        }
        this.classLoaderService = null;
    }
}

