/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation;

import java.io.Serializable;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.configuration.spi.AuditConfiguration;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.ToOneDelegateSessionImplementor;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.persister.entity.EntityPersister;

public class ToOneEntityLoader {
    public static Object loadImmediate(AuditReaderImplementor versionsReader, Class<?> entityClass, String entityName, Object entityId, Number revision, boolean removed, AuditConfiguration verCfg) {
        if (verCfg.getEntCfg().getNotVersionEntityConfiguration(entityName) == null) {
            return versionsReader.find(entityClass, entityName, entityId, revision, removed);
        }
        return versionsReader.getSessionImplementor().immediateLoad(entityName, (Serializable)entityId);
    }

    public static Object createProxy(AuditReaderImplementor versionsReader, Class<?> entityClass, String entityName, Object entityId, Number revision, boolean removed, AuditConfiguration verCfg) {
        EntityPersister persister = versionsReader.getSessionImplementor().getFactory().getEntityPersister(entityName);
        return persister.createProxy((Serializable)entityId, (SessionImplementor)new ToOneDelegateSessionImplementor(versionsReader, entityClass, entityId, revision, removed, verCfg));
    }

    public static Object createProxyOrLoadImmediate(AuditReaderImplementor versionsReader, Class<?> entityClass, String entityName, Object entityId, Number revision, boolean removed, AuditConfiguration verCfg) {
        EntityPersister persister = versionsReader.getSessionImplementor().getFactory().getEntityPersister(entityName);
        if (persister.hasProxy()) {
            return ToOneEntityLoader.createProxy(versionsReader, entityClass, entityName, entityId, revision, removed, verCfg);
        }
        return ToOneEntityLoader.loadImmediate(versionsReader, entityClass, entityName, entityId, revision, removed, verCfg);
    }
}

