/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.util;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.ObjectName;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.msc.service.ServiceName;
import org.jboss.ws.common.ObjectNameFactory;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointResolver;

public class ServiceContainerEndpointRegistry
implements EndpointRegistry {
    final String endpointPrefix = WSServices.ENDPOINT_SERVICE.getCanonicalName() + ".context";

    public Set<ObjectName> getEndpoints() {
        CopyOnWriteArraySet<ObjectName> endpoints = new CopyOnWriteArraySet<ObjectName>();
        for (ServiceName sname : WSServices.getContainerRegistry().getServiceNames()) {
            if (!sname.getCanonicalName().startsWith(this.endpointPrefix)) continue;
            String contextPath = sname.getParent().getSimpleName().substring(8);
            String endpointName = sname.getSimpleName();
            StringBuilder name = new StringBuilder("jboss.ws:");
            name.append("context=").append(contextPath).append(",");
            name.append("endpoint=").append(endpointName);
            endpoints.add(ObjectNameFactory.create((String)name.toString()));
        }
        return endpoints;
    }

    public Endpoint getEndpoint(ObjectName epName) {
        String context = epName.getKeyProperty("context");
        String name = epName.getKeyProperty("endpoint");
        ServiceName epSerivceName = WSServices.ENDPOINT_SERVICE.append(new String[]{"context=" + context}).append(new String[]{name});
        return ASHelper.getMSCService(epSerivceName, Endpoint.class);
    }

    public Endpoint resolve(EndpointResolver resolver) {
        return resolver.query(this.getRegisteredEndpoints().iterator());
    }

    public boolean isRegistered(ObjectName epName) {
        return this.getEndpoint(epName) != null;
    }

    public void register(Endpoint endpoint) {
    }

    public void unregister(Endpoint endpoint) {
    }

    private Set<Endpoint> getRegisteredEndpoints() {
        CopyOnWriteArraySet<Endpoint> endpoints = new CopyOnWriteArraySet<Endpoint>();
        for (ServiceName sname : WSServices.getContainerRegistry().getServiceNames()) {
            if (!sname.getCanonicalName().startsWith(this.endpointPrefix)) continue;
            endpoints.add(ASHelper.getMSCService(sname, Endpoint.class));
        }
        return endpoints;
    }
}

