/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.subsystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.NamingMessages;
import org.jboss.as.naming.subsystem.BindingType;
import org.jboss.as.naming.subsystem.NamingBindingAdd;
import org.jboss.as.naming.subsystem.NamingBindingRemove;
import org.jboss.as.naming.subsystem.NamingExtension;
import org.jboss.as.naming.subsystem.NamingSubsystemModel;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class NamingBindingResourceDefinition
extends SimpleResourceDefinition {
    static final NamingBindingResourceDefinition INSTANCE = new NamingBindingResourceDefinition();
    static final SimpleAttributeDefinition BINDING_TYPE = new SimpleAttributeDefinitionBuilder("binding-type", ModelType.STRING, false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).setValidator((ParameterValidator)EnumValidator.create(BindingType.class, (boolean)false, (boolean)false)).build();
    static final SimpleAttributeDefinition VALUE = new SimpleAttributeDefinitionBuilder("value", ModelType.STRING, true).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).build();
    static final SimpleAttributeDefinition TYPE = new SimpleAttributeDefinitionBuilder("type", ModelType.STRING, true).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).build();
    static final SimpleAttributeDefinition CLASS = new SimpleAttributeDefinitionBuilder("class", ModelType.STRING, true).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).build();
    static final SimpleAttributeDefinition MODULE = new SimpleAttributeDefinitionBuilder("module", ModelType.STRING, true).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).build();
    static final SimpleAttributeDefinition LOOKUP = new SimpleAttributeDefinitionBuilder("lookup", ModelType.STRING, true).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).build();
    static final PropertiesAttributeDefinition ENVIRONMENT = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("environment", true).setXmlName("property")).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition CACHE = new SimpleAttributeDefinitionBuilder("cache", ModelType.BOOLEAN, true).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{BINDING_TYPE, VALUE, TYPE, CLASS, MODULE, LOOKUP, ENVIRONMENT, CACHE};
    private static final List<AccessConstraintDefinition> ACCESS_CONSTRAINTS;

    private NamingBindingResourceDefinition() {
        super(NamingSubsystemModel.BINDING_PATH, NamingExtension.getResourceDescriptionResolver("binding"), (OperationStepHandler)NamingBindingAdd.INSTANCE, (OperationStepHandler)NamingBindingRemove.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        WriteAttributeHandler writeHandler = new WriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)writeHandler);
        }
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return ACCESS_CONSTRAINTS;
    }

    static void validateResourceModel(ModelNode modelNode) throws OperationFailedException {
        BindingType type = BindingType.forName(modelNode.require("binding-type").asString());
        if (type == BindingType.SIMPLE) {
            if (!modelNode.hasDefined(VALUE.getName())) {
                throw NamingMessages.MESSAGES.bindingTypeRequiresAttributeDefined(type, VALUE.getName());
            }
        } else if (type == BindingType.OBJECT_FACTORY) {
            if (!modelNode.hasDefined(MODULE.getName())) {
                throw NamingMessages.MESSAGES.bindingTypeRequiresAttributeDefined(type, MODULE.getName());
            }
            if (!modelNode.hasDefined(CLASS.getName())) {
                throw NamingMessages.MESSAGES.bindingTypeRequiresAttributeDefined(type, CLASS.getName());
            }
        } else if (type == BindingType.EXTERNAL_CONTEXT) {
            if (!modelNode.hasDefined(MODULE.getName())) {
                throw NamingMessages.MESSAGES.bindingTypeRequiresAttributeDefined(type, MODULE.getName());
            }
            if (!modelNode.hasDefined(CLASS.getName())) {
                throw NamingMessages.MESSAGES.bindingTypeRequiresAttributeDefined(type, CLASS.getName());
            }
        } else if (type == BindingType.LOOKUP) {
            if (!modelNode.hasDefined(LOOKUP.getName())) {
                throw NamingMessages.MESSAGES.bindingTypeRequiresAttributeDefined(type, LOOKUP.getName());
            }
        } else {
            throw NamingMessages.MESSAGES.unknownBindingType(type.toString());
        }
    }

    static {
        ArrayList<Object> constraints = new ArrayList<Object>();
        constraints.add(NamingExtension.NAMING_BINDING_APPLICATION_CONSTRAINT);
        constraints.add(NamingExtension.NAMING_BINDING_SENSITIVITY_CONSTRAINT);
        ACCESS_CONSTRAINTS = Collections.unmodifiableList(constraints);
    }

    private static class WriteAttributeHandler
    extends ReloadRequiredWriteAttributeHandler {
        private WriteAttributeHandler(AttributeDefinition ... definitions) {
            super(definitions);
        }

        protected void validateUpdatedModel(OperationContext context, Resource model) throws OperationFailedException {
            super.validateUpdatedModel(context, model);
            NamingBindingResourceDefinition.validateResourceModel(model.getModel());
        }
    }
}

