/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wsas.activity;

import com.arjuna.mw.wsas.activity.HLS;
import com.arjuna.mw.wsas.activity.Outcome;
import com.arjuna.mw.wsas.common.GlobalId;
import com.arjuna.mw.wsas.completionstatus.CompletionStatus;
import com.arjuna.mw.wsas.completionstatus.Failure;
import com.arjuna.mw.wsas.completionstatus.FailureOnly;
import com.arjuna.mw.wsas.exceptions.HLSException;
import com.arjuna.mw.wsas.exceptions.InvalidActivityException;
import com.arjuna.mw.wsas.exceptions.InvalidTimeoutException;
import com.arjuna.mw.wsas.exceptions.NoActivityException;
import com.arjuna.mw.wsas.exceptions.NoPermissionException;
import com.arjuna.mw.wsas.exceptions.ProtocolViolationException;
import com.arjuna.mw.wsas.exceptions.SystemException;
import com.arjuna.mw.wsas.exceptions.WrongStateException;
import com.arjuna.mw.wsas.logging.wsasLogger;
import com.arjuna.mw.wsas.status.Active;
import com.arjuna.mw.wsas.status.Completed;
import com.arjuna.mw.wsas.status.Completing;
import com.arjuna.mw.wsas.status.Created;
import com.arjuna.mw.wsas.status.Status;
import com.arjuna.mwlabs.wsas.activity.ActivityReaper;
import com.arjuna.mwlabs.wsas.activity.HLSManager;
import com.arjuna.mwlabs.wsas.activity.OutcomeImple;
import com.arjuna.mwlabs.wsas.common.arjunacore.GlobalIdImple;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

public class ActivityImple {
    private ActivityImple _parent;
    private Hashtable _children;
    private Status _status;
    private CompletionStatus _completionStatus;
    private GlobalIdImple _activityId;
    private int _timeout;
    private Outcome _result;
    private String _serviceType;

    public ActivityImple(String coordinationType) {
        this(null, coordinationType);
    }

    public ActivityImple(ActivityImple parent, String serviceType) {
        this._parent = parent;
        this._children = new Hashtable();
        this._status = Created.instance();
        this._completionStatus = Failure.instance();
        this._activityId = new GlobalIdImple();
        this._timeout = 0;
        this._result = null;
        this._serviceType = serviceType;
    }

    public void start() throws WrongStateException, SystemException {
        try {
            this.start(0);
        }
        catch (InvalidTimeoutException invalidTimeoutException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int timeout) throws WrongStateException, InvalidTimeoutException, SystemException {
        if (timeout < 0) {
            throw new InvalidTimeoutException();
        }
        ActivityImple activityImple = this;
        synchronized (activityImple) {
            this._timeout = timeout;
            if (this._status.equals(Created.instance())) {
                try {
                    if (this._parent != null) {
                        this._parent.addChild(this);
                    }
                }
                catch (InvalidActivityException ex) {
                    this._status = Completed.instance();
                    throw new WrongStateException(ex.toString());
                }
                if (this._timeout > 0 && !ActivityReaper.activityReaper(true).insert(this, this._timeout)) {
                    this.setCompletionStatus(FailureOnly.instance());
                }
            } else {
                throw new WrongStateException(wsasLogger.i18NLogger.get_activity_ActivityImple_1() + " " + this + " " + this._status);
            }
            this._status = Active.instance();
        }
    }

    public Outcome end() throws InvalidActivityException, WrongStateException, ProtocolViolationException, NoPermissionException, SystemException {
        return this.end(this._completionStatus);
    }

    public Outcome end(CompletionStatus cs) throws InvalidActivityException, WrongStateException, ProtocolViolationException, NoPermissionException, SystemException {
        ActivityImple activityImple = this;
        synchronized (activityImple) {
            if (this._status.equals(Active.instance())) {
                if (this.activeChildren()) {
                    throw new InvalidActivityException(wsasLogger.i18NLogger.get_activity_ActivityImple_2() + " " + this);
                }
                Outcome result = null;
                try {
                    this.setCompletionStatus(cs);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this._status = Completing.instance();
                try {
                    HLS hls = HLSManager.getHighLevelService(this._serviceType);
                    result = hls != null ? hls.complete(this.getCompletionStatus()) : new OutcomeImple(Failure.instance());
                }
                catch (SystemException ex) {
                    result = new OutcomeImple(new HLSException(ex), Failure.instance());
                }
                if (this._parent != null) {
                    this._parent.removeChild(this);
                    this._parent = null;
                }
                this._status = Completed.instance();
                this._result = result;
                return this._result;
            }
            if (this._result != null) {
                return this._result;
            }
            throw new WrongStateException(wsasLogger.i18NLogger.get_activity_ActivityImple_3() + " " + this._status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompletionStatus(CompletionStatus endStatus) throws WrongStateException, SystemException {
        ActivityImple activityImple = this;
        synchronized (activityImple) {
            if (!this._status.equals(Active.instance())) {
                throw new WrongStateException(wsasLogger.i18NLogger.get_activity_ActivityImple_4() + " " + this + " " + this._status);
            }
            this.completionValid(endStatus);
            this._completionStatus = endStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStatus getCompletionStatus() throws SystemException {
        ActivityImple activityImple = this;
        synchronized (activityImple) {
            return this._completionStatus;
        }
    }

    public int getTimeout() throws SystemException {
        return this._timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status status() throws SystemException {
        ActivityImple activityImple = this;
        synchronized (activityImple) {
            return this._status;
        }
    }

    public String activityName() throws NoActivityException, SystemException {
        return "ActivityImple: " + this.toString();
    }

    public String toString() {
        return this._activityId.stringForm();
    }

    public GlobalId getGlobalId() {
        return this._activityId;
    }

    public ActivityImple parent() {
        return this._parent;
    }

    public String serviceType() {
        return this._serviceType;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj != this) {
            if (obj instanceof ActivityImple) {
                if (((Object)((ActivityImple)obj).getGlobalId()).equals(this.getGlobalId())) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public ActivityImple[] hierarchy() {
        Stack<ActivityImple> hier = new Stack<ActivityImple>();
        for (ActivityImple ptr = this; ptr != null; ptr = ptr.parent()) {
            hier.push(ptr);
        }
        int hierSize = hier.size();
        ActivityImple[] toReturn = new ActivityImple[hierSize];
        for (int i = 0; i < hierSize; ++i) {
            toReturn[i] = (ActivityImple)hier.pop();
        }
        return toReturn;
    }

    public final void completionValid(CompletionStatus cs) throws WrongStateException {
        if (!((Object)this._completionStatus).equals(cs) && ((Object)this._completionStatus).equals(FailureOnly.instance())) {
            throw new WrongStateException(wsasLogger.i18NLogger.get_activity_ActivityImple_5() + " " + this._completionStatus + " " + cs);
        }
    }

    public int hashCode() {
        return this._activityId.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addChild(ActivityImple child) throws WrongStateException, InvalidActivityException, SystemException {
        if (child == null) {
            throw new InvalidActivityException(wsasLogger.i18NLogger.get_activity_ActivityImple_6());
        }
        ActivityImple activityImple = this;
        synchronized (activityImple) {
            if (!this._status.equals(Active.instance())) {
                throw new WrongStateException(wsasLogger.i18NLogger.get_activity_ActivityImple_7() + " " + this._status);
            }
            this._children.put(child.getGlobalId(), child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeChild(ActivityImple child) throws WrongStateException, InvalidActivityException, SystemException {
        if (child == null) {
            throw new InvalidActivityException(wsasLogger.i18NLogger.get_activity_ActivityImple_8());
        }
        ActivityImple activityImple = this;
        synchronized (activityImple) {
            if (this._status.equals(Active.instance())) {
                if (this._children.get(child.getGlobalId()) == null) {
                    throw new InvalidActivityException(wsasLogger.i18NLogger.get_activity_ActivityImple_9() + child);
                }
            } else {
                throw new WrongStateException(wsasLogger.i18NLogger.get_activity_ActivityImple_10() + this._status);
            }
        }
    }

    private final boolean activeChildren() {
        Enumeration e = this._children.keys();
        while (e.hasMoreElements()) {
            ActivityImple child = (ActivityImple)this._children.get(e.nextElement());
            try {
                if (child == null || !child.status().equals(Active.instance())) continue;
                return true;
            }
            catch (Exception ex) {
                return true;
            }
        }
        return false;
    }
}

