/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.xts.recovery.participant.ba;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.objectstore.TxLog;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.jboss.jbossts.xts.recovery.XTSRecoveryModule;
import org.jboss.jbossts.xts.recovery.logging.RecoveryLogger;
import org.jboss.jbossts.xts.recovery.participant.ba.BAParticipantRecoveryRecord;
import org.jboss.jbossts.xts.recovery.participant.ba.XTSBARecoveryManager;
import org.jboss.jbossts.xts.recovery.participant.ba.XTSBARecoveryManagerImple;
import org.jboss.jbossts.xts.recovery.participant.ba.XTSBASubordinateRecoveryModule;

public class BAParticipantRecoveryModule
implements XTSRecoveryModule {
    private XTSBASubordinateRecoveryModule subordinateRecoveryModule;
    private String _participantType = BAParticipantRecoveryRecord.type();
    private Vector _participantUidVector = null;
    private static RecoveryStore _recoveryStore = null;
    private HashMap<String, BAParticipantRecoveryRecord> _recoveredParticipantMap;

    public BAParticipantRecoveryModule() {
        if (RecoveryLogger.logger.isDebugEnabled()) {
            RecoveryLogger.logger.debug((Object)"BAParticipantRecoveryModule created - default");
        }
        if (_recoveryStore == null) {
            _recoveryStore = StoreManager.getRecoveryStore();
        }
        this._participantType = BAParticipantRecoveryRecord.type();
    }

    @Override
    public void install() {
        XTSBARecoveryManager baRecoveryManager = XTSBARecoveryManager.getRecoveryManager();
        if (baRecoveryManager == null) {
            baRecoveryManager = new XTSBARecoveryManagerImple((TxLog)_recoveryStore);
            XTSBARecoveryManager.setRecoveryManager(baRecoveryManager);
        }
        this.subordinateRecoveryModule = new XTSBASubordinateRecoveryModule();
        baRecoveryManager.registerRecoveryModule(this.subordinateRecoveryModule);
    }

    @Override
    public void uninstall() {
        XTSBARecoveryManager.getRecoveryManager().unregisterRecoveryModule(this.subordinateRecoveryModule);
    }

    public void periodicWorkFirstPass() {
        boolean BAParticipants = false;
        InputObjectState acc_uids = new InputObjectState();
        try {
            if (RecoveryLogger.logger.isDebugEnabled()) {
                RecoveryLogger.logger.debug((Object)"BAParticipantRecoveryModule: first pass");
            }
            BAParticipants = _recoveryStore.allObjUids(this._participantType, acc_uids);
        }
        catch (ObjectStoreException ex) {
            RecoveryLogger.i18NLogger.warn_participant_ba_BAParticipantRecoveryModule_1(ex);
        }
        if (BAParticipants) {
            this._participantUidVector = this.processParticipants(acc_uids);
        }
    }

    public void periodicWorkSecondPass() {
        if (RecoveryLogger.logger.isDebugEnabled()) {
            RecoveryLogger.logger.debug((Object)"BAParticipantRecoveryModule: Second pass");
        }
        this.processParticipantsStatus();
    }

    private void doRecoverParticipant(Uid recoverUid) {
        block11: {
            XTSBARecoveryManager recoveryManager;
            if (RecoveryLogger.logger.isDebugEnabled()) {
                RecoveryLogger.logger.debug((Object)("participant type is " + this._participantType + " uid is " + recoverUid.toString()));
            }
            if (!(recoveryManager = XTSBARecoveryManager.getRecoveryManager()).isParticipantPresent(recoverUid)) {
                try {
                    InputObjectState inputState = _recoveryStore.read_committed(recoverUid, this._participantType);
                    if (inputState != null) {
                        try {
                            String participantRecordClazzName = inputState.unpackString();
                            try {
                                Class<?> participantRecordClazz = Class.forName(participantRecordClazzName);
                                BAParticipantRecoveryRecord participantRecord = (BAParticipantRecoveryRecord)participantRecordClazz.newInstance();
                                participantRecord.restoreState(inputState);
                                XTSBARecoveryManager.getRecoveryManager().addParticipantRecoveryRecord(recoverUid, participantRecord);
                                break block11;
                            }
                            catch (ClassNotFoundException cnfe) {
                                RecoveryLogger.i18NLogger.error_participant_ba_BAParticipantRecoveryModule_4(participantRecordClazzName, recoverUid, cnfe);
                                break block11;
                            }
                            catch (InstantiationException ie) {
                                RecoveryLogger.i18NLogger.error_participant_ba_BAParticipantRecoveryModule_5(participantRecordClazzName, recoverUid, ie);
                                break block11;
                            }
                            catch (IllegalAccessException iae) {
                                RecoveryLogger.i18NLogger.error_participant_ba_BAParticipantRecoveryModule_5(participantRecordClazzName, recoverUid, iae);
                            }
                        }
                        catch (IOException ioe) {
                            RecoveryLogger.i18NLogger.warn_participant_ba_BAParticipantRecoveryModule_6(recoverUid, ioe);
                        }
                        break block11;
                    }
                    RecoveryLogger.i18NLogger.error_participant_ba_BAParticipantRecoveryModule_7(recoverUid);
                }
                catch (ObjectStoreException ose) {
                    RecoveryLogger.i18NLogger.error_participant_ba_BAParticipantRecoveryModule_8(recoverUid, ose);
                }
            }
        }
    }

    private Vector processParticipants(InputObjectState uids) {
        Vector<Uid> uidVector = new Vector<Uid>();
        if (RecoveryLogger.logger.isDebugEnabled()) {
            RecoveryLogger.logger.debug((Object)("processing " + this._participantType + " WS-BA participants"));
        }
        Uid NULL_UID = Uid.nullUid();
        Uid theUid = null;
        while (true) {
            try {
                theUid = UidHelper.unpackFrom((InputBuffer)uids);
            }
            catch (Exception ex) {
                break;
            }
            if (theUid.equals(NULL_UID)) break;
            if (RecoveryLogger.logger.isDebugEnabled()) {
                RecoveryLogger.logger.debug((Object)("found WS-BA participant " + theUid));
            }
            uidVector.addElement(theUid);
        }
        return uidVector;
    }

    private void processParticipantsStatus() {
        if (this._participantUidVector != null) {
            Enumeration participantUidEnum = this._participantUidVector.elements();
            while (participantUidEnum.hasMoreElements()) {
                Uid currentUid = (Uid)participantUidEnum.nextElement();
                try {
                    if (_recoveryStore.currentState(currentUid, this._participantType) == -1) continue;
                    this.doRecoverParticipant(currentUid);
                }
                catch (ObjectStoreException ex) {
                    RecoveryLogger.i18NLogger.warn_participant_ba_BAParticipantRecoveryModule_3(currentUid, ex);
                }
            }
        }
        XTSBARecoveryManager.getRecoveryManager().recoverParticipants();
    }
}

