/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.util.Util;

public class MergeView
extends View {
    protected View[] subgroups;

    public MergeView() {
    }

    public MergeView(ViewId view_id, List<Address> members, List<View> subgroups) {
        super(view_id, members);
        this.subgroups = MergeView.listToArray(subgroups);
    }

    public MergeView(ViewId view_id, Address[] members, List<View> subgroups) {
        super(view_id, members);
        this.subgroups = MergeView.listToArray(subgroups);
    }

    public MergeView(Address creator, long id, List<Address> members, List<View> subgroups) {
        super(creator, id, members);
        this.subgroups = MergeView.listToArray(subgroups);
    }

    public List<View> getSubgroups() {
        return Collections.unmodifiableList(Arrays.asList(this.subgroups));
    }

    @Override
    public MergeView copy() {
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MergeView::").append(super.toString());
        if (this.subgroups != null && this.subgroups.length > 0) {
            sb.append(", subgroups=");
            sb.append(Util.printListWithDelimiter(this.subgroups, ", ", Util.MAX_LIST_PRINT_SIZE));
        }
        return sb.toString();
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        super.writeTo(out);
        int len = this.subgroups != null ? this.subgroups.length : 0;
        out.writeShort(len);
        if (len == 0) {
            return;
        }
        for (View v : this.subgroups) {
            int index = this.get(v.getCreator());
            out.writeShort(index);
            out.writeLong(v.getViewId().getId());
            int num_mbrs = v.size();
            out.writeShort(num_mbrs);
            for (Address mbr : v) {
                out.writeShort(this.get(mbr));
            }
        }
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        super.readFrom(in);
        int len = in.readShort();
        if (len > 0) {
            this.subgroups = new View[len];
            for (int i = 0; i < len; ++i) {
                View view;
                short index = in.readShort();
                long id = in.readLong();
                Address creator = this.get(index);
                Address[] mbrs = new Address[in.readShort()];
                for (int j = 0; j < mbrs.length; ++j) {
                    mbrs[j] = this.get(in.readShort());
                }
                this.subgroups[i] = view = View.create(creator, id, mbrs);
            }
        }
    }

    @Override
    public int serializedSize() {
        int retval = super.serializedSize();
        retval += 2;
        if (this.subgroups == null) {
            return retval;
        }
        for (View v : this.subgroups) {
            retval += 12;
            retval += v.size() * 2;
        }
        return retval;
    }

    protected static View[] listToArray(List<View> list) {
        if (list == null) {
            return null;
        }
        View[] retval = new View[list.size()];
        int index = 0;
        for (View view : list) {
            retval[index++] = view;
        }
        return retval;
    }

    protected int get(Address member) {
        if (member == null) {
            return -1;
        }
        for (int i = 0; i < this.members.length; ++i) {
            if (!member.equals(this.members[i])) continue;
            return i;
        }
        return -1;
    }

    protected Address get(int index) {
        return this.members != null && index >= 0 && index < this.members.length ? this.members[index] : null;
    }
}

