/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Membership;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.logging.Log;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.pbcast.ClientGmsImpl;
import org.jgroups.protocols.pbcast.CoordGmsImpl;
import org.jgroups.protocols.pbcast.DeltaView;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.protocols.pbcast.MergeData;
import org.jgroups.protocols.pbcast.Merger;
import org.jgroups.protocols.pbcast.ParticipantGmsImpl;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.MembershipChangePolicy;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AckCollector;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Digest;
import org.jgroups.util.MergeId;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@MBean(description="Group membership protocol")
public class GMS
extends Protocol
implements DiagnosticsHandler.ProbeHandler {
    protected static final String CLIENT = "Client";
    protected static final String COORD = "Coordinator";
    protected static final String PART = "Participant";
    @Property(description="Join timeout")
    protected long join_timeout = 5000L;
    @Property(description="Leave timeout")
    protected long leave_timeout = 1000L;
    @Property(description="Timeout (in ms) to complete merge")
    protected long merge_timeout = 5000L;
    @Property(description="Number of join attempts before we give up and become a singleton. Zero means 'never give up'.")
    protected long max_join_attempts = 0L;
    @Property(description="Print local address of this member after connect. Default is true")
    protected boolean print_local_addr = true;
    @Property(description="Print physical address(es) on startup")
    protected boolean print_physical_addrs = true;
    @Property(description="Temporary switch. Default is true and should not be changed")
    protected boolean handle_concurrent_startup = true;
    @Property(description="View bundling toggle")
    protected boolean view_bundling = true;
    @Property(description="If true, then GMS is allowed to send VIEW messages with delta views, otherwise it always sends full views. See https://issues.jboss.org/browse/JGRP-1354 for details.")
    protected boolean use_delta_views = true;
    @Property(description="Max view bundling timeout if view bundling is turned on. Default is 50 msec")
    protected long max_bundling_time = 50L;
    @Property(description="Max number of old members to keep in history. Default is 50")
    protected int num_prev_mbrs = 50;
    @Property(description="Number of views to store in history")
    protected int num_prev_views = 10;
    @Property(description="Time in ms to wait for all VIEW acks (0 == wait forever. Default is 2000 msec")
    protected long view_ack_collection_timeout = 2000L;
    @Property(description="Timeout to resume ViewHandler")
    protected long resume_task_timeout = 20000L;
    @Property(description="Use flush for view changes. Default is true")
    protected boolean use_flush_if_present = true;
    @Property(description="Logs failures for collecting all view acks if true")
    protected boolean log_collect_msgs = true;
    @Property(description="Logs warnings for reception of views less than the current, and for views which don't include self")
    protected boolean log_view_warnings = true;
    protected int num_views;
    protected BoundedList<String> prev_views;
    @Property(converter=PropertyConverters.FlushInvoker.class, name="flush_invoker_class")
    protected Class<Callable<Boolean>> flushInvokerClass;
    protected GmsImpl impl;
    protected final Object impl_mutex = new Object();
    protected final Map<String, GmsImpl> impls = new HashMap<String, GmsImpl>(3);
    protected final Merger merger = new Merger(this);
    protected Address local_addr;
    protected final Membership members = new Membership();
    protected final Membership tmp_members = new Membership();
    protected MembershipChangePolicy membership_change_policy = new DefaultMembershipPolicy();
    protected final List<Address> joining = new ArrayList<Address>(7);
    protected final List<Address> leaving = new ArrayList<Address>(7);
    protected BoundedList<Address> prev_members;
    protected volatile View view;
    protected long ltime;
    protected TimeScheduler timer;
    protected final ViewHandler view_handler = new ViewHandler();
    protected final AckCollector ack_collector = new AckCollector();
    protected final AckCollector merge_ack_collector = new AckCollector();
    protected boolean flushProtocolInStack = false;
    protected boolean first_view_sent;

    public GMS() {
        this.initState();
    }

    public ViewId getViewId() {
        return this.view != null ? this.view.getViewId() : null;
    }

    public Tuple<View, Digest> getViewAndDigest() {
        MutableDigest digest = new MutableDigest(this.view.getMembersRaw()).set(this.getDigest());
        return digest.allSet() || digest.set(this.getDigest()).allSet() ? new Tuple<View, Digest>(this.view, digest) : null;
    }

    @ManagedAttribute
    public String getView() {
        return this.view != null ? this.view.getViewId().toString() : "null";
    }

    @ManagedAttribute
    public int getNumberOfViews() {
        return this.num_views;
    }

    @ManagedAttribute
    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    @ManagedAttribute
    public String getMembers() {
        return this.members.toString();
    }

    @ManagedAttribute
    public int getNumMembers() {
        return this.members.size();
    }

    public long getJoinTimeout() {
        return this.join_timeout;
    }

    public void setJoinTimeout(long t) {
        this.join_timeout = t;
    }

    public long getMergeTimeout() {
        return this.merge_timeout;
    }

    public void setMergeTimeout(long timeout) {
        this.merge_timeout = timeout;
    }

    public long getMaxJoinAttempts() {
        return this.max_join_attempts;
    }

    public void setMaxJoinAttempts(long t) {
        this.max_join_attempts = t;
    }

    @ManagedAttribute(description="impl")
    public String getImplementation() {
        return this.impl == null ? "n/a" : this.impl.getClass().getSimpleName();
    }

    @ManagedAttribute(description="Whether or not the current instance is the coordinator")
    public boolean isCoord() {
        return this.impl instanceof CoordGmsImpl;
    }

    public MembershipChangePolicy getMembershipChangePolicy() {
        return this.membership_change_policy;
    }

    public void setMembershipChangePolicy(MembershipChangePolicy membership_change_policy) {
        if (membership_change_policy != null) {
            this.membership_change_policy = membership_change_policy;
        }
    }

    @ManagedAttribute(description="Stringified version of merge_id")
    public String getMergeId() {
        return this.merger.getMergeIdAsString();
    }

    @ManagedAttribute(description="Is a merge currently running")
    public boolean isMergeInProgress() {
        return this.merger.isMergeInProgress();
    }

    public Merger getMerger() {
        return this.merger;
    }

    @Property(description="The fully qualified name of a class implementing MembershipChangePolicy.")
    public void setMembershipChangePolicy(String classname) {
        try {
            this.membership_change_policy = (MembershipChangePolicy)Util.loadClass(classname, this.getClass()).newInstance();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("membership_change_policy could not be created", e);
        }
    }

    @ManagedOperation(description="Prints the last (max 20) MergeIds")
    public String printMergeIdHistory() {
        return this.merger.getMergeIdHistory();
    }

    @ManagedOperation
    public String printPreviousMembers() {
        StringBuilder sb = new StringBuilder();
        if (this.prev_members != null) {
            for (Address addr : this.prev_members) {
                sb.append(addr).append("\n");
            }
        }
        return sb.toString();
    }

    public void setPrintLocalAddress(boolean flag) {
        this.print_local_addr = flag;
    }

    public void setPrintLocalAddr(boolean flag) {
        this.setPrintLocalAddress(flag);
    }

    public long getViewAckCollectionTimeout() {
        return this.view_ack_collection_timeout;
    }

    public void setViewAckCollectionTimeout(long view_ack_collection_timeout) {
        if (view_ack_collection_timeout <= 0L) {
            throw new IllegalArgumentException("view_ack_collection_timeout has to be greater than 0");
        }
        this.view_ack_collection_timeout = view_ack_collection_timeout;
    }

    public boolean isViewBundling() {
        return this.view_bundling;
    }

    public void setViewBundling(boolean view_bundling) {
        this.view_bundling = view_bundling;
    }

    public long getMaxBundlingTime() {
        return this.max_bundling_time;
    }

    public void setMaxBundlingTime(long max_bundling_time) {
        this.max_bundling_time = max_bundling_time;
    }

    @ManagedAttribute
    public int getViewHandlerSize() {
        return this.view_handler.size();
    }

    @ManagedAttribute
    public boolean isViewHandlerSuspended() {
        return this.view_handler.suspended();
    }

    @ManagedOperation
    public String dumpViewHandlerQueue() {
        return this.view_handler.dumpQueue();
    }

    @ManagedOperation
    public String dumpViewHandlerHistory() {
        return this.view_handler.dumpHistory();
    }

    @ManagedOperation
    public void suspendViewHandler() {
        this.view_handler.suspend();
    }

    @ManagedOperation
    public void resumeViewHandler() {
        this.view_handler.resumeForce();
    }

    Log getLog() {
        return this.log;
    }

    ViewHandler getViewHandler() {
        return this.view_handler;
    }

    @ManagedOperation
    public String printPreviousViews() {
        StringBuilder sb = new StringBuilder();
        for (String view_rep : this.prev_views) {
            sb.append(view_rep).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation
    public void suspect(String suspected_member) {
        if (suspected_member == null) {
            return;
        }
        Map<Address, String> contents = UUID.getContents();
        for (Map.Entry<Address, String> entry : contents.entrySet()) {
            Address suspect;
            String logical_name = entry.getValue();
            if (logical_name == null || !logical_name.equals(suspected_member) || (suspect = entry.getKey()) == null) continue;
            this.up(new Event(9, suspect));
        }
    }

    public boolean isCoordinator() {
        Address coord = this.determineCoordinator();
        return coord != null && this.local_addr != null && this.local_addr.equals(coord);
    }

    public MergeId _getMergeId() {
        return this.impl instanceof CoordGmsImpl ? ((CoordGmsImpl)this.impl).getMergeId() : null;
    }

    public void setLogCollectMessages(boolean flag) {
        this.log_collect_msgs = flag;
    }

    public boolean getLogCollectMessages() {
        return this.log_collect_msgs;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_views = 0;
        this.prev_views.clear();
    }

    @Override
    public List<Integer> requiredDownServices() {
        return Arrays.asList(39, 41, 12, 13);
    }

    @Override
    public List<Integer> providedDownServices() {
        return Arrays.asList(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImpl(GmsImpl new_impl) {
        Object object = this.impl_mutex;
        synchronized (object) {
            if (this.impl == new_impl) {
                return;
            }
            this.impl = new_impl;
        }
    }

    public GmsImpl getImpl() {
        return this.impl;
    }

    @Override
    public void init() throws Exception {
        if (this.view_ack_collection_timeout <= 0L) {
            throw new IllegalArgumentException("view_ack_collection_timeout has to be greater than 0");
        }
        if (this.merge_timeout <= 0L) {
            throw new IllegalArgumentException("merge_timeout has to be greater than 0");
        }
        this.prev_members = new BoundedList(this.num_prev_mbrs);
        this.prev_views = new BoundedList(this.num_prev_views);
        TP transport = this.getTransport();
        this.timer = transport.getTimer();
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        if (this.impl != null) {
            this.impl.init();
        }
        transport.registerProbeHandler(this);
    }

    @Override
    public void start() throws Exception {
        if (this.impl != null) {
            this.impl.start();
        }
    }

    @Override
    public void stop() {
        this.view_handler.stop(true);
        if (this.impl != null) {
            this.impl.stop();
        }
        if (this.prev_members != null) {
            this.prev_members.clear();
        }
    }

    public void becomeCoordinator() {
        CoordGmsImpl tmp = (CoordGmsImpl)this.impls.get(COORD);
        if (tmp == null) {
            tmp = new CoordGmsImpl(this);
            this.impls.put(COORD, tmp);
        }
        try {
            this.first_view_sent = false;
            tmp.init();
        }
        catch (Exception e) {
            this.log.error("exception switching to coordinator role", e);
        }
        this.setImpl(tmp);
    }

    public void becomeParticipant() {
        ParticipantGmsImpl tmp = (ParticipantGmsImpl)this.impls.get(PART);
        if (tmp == null) {
            tmp = new ParticipantGmsImpl(this);
            this.impls.put(PART, tmp);
        }
        try {
            tmp.init();
        }
        catch (Exception e) {
            this.log.error("exception switching to participant", e);
        }
        this.setImpl(tmp);
    }

    public void becomeClient() {
        ClientGmsImpl tmp = (ClientGmsImpl)this.impls.get(CLIENT);
        if (tmp == null) {
            tmp = new ClientGmsImpl(this);
            this.impls.put(CLIENT, tmp);
        }
        try {
            tmp.init();
        }
        catch (Exception e) {
            this.log.error("exception switching to client role", e);
        }
        this.setImpl(tmp);
    }

    boolean haveCoordinatorRole() {
        return this.impl instanceof CoordGmsImpl;
    }

    @ManagedOperation(description="Fetches digests from all members and installs them, unblocking blocked members")
    public void fixDigests() {
        if (this.impl instanceof CoordGmsImpl) {
            ((CoordGmsImpl)this.impl).fixDigests();
        }
    }

    @ManagedOperation(description="Forces cancellation of current merge task")
    public void cancelMerge() {
        this.merger.forceCancelMerge();
    }

    @ManagedAttribute(description="Is the merge task running")
    public boolean isMergeTaskRunning() {
        return this.merger.isMergeTaskRunning();
    }

    @ManagedAttribute(description="Is the merge killer task running")
    public boolean isMergeKillerRunning() {
        return this.merger.isMergeKillerTaskRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View getNextView(Collection<Address> joiners, Collection<Address> leavers, Collection<Address> suspected_mbrs) {
        Membership membership = this.members;
        synchronized (membership) {
            long vid;
            ViewId view_id;
            ViewId viewId = view_id = this.view != null ? this.view.getViewId() : null;
            if (view_id == null) {
                this.log.error("view_id is null");
                return null;
            }
            this.ltime = vid = Math.max(view_id.getId(), this.ltime) + 1L;
            List<Address> mbrs = this.computeNewMembership(this.tmp_members.getMembers(), joiners, leavers, suspected_mbrs);
            Address new_coord = !mbrs.isEmpty() ? mbrs.get(0) : this.local_addr;
            View v = new View(new_coord, vid, mbrs);
            this.tmp_members.set(mbrs);
            if (joiners != null) {
                for (Address tmp_mbr : joiners) {
                    if (this.joining.contains(tmp_mbr)) continue;
                    this.joining.add(tmp_mbr);
                }
            }
            if (leavers != null) {
                for (Address addr : leavers) {
                    if (this.leaving.contains(addr)) continue;
                    this.leaving.add(addr);
                }
            }
            if (suspected_mbrs != null) {
                for (Address addr : suspected_mbrs) {
                    if (this.leaving.contains(addr)) continue;
                    this.leaving.add(addr);
                }
            }
            return v;
        }
    }

    protected List<Address> computeNewMembership(List<Address> current_members, Collection<Address> joiners, Collection<Address> leavers, Collection<Address> suspects) {
        ArrayList<Address> joiners_copy = joiners == null ? Collections.emptyList() : new ArrayList<Address>(joiners);
        ArrayList<Address> leavers_copy = leavers == null ? Collections.emptyList() : new ArrayList<Address>(leavers);
        ArrayList<Address> suspects_copy = suspects == null ? Collections.emptyList() : new ArrayList<Address>(suspects);
        try {
            List<Address> retval = this.membership_change_policy.getNewMembership(current_members, joiners_copy, leavers_copy, suspects_copy);
            if (retval == null) {
                throw new IllegalStateException("null membership list");
            }
            return retval;
        }
        catch (Throwable t) {
            this.log.error("membership change policy " + this.membership_change_policy.getClass().getSimpleName() + " failed, falling back to default policy to compute new membership", t);
            try {
                return new DefaultMembershipPolicy().getNewMembership(current_members, joiners_copy, leavers_copy, suspects_copy);
            }
            catch (Throwable t2) {
                this.log.error("default membership change policy failed", t2);
                return null;
            }
        }
    }

    protected List<Address> computeNewMembership(Collection<Collection<Address>> subviews) {
        try {
            List<Address> retval = this.membership_change_policy.getNewMembership(subviews);
            if (retval == null) {
                throw new IllegalStateException("null membership list");
            }
            return retval;
        }
        catch (Throwable t) {
            this.log.error("membership change policy " + this.membership_change_policy.getClass().getSimpleName() + " failed, falling back to default policy to compute new membership", t);
            try {
                return new DefaultMembershipPolicy().getNewMembership(subviews);
            }
            catch (Throwable t2) {
                this.log.error("default membership change policy failed", t2);
                return null;
            }
        }
    }

    public void castViewChange(View new_view, Digest digest, Collection<Address> newMembers) {
        block9: {
            this.log.trace("%s: mcasting view %s (%d mbrs)\n", this.local_addr, new_view, new_view.size());
            this.up_prot.up(new Event(15, new_view));
            this.down_prot.down(new Event(15, new_view));
            ArrayList<Address> ackMembers = new ArrayList<Address>(new_view.getMembers());
            if (newMembers != null && !newMembers.isEmpty()) {
                ackMembers.removeAll(newMembers);
            }
            if (this.use_delta_views && this.view != null && !(new_view instanceof MergeView)) {
                if (!this.first_view_sent) {
                    this.first_view_sent = true;
                } else {
                    new_view = GMS.createDeltaView(this.view, new_view);
                }
            }
            Message view_change_msg = new Message().putHeader(this.id, new GmsHeader(5, new_view, digest));
            if (new_view instanceof MergeView) {
                view_change_msg.setFlag(Message.Flag.NO_TOTAL_ORDER);
            }
            if (!ackMembers.isEmpty()) {
                this.ack_collector.reset(ackMembers);
            }
            this.down_prot.down(new Event(1, view_change_msg));
            try {
                if (!ackMembers.isEmpty()) {
                    this.ack_collector.waitForAllAcks(this.view_ack_collection_timeout);
                    this.log.trace("%s: got all ACKs (%d) from members for view %s", this.local_addr, this.ack_collector.expectedAcks(), new_view.getViewId());
                }
            }
            catch (TimeoutException e) {
                if (!this.log_collect_msgs) break block9;
                this.log.warn("%s: failed to collect all ACKs (expected=%d) for view %s after %dms, missing ACKs from %s", this.local_addr, this.ack_collector.expectedAcks(), new_view.getViewId(), this.view_ack_collection_timeout, this.ack_collector.printMissing());
            }
        }
    }

    public void sendJoinResponses(JoinRsp jr, Collection<Address> newMembers) {
        block4: {
            if (jr != null && newMembers != null && !newMembers.isEmpty()) {
                ViewId view_id = jr.getView().getViewId();
                this.ack_collector.reset(new ArrayList<Address>(newMembers));
                for (Address joiner : newMembers) {
                    this.sendJoinResponse(jr, joiner);
                }
                try {
                    this.ack_collector.waitForAllAcks(this.view_ack_collection_timeout);
                    this.log.trace("%s: got all ACKs (%d) from joiners for view %s", this.local_addr, this.ack_collector.expectedAcks(), view_id);
                }
                catch (TimeoutException e) {
                    if (!this.log_collect_msgs) break block4;
                    this.log.warn("%s: failed to collect all ACKs (expected=%d) for unicast view %s after %dms, missing ACKs from %s", this.local_addr, this.ack_collector.expectedAcks(), view_id, this.view_ack_collection_timeout, this.ack_collector.printMissing());
                }
            }
        }
    }

    public void sendJoinResponse(JoinRsp rsp, Address dest) {
        Message m = new Message(dest).putHeader(this.id, new GmsHeader(2, rsp));
        this.getDownProtocol().down(new Event(1, m));
    }

    public void installView(View new_view) {
        this.installView(new_view, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void installView(View new_view, Digest digest) {
        Event view_event;
        ViewId vid = new_view.getViewId();
        List<Address> mbrs = new_view.getMembers();
        this.ltime = Math.max(vid.getId(), this.ltime);
        if (this.view != null && vid.compareToIDs(this.view.getViewId()) <= 0) {
            return;
        }
        if (!mbrs.contains(this.local_addr)) {
            if (this.log_view_warnings) {
                this.log.warn("%s: not member of view %s; discarding it", this.local_addr, new_view.getViewId());
            }
            return;
        }
        if (digest != null) {
            if (new_view instanceof MergeView) {
                this.mergeDigest(digest);
            } else {
                this.setDigest(digest);
            }
        }
        this.log.debug("%s: installing view %s", this.local_addr, new_view);
        Membership membership = this.members;
        synchronized (membership) {
            Address coord;
            this.view = new_view;
            view_event = new Event(6, new_view);
            if (!mbrs.isEmpty()) {
                this.members.set(mbrs);
                this.tmp_members.set(this.members);
                this.joining.removeAll(mbrs);
                this.leaving.retainAll(mbrs);
                this.tmp_members.add(this.joining);
                this.tmp_members.remove(this.leaving);
                for (Address addr : mbrs) {
                    if (this.prev_members.contains(addr)) continue;
                    this.prev_members.add(addr);
                }
            }
            if ((coord = this.determineCoordinator()) != null && coord.equals(this.local_addr) && !this.haveCoordinatorRole()) {
                this.becomeCoordinator();
            } else if (this.haveCoordinatorRole() && !this.local_addr.equals(coord)) {
                this.becomeParticipant();
                this.merge_ack_collector.reset(null);
            }
        }
        this.down_prot.down(view_event);
        this.up_prot.up(view_event);
        List<Address> tmp_mbrs = new_view.getMembers();
        this.ack_collector.retainAll(tmp_mbrs);
        this.merge_ack_collector.retainAll(tmp_mbrs);
        if (new_view instanceof MergeView) {
            this.merger.forceCancelMerge();
        }
        if (this.stats) {
            ++this.num_views;
            this.prev_views.add(new Date() + ": " + new_view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Address determineCoordinator() {
        Membership membership = this.members;
        synchronized (membership) {
            return this.members.size() > 0 ? this.members.elementAt(0) : null;
        }
    }

    protected static View createDeltaView(View current_view, View next_view) {
        ViewId current_view_id = current_view.getViewId();
        ViewId next_view_id = next_view.getViewId();
        Address[][] diff = View.diff(current_view, next_view);
        return new DeltaView(next_view_id, current_view_id, diff[1], diff[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean wouldBeNewCoordinator(Address potential_new_coord) {
        if (potential_new_coord == null) {
            return false;
        }
        Membership membership = this.members;
        synchronized (membership) {
            if (this.members.size() < 2) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
            Address new_coord = this.members.elementAt(1);
            return new_coord != null && new_coord.equals(potential_new_coord);
        }
    }

    public void setDigest(Digest d) {
        this.down_prot.down(new Event(41, d));
    }

    public void mergeDigest(Digest d) {
        this.down_prot.down(new Event(53, d));
    }

    public Digest getDigest() {
        return (Digest)this.down_prot.down(Event.GET_DIGEST_EVT);
    }

    boolean startFlush(View view) {
        return this._startFlush(view, 4, true, 1000L, 5000L);
    }

    boolean startFlush(View view, int maxAttempts, long floor, long ceiling) {
        return this._startFlush(view, maxAttempts, true, floor, ceiling);
    }

    protected boolean _startFlush(View new_view, int maxAttempts, boolean resumeIfFailed, long randomFloor, long randomCeiling) {
        if (!this.flushProtocolInStack) {
            return true;
        }
        if (this.flushInvokerClass != null) {
            try {
                Callable<Boolean> invoker = this.flushInvokerClass.getDeclaredConstructor(View.class).newInstance(new_view);
                return invoker.call();
            }
            catch (Throwable e) {
                return false;
            }
        }
        try {
            boolean validView;
            boolean successfulFlush = false;
            boolean bl = validView = new_view != null && new_view.size() > 0;
            if (validView && this.flushProtocolInStack) {
                for (int attemptCount = 0; attemptCount < maxAttempts; ++attemptCount) {
                    if (attemptCount > 0) {
                        Util.sleepRandom(randomFloor, randomCeiling);
                    }
                    try {
                        this.up_prot.up(new Event(68, new ArrayList<Address>(new_view.getMembers())));
                        successfulFlush = true;
                        break;
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                if (successfulFlush) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(this.local_addr + ": successful GMS flush by coordinator");
                    }
                } else {
                    if (resumeIfFailed) {
                        this.up(new Event(70, new ArrayList<Address>(new_view.getMembers())));
                    }
                    if (this.log.isWarnEnabled()) {
                        this.log.warn(this.local_addr + ": GMS flush by coordinator failed");
                    }
                }
            }
            return successfulFlush;
        }
        catch (Exception e) {
            return false;
        }
    }

    void stopFlush() {
        if (this.flushProtocolInStack) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": sending RESUME event");
            }
            this.up_prot.up(new Event(70));
        }
    }

    void stopFlush(List<Address> members) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": sending RESUME event");
        }
        this.up_prot.up(new Event(70, members));
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                GmsHeader hdr = (GmsHeader)msg.getHeader(this.id);
                if (hdr == null) break;
                switch (hdr.type) {
                    case 1: {
                        this.view_handler.add(new GmsImpl.Request(1, hdr.mbr, false, null, hdr.useFlushIfPresent));
                        break;
                    }
                    case 11: {
                        this.view_handler.add(new GmsImpl.Request(6, hdr.mbr, false, null, hdr.useFlushIfPresent));
                        break;
                    }
                    case 2: {
                        this.impl.handleJoinResponse(hdr.join_rsp);
                        break;
                    }
                    case 3: {
                        if (hdr.mbr == null) {
                            return null;
                        }
                        this.view_handler.add(new GmsImpl.Request(2, hdr.mbr, false));
                        break;
                    }
                    case 4: {
                        this.impl.handleLeaveResponse();
                        break;
                    }
                    case 5: {
                        View new_view = hdr.view;
                        if (new_view == null) {
                            return null;
                        }
                        if (this.view != null && new_view.getViewId().compareToIDs(this.view.getViewId()) <= 0) {
                            return null;
                        }
                        if (new_view instanceof DeltaView) {
                            try {
                                this.log.trace("%s: received delta view %s", this.local_addr, new_view);
                                new_view = this.createViewFromDeltaView(this.view, (DeltaView)new_view);
                            }
                            catch (Throwable t) {
                                this.log.warn("%s: failed to create view from delta-view; dropping view: %s", this.local_addr, t);
                                return null;
                            }
                        } else {
                            this.log.trace("%s: received full view: %s", this.local_addr, new_view);
                        }
                        Address coord = msg.getSrc();
                        if (!new_view.containsMember(coord)) {
                            this.sendViewAck(coord);
                            this.impl.handleViewChange(new_view, hdr.digest);
                            break;
                        }
                        this.impl.handleViewChange(new_view, hdr.digest);
                        this.sendViewAck(coord);
                        break;
                    }
                    case 10: {
                        Address sender = msg.getSrc();
                        this.ack_collector.ack(sender);
                        return null;
                    }
                    case 6: {
                        this.impl.handleMergeRequest(msg.getSrc(), hdr.merge_id, hdr.mbrs);
                        break;
                    }
                    case 7: {
                        MergeData merge_data = new MergeData(msg.getSrc(), hdr.view, hdr.digest, hdr.merge_rejected);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace(this.local_addr + ": got merge response from " + msg.getSrc() + ", merge_id=" + hdr.merge_id + ", merge data is " + merge_data);
                        }
                        this.impl.handleMergeResponse(merge_data, hdr.merge_id);
                        break;
                    }
                    case 8: {
                        this.impl.handleMergeView(new MergeData(msg.getSrc(), hdr.view, hdr.digest), hdr.merge_id);
                        break;
                    }
                    case 15: {
                        Digest tmp = hdr.digest;
                        this.down_prot.down(new Event(53, tmp));
                        break;
                    }
                    case 12: {
                        this.merge_ack_collector.ack(msg.getSrc());
                        break;
                    }
                    case 9: {
                        this.impl.handleMergeCancelled(hdr.merge_id);
                        break;
                    }
                    case 13: {
                        if (!this.members.contains(msg.getSrc())) break;
                        if (msg.getSrc().equals(this.local_addr)) {
                            return null;
                        }
                        if (hdr.merge_id != null && !this.merger.matchMergeId(hdr.merge_id) && !this.merger.setMergeId(null, hdr.merge_id)) {
                            return null;
                        }
                        Digest digest = (Digest)this.down_prot.down(new Event(39, this.local_addr));
                        if (digest == null) break;
                        Message get_digest_rsp = new Message(msg.getSrc()).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL).putHeader(this.id, new GmsHeader(14, null, digest));
                        this.down_prot.down(new Event(1, get_digest_rsp));
                        break;
                    }
                    case 14: {
                        Digest digest_rsp = hdr.digest;
                        this.impl.handleDigestResponse(msg.getSrc(), digest_rsp);
                        break;
                    }
                    default: {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error("GmsHeader with type=" + hdr.type + " not known");
                    }
                }
                return null;
            }
            case 9: {
                Object retval = this.up_prot.up(evt);
                Address suspected = (Address)evt.getArg();
                this.view_handler.add(new GmsImpl.Request(3, suspected, true));
                this.ack_collector.suspect(suspected);
                this.merge_ack_collector.suspect(suspected);
                return retval;
            }
            case 51: {
                this.impl.unsuspect((Address)evt.getArg());
                return null;
            }
            case 14: {
                this.view_handler.add(new GmsImpl.Request(4, null, false, (Map)evt.getArg()));
                return null;
            }
            case 100: {
                return this.merger.isMergeInProgress();
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        int type = evt.getType();
        switch (type) {
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                boolean state_transfer;
                boolean use_flush = type == 92 || type == 93;
                boolean bl = state_transfer = type == 80 || type == 93;
                if (this.print_local_addr) {
                    PhysicalAddress physical_addr = this.print_physical_addrs ? (PhysicalAddress)this.down(new Event(87, this.local_addr)) : null;
                    System.out.println("\n-------------------------------------------------------------------\nGMS: address=" + this.local_addr + ", cluster=" + evt.getArg() + (physical_addr != null ? ", physical address=" + physical_addr : "") + "\n-------------------------------------------------------------------");
                } else if (this.log.isDebugEnabled()) {
                    PhysicalAddress physical_addr = this.print_physical_addrs ? (PhysicalAddress)this.down(new Event(87, this.local_addr)) : null;
                    this.log.debug("address=" + this.local_addr + ", cluster=" + evt.getArg() + (physical_addr != null ? ", physical address=" + physical_addr : ""));
                }
                this.down_prot.down(evt);
                if (this.local_addr == null) {
                    throw new IllegalStateException("local_addr is null");
                }
                if (state_transfer) {
                    this.impl.joinWithStateTransfer(this.local_addr, use_flush);
                } else {
                    this.impl.join(this.local_addr, use_flush);
                }
                return null;
            }
            case 4: {
                this.impl.leave((Address)evt.getArg());
                if (!(this.impl instanceof CoordGmsImpl)) {
                    this.initState();
                }
                this.down_prot.down(evt);
                return null;
            }
            case 56: {
                Map config = (Map)evt.getArg();
                if (config == null || !config.containsKey("flush_supported")) break;
                this.flushProtocolInStack = true;
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Map<String, String> handleProbe(String ... keys) {
        for (String key : keys) {
            if (!key.equals("fix-digests")) continue;
            this.fixDigests();
        }
        return null;
    }

    @Override
    public String[] supportedKeys() {
        return new String[]{"fix-digests"};
    }

    final void initState() {
        this.becomeClient();
        this.view = null;
        this.first_view_sent = false;
    }

    private void sendViewAck(Address dest) {
        Message view_ack = new Message(dest).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL).putHeader(this.id, new GmsHeader(10));
        this.down_prot.down(new Event(1, view_ack));
    }

    protected View createViewFromDeltaView(View current_view, DeltaView delta_view) {
        if (current_view == null || delta_view == null) {
            return null;
        }
        ViewId current_view_id = current_view.getViewId();
        ViewId delta_ref_view_id = delta_view.getRefViewId();
        ViewId delta_view_id = delta_view.getViewId();
        if (!current_view_id.equals(delta_ref_view_id)) {
            throw new IllegalStateException("the view-id of the delta view (" + delta_ref_view_id + ") doesn't match the " + "current view-id (" + current_view_id + "); discarding delta view");
        }
        List<Address> current_mbrs = current_view.getMembers();
        List<Address> left_mbrs = Arrays.asList(delta_view.getLeftMembers());
        List<Address> new_mbrs = Arrays.asList(delta_view.getNewMembers());
        List<Address> new_mbrship = this.computeNewMembership(current_mbrs, new_mbrs, left_mbrs, Collections.<Address>emptyList());
        return new View(delta_view_id, new_mbrship);
    }

    class ViewHandler
    implements Runnable {
        volatile Thread thread;
        final Queue queue = new Queue();
        volatile boolean suspended = false;
        static final long INTERVAL = 5000L;
        private static final long MAX_COMPLETION_TIME = 10000L;
        private final BoundedList<String> history = new BoundedList(20);
        private Future<?> resumer;

        ViewHandler() {
        }

        synchronized void add(GmsImpl.Request req) {
            block4: {
                if (this.suspended) {
                    if (GMS.this.log.isTraceEnabled()) {
                        GMS.this.log.trace(GMS.this.local_addr + ": queue is suspended; request " + req + " is discarded");
                    }
                    return;
                }
                this.start();
                try {
                    this.queue.add(req);
                    this.history.add(new Date() + ": " + req.toString());
                }
                catch (QueueClosedException e) {
                    if (!GMS.this.log.isTraceEnabled()) break block4;
                    GMS.this.log.trace("queue is closed; request " + req + " is discarded");
                }
            }
        }

        void waitUntilCompleted(long timeout) {
            this.waitUntilCompleted(timeout, false);
        }

        synchronized void waitUntilCompleted(long timeout, boolean resume) {
            if (this.thread != null) {
                try {
                    this.thread.join(timeout);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.thread = null;
            }
            if (resume) {
                this.resumeForce();
            }
        }

        synchronized void start() {
            if (this.queue.closed()) {
                this.queue.reset();
            }
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = GMS.this.getThreadFactory().newThread(this, "ViewHandler");
                this.thread.setDaemon(false);
                this.thread.start();
            }
        }

        synchronized void stop(boolean flush) {
            this.queue.close(flush);
            if (this.resumer != null) {
                this.resumer.cancel(false);
            }
        }

        public synchronized void suspend() {
            if (!this.suspended) {
                this.suspended = true;
                this.queue.clear();
                this.waitUntilCompleted(10000L);
                this.queue.close(true);
                this.resumer = GMS.this.timer.schedule(new Runnable(){

                    @Override
                    public void run() {
                        ViewHandler.this.resume();
                    }
                }, GMS.this.resume_task_timeout, TimeUnit.MILLISECONDS);
            }
        }

        public synchronized void resume() {
            if (!this.suspended) {
                return;
            }
            if (this.resumer != null) {
                this.resumer.cancel(false);
            }
            this.resumeForce();
        }

        public synchronized void resumeForce() {
            if (this.queue.closed()) {
                this.queue.reset();
            }
            this.suspended = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList<GmsImpl.Request> requests = new LinkedList<GmsImpl.Request>();
            while (Thread.currentThread().equals(this.thread) && !this.suspended) {
                try {
                    boolean keepGoing = false;
                    long end_time = System.currentTimeMillis() + GMS.this.max_bundling_time;
                    do {
                        GmsImpl.Request firstRequest = (GmsImpl.Request)this.queue.remove(5000L);
                        requests.add(firstRequest);
                        if (!GMS.this.view_bundling) break;
                        if (this.queue.size() > 0) {
                            GmsImpl.Request nextReq = (GmsImpl.Request)this.queue.peek();
                            keepGoing = GMS.this.view_bundling && firstRequest.canBeProcessedTogether(nextReq);
                            continue;
                        }
                        long wait_time = end_time - System.currentTimeMillis();
                        if (wait_time > 0L && firstRequest.canBeProcessedTogether(firstRequest)) {
                            this.queue.waitUntilClosed(wait_time);
                        }
                        boolean bl = keepGoing = this.queue.size() > 0 && firstRequest.canBeProcessedTogether((GmsImpl.Request)this.queue.peek());
                    } while (keepGoing && System.currentTimeMillis() < end_time);
                    try {
                        this.process(requests);
                    }
                    finally {
                        requests.clear();
                    }
                }
                catch (QueueClosedException e) {
                    break;
                }
                catch (TimeoutException e) {
                    break;
                }
                catch (Throwable catchall) {
                    Util.sleep(50L);
                }
            }
        }

        public int size() {
            return this.queue.size();
        }

        public boolean suspended() {
            return this.suspended;
        }

        public String dumpQueue() {
            StringBuilder sb = new StringBuilder();
            LinkedList v = this.queue.values();
            Iterator it = v.iterator();
            while (it.hasNext()) {
                sb.append(it.next() + "\n");
            }
            return sb.toString();
        }

        public String dumpHistory() {
            StringBuilder sb = new StringBuilder();
            for (String line : this.history) {
                sb.append(line + "\n");
            }
            return sb.toString();
        }

        private void process(List<GmsImpl.Request> requests) {
            if (requests.isEmpty()) {
                return;
            }
            GmsImpl.Request firstReq = requests.get(0);
            switch (firstReq.type) {
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    GMS.this.impl.handleMembershipChange(requests);
                    break;
                }
                case 4: {
                    GMS.this.impl.merge(firstReq.views);
                    break;
                }
                default: {
                    GMS.this.log.error("request " + firstReq.type + " is unknown; discarded");
                }
            }
        }
    }

    public static class GmsHeader
    extends Header {
        public static final byte JOIN_REQ = 1;
        public static final byte JOIN_RSP = 2;
        public static final byte LEAVE_REQ = 3;
        public static final byte LEAVE_RSP = 4;
        public static final byte VIEW = 5;
        public static final byte MERGE_REQ = 6;
        public static final byte MERGE_RSP = 7;
        public static final byte INSTALL_MERGE_VIEW = 8;
        public static final byte CANCEL_MERGE = 9;
        public static final byte VIEW_ACK = 10;
        public static final byte JOIN_REQ_WITH_STATE_TRANSFER = 11;
        public static final byte INSTALL_MERGE_VIEW_OK = 12;
        public static final byte GET_DIGEST_REQ = 13;
        public static final byte GET_DIGEST_RSP = 14;
        public static final byte INSTALL_DIGEST = 15;
        public static final short VIEW_PRESENT = 1;
        public static final short JOIN_RSP_PRESENT = 2;
        public static final short DIGEST_PRESENT = 4;
        public static final short MERGE_ID_PRESENT = 8;
        public static final short USE_FLUSH = 16;
        public static final short MERGE_REJECTED = 32;
        public static final short MERGE_VIEW = 64;
        public static final short DELTA_VIEW = 128;
        public static final short READ_ADDRS = 256;
        protected byte type;
        protected View view;
        protected Address mbr;
        protected Collection<? extends Address> mbrs;
        protected JoinRsp join_rsp;
        protected Digest digest;
        protected MergeId merge_id;
        protected boolean useFlushIfPresent;
        protected boolean merge_rejected = false;

        public GmsHeader() {
        }

        public GmsHeader(byte type) {
            this.type = type;
        }

        public GmsHeader(byte type, View view, Digest digest) {
            this.type = type;
            this.view = view;
            this.digest = digest;
        }

        public GmsHeader(byte type, Address mbr, boolean useFlushIfPresent) {
            this.type = type;
            this.mbr = mbr;
            this.useFlushIfPresent = useFlushIfPresent;
        }

        public GmsHeader(byte type, Address mbr) {
            this(type, mbr, true);
        }

        public GmsHeader(byte type, Collection<Address> mbrs) {
            this(type);
            this.mbrs = mbrs;
        }

        public GmsHeader(byte type, JoinRsp join_rsp) {
            this.type = type;
            this.join_rsp = join_rsp;
        }

        public byte getType() {
            return this.type;
        }

        public GmsHeader mbr(Address mbr) {
            this.mbr = mbr;
            return this;
        }

        public GmsHeader mergeId(MergeId merge_id) {
            this.merge_id = merge_id;
            return this;
        }

        public GmsHeader mergeRejected(boolean flag) {
            this.merge_rejected = flag;
            return this;
        }

        public Address getMember() {
            return this.mbr;
        }

        public MergeId getMergeId() {
            return this.merge_id;
        }

        public void setMergeId(MergeId merge_id) {
            this.merge_id = merge_id;
        }

        public boolean isMergeRejected() {
            return this.merge_rejected;
        }

        public void setMergeRejected(boolean merge_rejected) {
            this.merge_rejected = merge_rejected;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            short flags = this.determineFlags();
            out.writeShort(flags);
            if (this.view != null) {
                this.view.writeTo(out);
            }
            Util.writeAddress(this.mbr, out);
            Util.writeAddresses(this.mbrs, out);
            if (this.join_rsp != null) {
                this.join_rsp.writeTo(out);
            }
            if (this.digest != null) {
                this.digest.writeTo(out, this.writeAddresses());
            }
            if (this.merge_id != null) {
                this.merge_id.writeTo(out);
            }
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            short flags = in.readShort();
            if ((flags & 1) == 1) {
                this.view = (flags & 0x40) == 64 ? new MergeView() : ((flags & 0x80) == 128 ? new DeltaView() : new View());
                this.view.readFrom(in);
            }
            this.mbr = Util.readAddress(in);
            this.mbrs = Util.readAddresses(in, ArrayList.class);
            if ((flags & 2) == 2) {
                this.join_rsp = new JoinRsp();
                this.join_rsp.readFrom(in);
            }
            if ((flags & 4) == 4) {
                if ((flags & 0x100) == 256) {
                    this.digest = new Digest();
                    this.digest.readFrom(in);
                } else {
                    this.digest = new Digest(this.view.getMembersRaw());
                    this.digest.readFrom(in, false);
                }
            }
            if ((flags & 8) == 8) {
                this.merge_id = new MergeId();
                this.merge_id.readFrom(in);
            }
            this.merge_rejected = (flags & 0x20) == 32;
            this.useFlushIfPresent = (flags & 0x10) == 16;
        }

        @Override
        public int size() {
            int retval = 3;
            if (this.view != null) {
                retval += this.view.serializedSize();
            }
            retval += Util.size(this.mbr);
            retval = (int)((long)retval + Util.size(this.mbrs));
            if (this.join_rsp != null) {
                retval += this.join_rsp.serializedSize();
            }
            if (this.digest != null) {
                retval = (int)((long)retval + this.digest.serializedSize(this.writeAddresses()));
            }
            if (this.merge_id != null) {
                retval += this.merge_id.size();
            }
            return retval;
        }

        protected short determineFlags() {
            short retval = 0;
            if (this.view != null) {
                retval = (short)(retval | 1);
                if (this.view instanceof MergeView) {
                    retval = (short)(retval | 0x40);
                } else if (this.view instanceof DeltaView) {
                    retval = (short)(retval | 0x80);
                }
            }
            if (this.join_rsp != null) {
                retval = (short)(retval | 2);
            }
            if (this.digest != null) {
                retval = (short)(retval | 4);
            }
            if (this.merge_id != null) {
                retval = (short)(retval | 8);
            }
            if (this.useFlushIfPresent) {
                retval = (short)(retval | 0x10);
            }
            if (this.merge_rejected) {
                retval = (short)(retval | 0x20);
            }
            if (this.writeAddresses()) {
                retval = (short)(retval | 0x100);
            }
            return retval;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("GmsHeader");
            sb.append('[' + GmsHeader.type2String(this.type) + ']');
            switch (this.type) {
                case 1: 
                case 3: 
                case 13: {
                    sb.append(": mbr=" + this.mbr);
                    break;
                }
                case 2: {
                    sb.append(": join_rsp=" + this.join_rsp);
                    break;
                }
                case 5: 
                case 10: {
                    sb.append(": view=" + this.view);
                    break;
                }
                case 6: {
                    sb.append(": merge_id=" + this.merge_id).append(", mbrs=" + this.mbrs);
                    break;
                }
                case 7: {
                    sb.append(": view=" + this.view + ", digest=" + this.digest + ", merge_id=" + this.merge_id);
                    if (!this.merge_rejected) break;
                    sb.append(", merge_rejected=" + this.merge_rejected);
                    break;
                }
                case 8: 
                case 14: 
                case 15: {
                    sb.append(": view=" + this.view + ", digest=" + this.digest);
                    break;
                }
                case 9: {
                    sb.append(", <merge cancelled>, merge_id=" + this.merge_id);
                }
            }
            return sb.toString();
        }

        public static String type2String(int type) {
            switch (type) {
                case 1: {
                    return "JOIN_REQ";
                }
                case 2: {
                    return "JOIN_RSP";
                }
                case 3: {
                    return "LEAVE_REQ";
                }
                case 4: {
                    return "LEAVE_RSP";
                }
                case 5: {
                    return "VIEW";
                }
                case 6: {
                    return "MERGE_REQ";
                }
                case 7: {
                    return "MERGE_RSP";
                }
                case 8: {
                    return "INSTALL_MERGE_VIEW";
                }
                case 9: {
                    return "CANCEL_MERGE";
                }
                case 10: {
                    return "VIEW_ACK";
                }
                case 11: {
                    return "JOIN_REQ_WITH_STATE_TRANSFER";
                }
                case 12: {
                    return "INSTALL_MERGE_VIEW_OK";
                }
                case 13: {
                    return "GET_DIGEST_REQ";
                }
                case 14: {
                    return "GET_DIGEST_RSP";
                }
                case 15: {
                    return "INSTALL_DIGEST";
                }
            }
            return "<unknown>";
        }

        protected boolean writeAddresses() {
            return this.digest == null || this.view == null || !Arrays.equals(this.view.getMembersRaw(), this.digest.getMembersRaw());
        }
    }

    public static class DefaultMembershipPolicy
    implements MembershipChangePolicy {
        @Override
        public List<Address> getNewMembership(Collection<Address> current_members, Collection<Address> joiners, Collection<Address> leavers, Collection<Address> suspects) {
            Membership mbrs = new Membership(current_members);
            mbrs.remove(leavers);
            mbrs.remove(suspects);
            mbrs.add(joiners);
            return mbrs.getMembers();
        }

        public static List<Address> getNewMembershipOld(Collection<Collection<Address>> subviews) {
            Membership mbrs = new Membership();
            for (Collection<Address> subview : subviews) {
                mbrs.add(subview);
            }
            mbrs.sort();
            return mbrs.getMembers();
        }

        @Override
        public List<Address> getNewMembership(Collection<Collection<Address>> subviews) {
            Membership coords = new Membership();
            Membership new_mbrs = new Membership();
            for (Collection<Address> subview : subviews) {
                if (subview.isEmpty()) continue;
                coords.add(subview.iterator().next());
            }
            coords.sort();
            new_mbrs.add(coords.elementAt(0));
            for (Collection<Address> subview : subviews) {
                new_mbrs.add(subview);
            }
            return new_mbrs.getMembers();
        }
    }
}

