/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.rest.integration;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.narayana.rest.integration.ParticipantInformation;

public final class ParticipantsContainer {
    private static final ParticipantsContainer INSTANCE = new ParticipantsContainer();
    private final Map<String, ParticipantInformation> participantsInformation = new ConcurrentHashMap<String, ParticipantInformation>();

    public static ParticipantsContainer getInstance() {
        return INSTANCE;
    }

    private ParticipantsContainer() {
    }

    public Map<String, ParticipantInformation> getAllParticipantsInformation() {
        return Collections.unmodifiableMap(this.participantsInformation);
    }

    public ParticipantInformation getParticipantInformation(String participantId) {
        return this.participantsInformation.get(participantId);
    }

    public void addParticipantInformation(String participantId, ParticipantInformation participantInformation) {
        this.participantsInformation.put(participantId, participantInformation);
    }

    public void removeParticipantInformation(String participantId) {
        this.participantsInformation.remove(participantId);
    }

    public void clear() {
        this.participantsInformation.clear();
    }
}

