/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.rest.integration;

import com.arjuna.ats.arjuna.common.Uid;
import org.jboss.jbossts.star.util.TxStatus;
import org.jboss.jbossts.star.util.TxSupport;
import org.jboss.narayana.rest.integration.ParticipantInformation;
import org.jboss.narayana.rest.integration.ParticipantsContainer;
import org.jboss.narayana.rest.integration.RecoveryManager;
import org.jboss.narayana.rest.integration.api.HeuristicType;
import org.jboss.narayana.rest.integration.api.Participant;
import org.jboss.narayana.rest.integration.api.ParticipantDeserializer;
import org.jboss.narayana.rest.integration.api.ParticipantsManager;

public final class ParticipantsManagerImpl
implements ParticipantsManager {
    private String baseUrl;

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public String enlist(String applicationId, String participantEnlistmentURL, Participant participant) {
        if (this.baseUrl == null) {
            throw new IllegalStateException("Base URL was not defined.");
        }
        String participantId = new Uid().toString();
        String participantUrl = this.getParticipantUrl(participantId, this.baseUrl);
        String participantRecoveryURL = this.enlistParticipant(participantUrl, participantEnlistmentURL);
        ParticipantInformation participantInformation = new ParticipantInformation(participantId, applicationId, participantRecoveryURL, participant);
        participantInformation.setStatus(TxStatus.TransactionActive.name());
        ParticipantsContainer.getInstance().addParticipantInformation(participantId, participantInformation);
        return participantId;
    }

    @Override
    public void registerDeserializer(String applicationId, ParticipantDeserializer deserializer) {
        RecoveryManager.getInstance().registerDeserializer(applicationId, deserializer);
    }

    @Override
    public void reportHeuristic(String participantId, HeuristicType heuristicType) {
        ParticipantInformation participantInformation = ParticipantsContainer.getInstance().getParticipantInformation(participantId);
        switch (heuristicType) {
            case HEURISTIC_ROLLBACK: {
                participantInformation.setStatus(TxStatus.TransactionHeuristicRollback.name());
                break;
            }
            case HEURISTIC_COMMIT: {
                participantInformation.setStatus(TxStatus.TransactionHeuristicCommit.name());
                break;
            }
            case HEURISTIC_HAZARD: {
                participantInformation.setStatus(TxStatus.TransactionHeuristicHazard.name());
                break;
            }
            case HEURISTIC_MIXED: {
                participantInformation.setStatus(TxStatus.TransactionHeuristicMixed.name());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown heuristic type");
            }
        }
        RecoveryManager.getInstance().persistParticipantInformation(participantInformation);
    }

    private String enlistParticipant(String participantUrl, String participantEnlistmentURL) {
        TxSupport txSupport = new TxSupport();
        String participantLinkHeader = txSupport.makeTwoPhaseAwareParticipantLinkHeader(participantUrl, participantUrl);
        String recoveryUrl = txSupport.enlistParticipant(participantEnlistmentURL, participantLinkHeader);
        return recoveryUrl;
    }

    private String getParticipantUrl(String participantId, String baseUrl) {
        if (!baseUrl.substring(baseUrl.length() - 1).equals("/")) {
            baseUrl = baseUrl + "/";
        }
        return baseUrl + "rest-at-participant" + "/" + participantId;
    }
}

