/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintUtilizationRegistry;
import org.jboss.as.controller.access.management.DelegatingConfigurableAuthorizer;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.domain.management.Environment;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.audit.AccessAuditResourceDefinition;
import org.jboss.as.domain.management.audit.EnvironmentNameReader;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.as.domain.management.security.SecurityRealmResourceDefinition;

public class CoreManagementResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"core-service", (String)"management");
    private final Environment environment;
    private final List<ResourceDefinition> interfaces;
    private final DelegatingConfigurableAuthorizer authorizer;
    private final ManagedAuditLogger auditLogger;
    private final PathManagerService pathManager;
    private final EnvironmentNameReader environmentReader;

    public static void registerDomainResource(Resource parent, AccessConstraintUtilizationRegistry registry) {
        Resource coreManagement = Resource.Factory.create();
        coreManagement.registerChild(AccessAuthorizationResourceDefinition.PATH_ELEMENT, AccessAuthorizationResourceDefinition.createResource(registry));
        parent.registerChild(PATH_ELEMENT, coreManagement);
    }

    private CoreManagementResourceDefinition(Environment environment, DelegatingConfigurableAuthorizer authorizer, ManagedAuditLogger auditLogger, PathManagerService pathManager, EnvironmentNameReader environmentReader, List<ResourceDefinition> interfaces) {
        super(PATH_ELEMENT, DomainManagementResolver.getResolver("core", "management"));
        this.environment = environment;
        this.authorizer = authorizer;
        this.interfaces = interfaces;
        this.auditLogger = auditLogger;
        this.pathManager = pathManager;
        this.environmentReader = environmentReader;
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)SecurityRealmResourceDefinition.INSTANCE);
        resourceRegistration.registerSubModel((ResourceDefinition)LdapConnectionResourceDefinition.INSTANCE);
        for (ResourceDefinition current : this.interfaces) {
            resourceRegistration.registerSubModel(current);
        }
        boolean registerAuditLog = true;
        switch (this.environment) {
            case DOMAIN: {
                resourceRegistration.registerSubModel((ResourceDefinition)AccessAuthorizationResourceDefinition.forDomain(this.authorizer));
                registerAuditLog = false;
                break;
            }
            case DOMAIN_SERVER: {
                resourceRegistration.registerSubModel((ResourceDefinition)AccessAuthorizationResourceDefinition.forDomainServer(this.authorizer));
                break;
            }
            case HOST_CONTROLLER: {
                resourceRegistration.registerSubModel((ResourceDefinition)AccessAuthorizationResourceDefinition.forHost(this.authorizer));
                break;
            }
            case STANDALONE_SERVER: {
                resourceRegistration.registerSubModel((ResourceDefinition)AccessAuthorizationResourceDefinition.forStandaloneServer(this.authorizer));
            }
        }
        if (registerAuditLog) {
            resourceRegistration.registerSubModel((ResourceDefinition)new AccessAuditResourceDefinition(this.auditLogger, this.pathManager, this.environmentReader));
        }
    }

    public static SimpleResourceDefinition forDomain(DelegatingConfigurableAuthorizer authorizer) {
        List<ResourceDefinition> interfaces = Collections.emptyList();
        return new CoreManagementResourceDefinition(Environment.DOMAIN, authorizer, null, null, null, interfaces);
    }

    public static SimpleResourceDefinition forDomainServer(DelegatingConfigurableAuthorizer authorizer, ManagedAuditLogger auditLogger, PathManagerService pathManager, EnvironmentNameReader environmentReader) {
        List<ResourceDefinition> interfaces = Collections.emptyList();
        return new CoreManagementResourceDefinition(Environment.DOMAIN_SERVER, authorizer, auditLogger, pathManager, environmentReader, interfaces);
    }

    public static SimpleResourceDefinition forHost(DelegatingConfigurableAuthorizer authorizer, ManagedAuditLogger auditLogger, PathManagerService pathManager, EnvironmentNameReader environmentReader, ResourceDefinition ... interfaces) {
        return new CoreManagementResourceDefinition(Environment.HOST_CONTROLLER, authorizer, auditLogger, pathManager, environmentReader, Arrays.asList(interfaces));
    }

    public static SimpleResourceDefinition forStandaloneServer(DelegatingConfigurableAuthorizer authorizer, ManagedAuditLogger auditLogger, PathManagerService pathManager, EnvironmentNameReader environmentReader, ResourceDefinition ... interfaces) {
        return new CoreManagementResourceDefinition(Environment.STANDALONE_SERVER, authorizer, auditLogger, pathManager, environmentReader, Arrays.asList(interfaces));
    }
}

