/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.constraint.HostEffectConstraint;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.access.HostScopedRoleAdd;
import org.jboss.as.domain.management.access.HostScopedRolesResourceDefinition;
import org.jboss.as.domain.management.access.ServerGroupScopedRoleResourceDefinition;
import org.jboss.dmr.ModelNode;

class HostScopedRoleRemove
implements OperationStepHandler {
    private final Map<String, HostEffectConstraint> constraintMap;
    private final WritableAuthorizerConfiguration authorizerConfiguration;

    HostScopedRoleRemove(Map<String, HostEffectConstraint> constraintMap, WritableAuthorizerConfiguration authorizerConfiguration) {
        this.constraintMap = constraintMap;
        this.authorizerConfiguration = authorizerConfiguration;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final ModelNode model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                final String roleName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
                final String baseRole = ServerGroupScopedRoleResourceDefinition.BASE_ROLE.resolveModelAttribute(context, model).asString();
                ModelNode hostsAttribute = HostScopedRolesResourceDefinition.HOSTS.resolveModelAttribute(context, model);
                final List hostNodes = hostsAttribute.isDefined() ? hostsAttribute.asList() : Collections.emptyList();
                HostScopedRoleRemove.this.authorizerConfiguration.removeScopedRole(roleName);
                HostScopedRoleRemove.this.constraintMap.remove(roleName);
                context.completeStep(new OperationContext.RollbackHandler(){

                    public void handleRollback(OperationContext context, ModelNode operation) {
                        HostScopedRoleAdd.addScopedRole(roleName, baseRole, hostNodes, HostScopedRoleRemove.this.authorizerConfiguration, HostScopedRoleRemove.this.constraintMap);
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

