/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import java.util.StringTokenizer;
import javax.jws.WebService;
import org.jboss.ws.api.annotation.WebContext;
import org.jboss.ws.common.Messages;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.HttpEndpoint;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;

public class URLPatternDeploymentAspect
extends AbstractDeploymentAspect {
    @Override
    public void start(Deployment dep) {
        for (Endpoint ep : dep.getService().getEndpoints()) {
            HttpEndpoint httpEp;
            String urlPattern;
            if (!(ep instanceof HttpEndpoint) || (urlPattern = (httpEp = (HttpEndpoint)ep).getURLPattern()) != null) continue;
            urlPattern = this.getExplicitPattern(dep, ep);
            if (urlPattern == null) {
                urlPattern = ep.getShortName();
            }
            if (!urlPattern.startsWith("/")) {
                urlPattern = "/" + urlPattern;
            }
            httpEp.setURLPattern(urlPattern);
        }
    }

    protected String getExplicitPattern(Deployment dep, Endpoint ep) {
        WebService webServiceAnnotation;
        Class beanClass;
        WebContext anWebContext;
        EJBMetaData bmd;
        EJBArchiveMetaData appMetaData;
        String urlPattern = null;
        JSEArchiveMetaData webMetaData = (JSEArchiveMetaData)dep.getAttachment(JSEArchiveMetaData.class);
        if (webMetaData != null && WSHelper.isJseEndpoint(ep)) {
            String epName = ep.getShortName();
            urlPattern = (String)webMetaData.getServletMappings().get(epName);
            if (urlPattern == null) {
                throw Messages.MESSAGES.cannotObtainServletMapping(epName);
            }
        }
        if ((appMetaData = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class)) != null && appMetaData.getBeanByEjbName(ep.getShortName()) != null && WSHelper.isEjbEndpoint(ep) && (urlPattern = (bmd = appMetaData.getBeanByEjbName(ep.getShortName())).getPortComponentURI()) != null) {
            StringTokenizer st;
            String contextRoot = dep.getService().getContextRoot();
            if (!urlPattern.startsWith("/")) {
                urlPattern = "/" + urlPattern;
            }
            if ((st = new StringTokenizer(urlPattern, "/")).countTokens() > 1 && urlPattern.startsWith(contextRoot + "/")) {
                urlPattern = urlPattern.substring(contextRoot.length());
            }
        }
        if (urlPattern == null && (anWebContext = (beanClass = ep.getTargetBeanClass()).getAnnotation(WebContext.class)) != null && anWebContext.urlPattern().length() > 0) {
            urlPattern = anWebContext.urlPattern();
        }
        if (urlPattern == null && (webServiceAnnotation = (beanClass = ep.getTargetBeanClass()).getAnnotation(WebService.class)) != null) {
            String name = webServiceAnnotation.name();
            urlPattern = !URLPatternDeploymentAspect.isEmpty(name) ? name : beanClass.getSimpleName();
            String serviceName = webServiceAnnotation.serviceName();
            if (!URLPatternDeploymentAspect.isEmpty(serviceName)) {
                urlPattern = serviceName + "/" + urlPattern;
            }
        }
        if (urlPattern == null) {
            beanClass = ep.getTargetBeanClass();
            urlPattern = beanClass.getSimpleName();
        }
        return urlPattern;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

