/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jboss.as.ee.EeMessages;

public class DescriptorUtils {
    private static final Map<Class<?>, String> primitives;

    public static String makeDescriptor(String className) {
        String repl = className.replace(".", "/");
        return 'L' + repl + ';';
    }

    public static String makeDescriptor(Class<?> c) {
        String primitive = primitives.get(c);
        if (primitive != null) {
            return primitive;
        }
        if (c.isArray()) {
            return c.getName().replace(".", "/");
        }
        return DescriptorUtils.makeDescriptor(c.getName());
    }

    public static String makeDescriptor(Constructor<?> c) {
        StringBuilder desc = new StringBuilder("(");
        for (Class<?> p : c.getParameterTypes()) {
            desc.append(DescriptorUtils.makeDescriptor(p));
        }
        desc.append(")");
        desc.append("V");
        return desc.toString();
    }

    public static String[] parameterDescriptors(String methodDescriptor) {
        int i = 1;
        ArrayList<String> ret = new ArrayList<String>();
        int arrayStart = -1;
        while (methodDescriptor.charAt(i) != ')') {
            String type = null;
            if (methodDescriptor.charAt(i) == '[') {
                if (arrayStart == -1) {
                    arrayStart = i;
                }
            } else {
                if (methodDescriptor.charAt(i) == 'L') {
                    int start = i++;
                    while (methodDescriptor.charAt(i) != ';') {
                        ++i;
                    }
                    type = arrayStart == -1 ? methodDescriptor.substring(start, i) : methodDescriptor.substring(arrayStart, i);
                } else {
                    type = arrayStart == -1 ? methodDescriptor.charAt(i) + "" : methodDescriptor.substring(arrayStart, i + 1);
                }
                arrayStart = -1;
                ret.add(type);
            }
            ++i;
        }
        String[] r = new String[ret.size()];
        for (int j = 0; j < ret.size(); ++j) {
            r[j] = (String)ret.get(j);
        }
        return r;
    }

    public static String[] parameterDescriptors(Method m) {
        return DescriptorUtils.parameterDescriptors(m.getParameterTypes());
    }

    public static String[] parameterDescriptors(Class<?>[] parameters) {
        String[] ret = new String[parameters.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = DescriptorUtils.makeDescriptor(parameters[i]);
        }
        return ret;
    }

    public static String returnType(String methodDescriptor) {
        return methodDescriptor.substring(methodDescriptor.lastIndexOf(41) + 1, methodDescriptor.length());
    }

    public static boolean isPrimitive(String descriptor) {
        return descriptor.length() == 1;
    }

    public static String methodDescriptor(Method m) {
        StringBuilder desc = new StringBuilder("(");
        for (Class<?> p : m.getParameterTypes()) {
            desc.append(DescriptorUtils.makeDescriptor(p));
        }
        desc.append(")");
        desc.append(DescriptorUtils.makeDescriptor(m.getReturnType()));
        return desc.toString();
    }

    public static String methodDescriptor(String[] parameters, String returnType) {
        StringBuilder desc = new StringBuilder("(");
        for (String p : parameters) {
            desc.append(p);
        }
        desc.append(")");
        desc.append(returnType);
        return desc.toString();
    }

    public static String validateDescriptor(String descriptor) {
        if (descriptor.length() == 0) {
            throw EeMessages.MESSAGES.cannotBeEmpty("descriptors");
        }
        if (descriptor.length() > 1) {
            if (descriptor.startsWith("L")) {
                if (!descriptor.endsWith(";")) {
                    throw EeMessages.MESSAGES.invalidDescriptor(descriptor);
                }
            } else if (!descriptor.startsWith("[")) {
                throw EeMessages.MESSAGES.invalidDescriptor(descriptor);
            }
        } else {
            char type = descriptor.charAt(0);
            switch (type) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    break;
                }
                default: {
                    throw EeMessages.MESSAGES.invalidDescriptor(descriptor);
                }
            }
        }
        return descriptor;
    }

    static {
        IdentityHashMap<Class<Object>, String> p = new IdentityHashMap<Class<Object>, String>();
        p.put(Void.TYPE, "V");
        p.put(Byte.TYPE, "B");
        p.put(Character.TYPE, "C");
        p.put(Double.TYPE, "D");
        p.put(Float.TYPE, "F");
        p.put(Integer.TYPE, "I");
        p.put(Long.TYPE, "J");
        p.put(Short.TYPE, "S");
        p.put(Boolean.TYPE, "Z");
        primitives = Collections.unmodifiableMap(p);
    }
}

