/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2js.processor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.BindingType;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.WSDLConstants;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.javascript.BasicNameManager;
import org.apache.cxf.javascript.JavascriptQueryHandler;
import org.apache.cxf.javascript.NameManager;
import org.apache.cxf.javascript.NamespacePrefixAccumulator;
import org.apache.cxf.javascript.service.ServiceJavascriptBuilder;
import org.apache.cxf.javascript.types.SchemaJavascriptBuilder;
import org.apache.cxf.service.ServiceBuilder;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.Processor;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.java2wsdl.processor.internal.ServiceBuilderFactory;
import org.apache.cxf.tools.util.AnnotationUtil;

public class JavaToJSProcessor
implements Processor {
    private static final Logger LOG = LogUtils.getL7dLogger(JavaToJSProcessor.class);
    private static final String JAVA_CLASS_PATH = "java.class.path";
    private static final Charset UTF8 = Charset.forName("utf-8");
    private ToolContext context;

    public void process() throws ToolException {
        String oldClassPath = System.getProperty(JAVA_CLASS_PATH);
        LOG.log(Level.INFO, "OLD_CP", oldClassPath);
        if (this.context.get("classpath") != null) {
            String newCp = (String)this.context.get("classpath");
            System.setProperty(JAVA_CLASS_PATH, newCp + File.pathSeparator + oldClassPath);
            LOG.log(Level.INFO, "NEW_CP", newCp);
        }
        ServiceBuilder builder = this.getServiceBuilder();
        ServiceInfo serviceInfo = builder.createService();
        File jsFile = this.getOutputFile(builder.getOutputFile(), serviceInfo.getName().getLocalPart() + ".js");
        BasicNameManager nameManager = BasicNameManager.newNameManager((ServiceInfo)serviceInfo, null);
        NamespacePrefixAccumulator prefixManager = new NamespacePrefixAccumulator(serviceInfo.getXmlSchemaCollection());
        List schemata = serviceInfo.getSchemas();
        BufferedWriter writer = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(jsFile);
            if (null != this.context.get("javascriptUtils")) {
                JavascriptQueryHandler.writeUtilsToResponseStream(JavaToJSProcessor.class, (OutputStream)fileOutputStream);
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, UTF8);
            writer = new BufferedWriter(outputStreamWriter);
            for (SchemaInfo schema : schemata) {
                SchemaJavascriptBuilder jsBuilder = new SchemaJavascriptBuilder(serviceInfo.getXmlSchemaCollection(), prefixManager, (NameManager)nameManager);
                String allThatJavascript = jsBuilder.generateCodeForSchema(schema.getSchema());
                writer.append(allThatJavascript);
            }
            ServiceJavascriptBuilder serviceBuilder = new ServiceJavascriptBuilder(serviceInfo, null, prefixManager, (NameManager)nameManager);
            serviceBuilder.walk();
            String serviceJavascript = serviceBuilder.getCode();
            writer.append(serviceJavascript);
        }
        catch (FileNotFoundException e) {
            throw new ToolException((Throwable)e);
        }
        catch (IOException e) {
            throw new ToolException((Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    throw new ToolException((Throwable)e);
                }
            }
        }
        System.setProperty(JAVA_CLASS_PATH, oldClassPath);
        LOG.log(Level.INFO, "RESUME_CP", oldClassPath);
    }

    public ServiceBuilder getServiceBuilder() throws ToolException {
        Object beanFilesParameter = this.context.get("beans");
        ArrayList<String> beanDefinitions = new ArrayList<String>();
        if (beanFilesParameter != null) {
            if (beanFilesParameter instanceof String) {
                beanDefinitions.add((String)beanFilesParameter);
            } else if (beanFilesParameter instanceof List) {
                beanDefinitions.addAll((List)beanFilesParameter);
            } else {
                String[] list;
                for (String b : list = (String[])beanFilesParameter) {
                    beanDefinitions.add(b);
                }
            }
        }
        ServiceBuilderFactory builderFactory = ServiceBuilderFactory.getInstance(beanDefinitions, this.getDataBindingName());
        Class<?> clz = this.getServiceClass();
        this.context.put(Class.class, clz);
        if (clz.isInterface()) {
            this.context.put("genFromSEI", (Object)Boolean.TRUE);
            this.context.put("seiClass", (Object)clz.getName());
        } else {
            this.context.put("implClass", (Object)clz.getName());
            if (clz.getInterfaces().length == 1) {
                this.context.put("seiClass", (Object)clz.getInterfaces()[0].getName());
            }
            this.context.put("genFromSEI", (Object)Boolean.FALSE);
        }
        builderFactory.setServiceClass(clz);
        builderFactory.setDatabindingName(this.getDataBindingName());
        ServiceBuilder builder = builderFactory.newBuilder();
        builder.validate();
        builder.setTransportId(this.getTransportId());
        builder.setBus(this.getBus());
        builder.setBindingId(this.getBindingId());
        return builder;
    }

    protected String getTransportId() {
        if (this.isSOAP12()) {
            return "http://schemas.xmlsoap.org/wsdl/soap12/";
        }
        return "http://schemas.xmlsoap.org/wsdl/soap/";
    }

    protected String getBindingId() {
        if (this.isSOAP12()) {
            return "http://schemas.xmlsoap.org/wsdl/soap12/";
        }
        return "http://schemas.xmlsoap.org/wsdl/soap/";
    }

    protected boolean isSOAP12() {
        if (!this.context.optionSet("soap12")) {
            BindingType bType = this.getServiceClass().getAnnotation(BindingType.class);
            if (bType != null) {
                return "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(bType.value());
            }
            return false;
        }
        return true;
    }

    protected File getOutputDir(File wsdlLocation) {
        String dir = (String)this.context.get("outputdir");
        if (dir == null) {
            dir = wsdlLocation == null || wsdlLocation.getParentFile() == null || !wsdlLocation.getParentFile().exists() ? "./" : wsdlLocation.getParent();
        }
        return new File(dir);
    }

    protected File getOutputFile(File nameFromClz, String defaultOutputFile) {
        File result;
        String output = (String)this.context.get("outputfile");
        String dir = (String)this.context.get("outputdir");
        if (dir == null) {
            dir = "./";
        }
        if (output != null) {
            result = new File(output);
            if (!result.isAbsolute()) {
                result = new File(new File(dir), output);
            }
        } else {
            result = new File(new File(dir), defaultOutputFile);
        }
        if (nameFromClz != null) {
            result = nameFromClz;
        }
        if (result.exists() && !result.renameTo(new File(result.getParent(), result.getName()))) {
            throw new ToolException(new Message("OUTFILE_EXISTS", LOG, new Object[0]));
        }
        return result;
    }

    public Class<?> getServiceClass() {
        return AnnotationUtil.loadClass((String)((String)this.context.get("classname")), (ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    public WSDLConstants.WSDLVersion getWSDLVersion() {
        String version = (String)this.context.get("wsdlversion");
        WSDLConstants.WSDLVersion wsVersion = WSDLConstants.getVersion((String)version);
        if (wsVersion == WSDLConstants.WSDLVersion.UNKNOWN) {
            wsVersion = WSDLConstants.WSDLVersion.WSDL11;
        }
        return wsVersion;
    }

    public String getServiceName() {
        return (String)this.context.get("servicename");
    }

    File getSourceDir() {
        String dir = (String)this.context.get("sourcedir");
        if (StringUtils.isEmpty((String)dir)) {
            return null;
        }
        return new File(dir);
    }

    File getClassesDir() {
        String dir = (String)this.context.get("classdir");
        if (StringUtils.isEmpty((String)dir)) {
            return null;
        }
        return new File(dir);
    }

    public Bus getBus() {
        return BusFactory.getThreadDefaultBus();
    }

    public void setEnvironment(ToolContext env) {
        this.context = env;
    }

    public ToolContext getEnvironment() {
        return this.context;
    }

    public String getDataBindingName() {
        String databindingName = (String)this.context.get("databinding");
        if (databindingName == null) {
            databindingName = "jaxb";
        }
        return databindingName;
    }
}

