/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal.jaxws;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.tools.common.model.JavaField;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.model.WrapperBeanClass;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.Wrapper;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.WrapperUtil;

public class RequestWrapper
extends Wrapper {
    @Override
    public void setOperationInfo(OperationInfo op) {
        super.setOperationInfo(op);
        this.setName(((MessagePartInfo)op.getInput().getMessageParts().get(0)).getElementQName());
        this.setClassName((String)((MessagePartInfo)op.getInput().getMessageParts().get(0)).getProperty("REQUEST.WRAPPER.CLASSNAME"));
    }

    @Override
    public boolean isWrapperAbsent(Method method) {
        javax.xml.ws.RequestWrapper reqWrapper = method.getAnnotation(javax.xml.ws.RequestWrapper.class);
        return this.getClassName() == null && (reqWrapper == null || StringUtils.isEmpty((String)reqWrapper.className()));
    }

    public String getWrapperTns(Method method) {
        javax.xml.ws.RequestWrapper reqWrapper = method.getAnnotation(javax.xml.ws.RequestWrapper.class);
        if (reqWrapper != null) {
            return reqWrapper.targetNamespace();
        }
        return null;
    }

    @Override
    protected List<JavaField> buildFields() {
        return this.buildFields(this.getMethod(), this.getOperationInfo().getUnwrappedOperation().getInput());
    }

    protected List<JavaField> buildFields(Method method, MessageInfo message) {
        ArrayList<JavaField> fields = new ArrayList<JavaField>();
        Type[] paramClasses = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        for (MessagePartInfo mpi : message.getMessageParts()) {
            int idx = mpi.getIndex();
            String name = mpi.getName().getLocalPart();
            Type t = paramClasses[idx];
            String type = this.getTypeString(t);
            JavaField field = new JavaField(name, type, "");
            if (paramAnnotations != null && paramAnnotations.length == paramClasses.length) {
                WebParam wParam = this.getWebParamAnnotation(paramAnnotations[idx]);
                if (wParam != null && !StringUtils.isEmpty((String)wParam.targetNamespace())) {
                    field.setTargetNamespace(wParam.targetNamespace());
                } else {
                    field.setTargetNamespace("");
                }
            }
            List<Annotation> jaxbAnns = WrapperUtil.getJaxbAnnotations(method, idx);
            field.setJaxbAnnotations(jaxbAnns.toArray(new Annotation[jaxbAnns.size()]));
            fields.add(field);
        }
        return fields;
    }

    @Override
    public WrapperBeanClass getWrapperBeanClass(Method method) {
        String methName;
        javax.xml.ws.RequestWrapper reqWrapper = method.getAnnotation(javax.xml.ws.RequestWrapper.class);
        WebMethod webMethod = method.getAnnotation(WebMethod.class);
        String string = methName = webMethod == null ? null : webMethod.operationName();
        if (StringUtils.isEmpty((String)methName)) {
            methName = method.getName();
        }
        String reqClassName = this.getClassName();
        String reqNs = null;
        if (reqWrapper != null) {
            reqClassName = reqWrapper.className().length() > 0 ? reqWrapper.className() : reqClassName;
            String string2 = reqNs = reqWrapper.targetNamespace().length() > 0 ? reqWrapper.targetNamespace() : null;
        }
        if (reqClassName == null) {
            reqClassName = this.getPackageName(method) + ".jaxws." + StringUtils.capitalize((String)methName);
        }
        WrapperBeanClass jClass = new WrapperBeanClass();
        jClass.setFullClassName(reqClassName);
        jClass.setNamespace(reqNs);
        return jClass;
    }
}

