/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.DefaultOperationDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modcluster.config.impl.SessionDrainingStrategyEnum;
import org.wildfly.extension.mod_cluster.CustomLoadMetricDefinition;
import org.wildfly.extension.mod_cluster.LoadMetricDefinition;
import org.wildfly.extension.mod_cluster.ModClusterAddCustomMetric;
import org.wildfly.extension.mod_cluster.ModClusterAddMetric;
import org.wildfly.extension.mod_cluster.ModClusterConfigAdd;
import org.wildfly.extension.mod_cluster.ModClusterExtension;
import org.wildfly.extension.mod_cluster.ModClusterRemoveCustomMetric;
import org.wildfly.extension.mod_cluster.ModClusterRemoveMetric;
import org.wildfly.extension.mod_cluster.ProxyListValidator;
import org.wildfly.extension.mod_cluster.ZeroToNegativeOneParameterCorrector;

class ModClusterConfigResourceDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition ADVERTISE_SOCKET = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"advertise-socket", (ModelType)ModelType.STRING, (boolean)true).setRestartAllServices().addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).build();
    static final SimpleAttributeDefinition CONNECTOR = SimpleAttributeDefinitionBuilder.create((String)"connector", (ModelType)ModelType.STRING, (boolean)false).setRestartAllServices().build();
    static final SimpleAttributeDefinition SESSION_DRAINING_STRATEGY = SimpleAttributeDefinitionBuilder.create((String)"session-draining-strategy", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(SessionDrainingStrategyEnum.DEFAULT.name())).setValidator((ParameterValidator)new EnumValidator(SessionDrainingStrategyEnum.class, true, true, (Enum[])new SessionDrainingStrategyEnum[]{SessionDrainingStrategyEnum.ALWAYS, SessionDrainingStrategyEnum.DEFAULT, SessionDrainingStrategyEnum.NEVER})).setRestartAllServices().build();
    static final SimpleAttributeDefinition PROXY_LIST = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"proxy-list", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setRestartAllServices().setValidator((ParameterValidator)new ProxyListValidator()).addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF)).build();
    static final SimpleAttributeDefinition PROXY_URL = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"proxy-url", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode("/")).setRestartAllServices().addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF)).build();
    static final SimpleAttributeDefinition ADVERTISE = SimpleAttributeDefinitionBuilder.create((String)"advertise", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(true)).setRestartAllServices().build();
    static final SimpleAttributeDefinition ADVERTISE_SECURITY_KEY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"advertise-security-key", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setRestartAllServices().addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_SECURITY_DEF)).build();
    static final SimpleAttributeDefinition EXCLUDED_CONTEXTS = SimpleAttributeDefinitionBuilder.create((String)"excluded-contexts", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode("ROOT,invoker,jbossws,juddi,console")).setRestartAllServices().build();
    static final SimpleAttributeDefinition AUTO_ENABLE_CONTEXTS = SimpleAttributeDefinitionBuilder.create((String)"auto-enable-contexts", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(true)).setRestartAllServices().build();
    static final SimpleAttributeDefinition STOP_CONTEXT_TIMEOUT = SimpleAttributeDefinitionBuilder.create((String)"stop-context-timeout", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(10)).setMeasurementUnit(MeasurementUnit.SECONDS).setValidator((ParameterValidator)new IntRangeValidator(1, true, true)).setRestartAllServices().build();
    static final SimpleAttributeDefinition SOCKET_TIMEOUT = SimpleAttributeDefinitionBuilder.create((String)"socket-timeout", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(20)).setMeasurementUnit(MeasurementUnit.SECONDS).setValidator((ParameterValidator)new IntRangeValidator(1, true, true)).setRestartAllServices().build();
    static final SimpleAttributeDefinition STICKY_SESSION = SimpleAttributeDefinitionBuilder.create((String)"sticky-session", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(true)).setRestartAllServices().build();
    static final SimpleAttributeDefinition STICKY_SESSION_REMOVE = SimpleAttributeDefinitionBuilder.create((String)"sticky-session-remove", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(false)).setRestartAllServices().build();
    static final SimpleAttributeDefinition STICKY_SESSION_FORCE = SimpleAttributeDefinitionBuilder.create((String)"sticky-session-force", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(false)).setRestartAllServices().build();
    static final SimpleAttributeDefinition WORKER_TIMEOUT = SimpleAttributeDefinitionBuilder.create((String)"worker-timeout", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(-1)).setMeasurementUnit(MeasurementUnit.SECONDS).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true)).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE).setRestartAllServices().build();
    static final SimpleAttributeDefinition MAX_ATTEMPTS = SimpleAttributeDefinitionBuilder.create((String)"max-attempts", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(1)).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true)).setRestartAllServices().build();
    static final SimpleAttributeDefinition FLUSH_PACKETS = SimpleAttributeDefinitionBuilder.create((String)"flush-packets", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(false)).setRestartAllServices().build();
    static final SimpleAttributeDefinition FLUSH_WAIT = SimpleAttributeDefinitionBuilder.create((String)"flush-wait", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(-1)).setMeasurementUnit(MeasurementUnit.SECONDS).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true)).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE).setRestartAllServices().build();
    static final SimpleAttributeDefinition PING = SimpleAttributeDefinitionBuilder.create((String)"ping", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(10)).setMeasurementUnit(MeasurementUnit.SECONDS).setRestartAllServices().build();
    static final SimpleAttributeDefinition SMAX = SimpleAttributeDefinitionBuilder.create((String)"smax", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(-1)).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true)).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE).setRestartAllServices().build();
    static final SimpleAttributeDefinition TTL = SimpleAttributeDefinitionBuilder.create((String)"ttl", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(-1)).setMeasurementUnit(MeasurementUnit.SECONDS).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true)).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE).setRestartAllServices().build();
    static final SimpleAttributeDefinition NODE_TIMEOUT = SimpleAttributeDefinitionBuilder.create((String)"node-timeout", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(-1)).setMeasurementUnit(MeasurementUnit.SECONDS).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true)).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE).setRestartAllServices().build();
    static final SimpleAttributeDefinition BALANCER = SimpleAttributeDefinitionBuilder.create((String)"balancer", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setRestartAllServices().build();
    static final SimpleAttributeDefinition LOAD_BALANCING_GROUP = SimpleAttributeDefinitionBuilder.create((String)"load-balancing-group", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setRestartAllServices().addAlternatives(new String[]{"domain"}).build();
    static final SimpleAttributeDefinition SIMPLE_LOAD_PROVIDER = SimpleAttributeDefinitionBuilder.create((String)"simple-load-provider", (ModelType)ModelType.INT, (boolean)true).setRestartAllServices().setXmlName("factor").setAllowExpression(true).setValidator((ParameterValidator)new IntRangeValidator(1, true, true)).build();
    static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{ADVERTISE_SOCKET, PROXY_LIST, PROXY_URL, BALANCER, ADVERTISE, ADVERTISE_SECURITY_KEY, EXCLUDED_CONTEXTS, AUTO_ENABLE_CONTEXTS, STOP_CONTEXT_TIMEOUT, SOCKET_TIMEOUT, STICKY_SESSION, STICKY_SESSION_REMOVE, STICKY_SESSION_FORCE, WORKER_TIMEOUT, MAX_ATTEMPTS, FLUSH_PACKETS, FLUSH_WAIT, PING, SMAX, TTL, NODE_TIMEOUT, LOAD_BALANCING_GROUP, CONNECTOR, SESSION_DRAINING_STRATEGY};
    public static final Map<String, SimpleAttributeDefinition> ATTRIBUTES_BY_NAME;

    public ModClusterConfigResourceDefinition() {
        super(ModClusterExtension.CONFIGURATION_PATH, (ResourceDescriptionResolver)ModClusterExtension.getResourceDescriptionResolver("configuration"), (OperationStepHandler)ModClusterConfigAdd.INSTANCE, (OperationStepHandler)new ReloadRequiredRemoveStepHandler());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (SimpleAttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attr, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{attr}));
        }
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SIMPLE_LOAD_PROVIDER, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{SIMPLE_LOAD_PROVIDER}));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        ResourceDescriptionResolver rootResolver = this.getResourceDescriptionResolver();
        EnumSet<OperationEntry.Flag> runtimeOnlyFlags = EnumSet.of(OperationEntry.Flag.RUNTIME_ONLY);
        DefaultOperationDescriptionProvider addMetric = new DefaultOperationDescriptionProvider("add-metric", rootResolver, LoadMetricDefinition.ATTRIBUTES);
        resourceRegistration.registerOperationHandler("add-metric", (OperationStepHandler)ModClusterAddMetric.INSTANCE, (DescriptionProvider)addMetric, false, runtimeOnlyFlags);
        DefaultOperationDescriptionProvider addCustomMetric = new DefaultOperationDescriptionProvider("add-custom-metric", rootResolver, CustomLoadMetricDefinition.ATTRIBUTES);
        resourceRegistration.registerOperationHandler("add-custom-metric", (OperationStepHandler)ModClusterAddCustomMetric.INSTANCE, (DescriptionProvider)addCustomMetric, false, runtimeOnlyFlags);
        DefaultOperationDescriptionProvider removeMetric = new DefaultOperationDescriptionProvider("remove-metric", rootResolver, new AttributeDefinition[]{LoadMetricDefinition.TYPE});
        resourceRegistration.registerOperationHandler("remove-metric", (OperationStepHandler)ModClusterRemoveMetric.INSTANCE, (DescriptionProvider)removeMetric, false, runtimeOnlyFlags);
        DefaultOperationDescriptionProvider removeCustomMetric = new DefaultOperationDescriptionProvider("remove-custom-metric", rootResolver, new AttributeDefinition[]{CustomLoadMetricDefinition.CLASS});
        resourceRegistration.registerOperationHandler("remove-custom-metric", (OperationStepHandler)ModClusterRemoveCustomMetric.INSTANCE, (DescriptionProvider)removeCustomMetric, false, runtimeOnlyFlags);
    }

    static {
        HashMap<String, SimpleAttributeDefinition> attrs = new HashMap<String, SimpleAttributeDefinition>();
        for (SimpleAttributeDefinition attr : ATTRIBUTES) {
            attrs.put(attr.getName(), attr);
        }
        ATTRIBUTES_BY_NAME = Collections.unmodifiableMap(attrs);
    }
}

