/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.extension.mod_cluster.ContextHost;
import org.wildfly.extension.mod_cluster.ModClusterMessages;

public class Proxy {
    String host;
    int port;

    public Proxy(ModelNode operation) throws OperationFailedException {
        List list = operation.asPropertyList();
        Iterator it = list.iterator();
        this.host = null;
        this.port = 0;
        while (it.hasNext()) {
            Property prop = (Property)it.next();
            if (prop.getName().equals("host")) {
                this.host = prop.getValue().toString();
                this.host = ContextHost.RemoveQuotes(this.host);
                try {
                    InetAddress.getByName(this.host);
                }
                catch (UnknownHostException e) {
                    this.host = null;
                }
            }
            if (!prop.getName().equals("port")) continue;
            this.port = Integer.parseInt(ContextHost.RemoveQuotes(prop.getValue().toString()));
            if (this.port >= 1 && this.port <= 65535) continue;
            this.port = 0;
        }
        if (this.host == null || this.port == 0) {
            throw new OperationFailedException(ModClusterMessages.MESSAGES.needHostAndPort());
        }
    }
}

