/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.xnio.Option;
import org.xnio.OptionMap;

public class OptionAttributeDefinition
extends SimpleAttributeDefinition {
    private final Option option;
    private final Class<?> optionType;

    private OptionAttributeDefinition(String name, String xmlName, ModelNode defaultValue, ModelType type, boolean allowNull, boolean allowExpression, MeasurementUnit measurementUnit, ParameterCorrector corrector, ParameterValidator validator, boolean validateNull, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecated, Option<?> option, Class<?> optionType, AccessConstraintDefinition[] accessConstraints, Boolean nullSignificant, AttributeAccess.Flag ... flags) {
        super(name, xmlName, defaultValue, type, allowNull, allowExpression, measurementUnit, corrector, validator, validateNull, alternatives, requires, attributeMarshaller, resourceOnly, deprecated, accessConstraints, nullSignificant, flags);
        this.option = option;
        this.optionType = optionType;
    }

    public Option<?> getOption() {
        return this.option;
    }

    public OptionMap.Builder resolveOption(OperationContext context, ModelNode model, OptionMap.Builder builder) throws OperationFailedException {
        ModelNode value = this.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            if (this.getType() == ModelType.INT) {
                builder.set(this.option, value.asInt());
            } else if (this.getType() == ModelType.LONG) {
                builder.set(this.option, value.asLong());
            } else if (this.getType() == ModelType.BOOLEAN) {
                builder.set(this.option, value.asBoolean());
            } else if (this.optionType.isEnum()) {
                builder.set(this.option, this.option.parseValue(value.asString(), this.option.getClass().getClassLoader()));
            } else if (this.getType() == ModelType.STRING) {
                builder.set(this.option, (Object)value.asString());
            } else {
                throw new OperationFailedException("Dont know how to handle: " + this.option + " with value: " + value);
            }
        }
        return builder;
    }

    public static Builder builder(String attributeName, Option<?> option) {
        return new Builder(attributeName, option);
    }

    public static class Builder
    extends AbstractAttributeDefinitionBuilder<Builder, OptionAttributeDefinition> {
        private Option<?> option;
        private Class<?> optionType;

        public Builder(String attributeName, Option<?> option) {
            this(attributeName, option, null);
        }

        public Builder(String attributeName, Option<?> option, ModelNode defaultValue) {
            super(attributeName, ModelType.UNDEFINED, true);
            this.option = option;
            this.defaultValue = defaultValue;
            this.setType();
        }

        public OptionAttributeDefinition build() {
            return new OptionAttributeDefinition(this.name, this.xmlName, this.defaultValue, this.type, this.allowNull, this.allowExpression, this.measurementUnit, this.corrector, this.validator, this.validateNull, this.alternatives, this.requires, this.attributeMarshaller, this.resourceOnly, this.deprecated, (Option)this.option, (Class)this.optionType, this.accessConstraints, this.nullSignficant, this.flags);
        }

        private void setType() {
            try {
                Field typeField = this.option.getClass().getSimpleName().equals("SequenceOption") ? this.option.getClass().getDeclaredField("elementType") : this.option.getClass().getDeclaredField("type");
                typeField.setAccessible(true);
                this.optionType = (Class)typeField.get(this.option);
                this.type = this.optionType.isAssignableFrom(Integer.class) ? ModelType.INT : (this.optionType.isAssignableFrom(Long.class) ? ModelType.LONG : (this.optionType.isAssignableFrom(BigInteger.class) ? ModelType.BIG_INTEGER : (this.optionType.isAssignableFrom(Double.class) ? ModelType.DOUBLE : (this.optionType.isAssignableFrom(BigDecimal.class) ? ModelType.BIG_DECIMAL : (this.optionType.isEnum() || this.optionType.isAssignableFrom(String.class) ? ModelType.STRING : (this.optionType.isAssignableFrom(Boolean.class) ? ModelType.BOOLEAN : ModelType.UNDEFINED))))));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

