/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.io.OptionAttributeDefinition;
import org.xnio.Option;
import org.xnio.OptionMap;

public class OptionList {
    private OptionList() {
    }

    public static OptionMap resolveOptions(OperationContext context, ModelNode model, Collection<OptionAttributeDefinition> attributes) throws OperationFailedException {
        OptionMap.Builder builder = OptionMap.builder();
        for (OptionAttributeDefinition attr : attributes) {
            attr.resolveOption(context, model, builder);
        }
        return builder.getMap();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<OptionAttributeDefinition> attributes = new LinkedList<OptionAttributeDefinition>();

        private Builder() {
        }

        public Builder addOption(Option<?> option, String name) {
            return this.addOption(option, name, null, true, true);
        }

        public Builder addOption(Option<?> option, String name, ModelNode defaultValue) {
            return this.addOption(option, name, defaultValue, true, true);
        }

        public Builder addOption(Option<?> option, String name, ModelNode defaultValue, boolean allowNull) {
            return this.addOption(option, name, defaultValue, true, allowNull);
        }

        public Builder addOption(Option<?> option, String name, ModelNode defaultValue, boolean allowExpression, boolean allowNull) {
            this.attributes.add(((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder(name, option).setDefaultValue(defaultValue)).setAllowExpression(allowExpression)).setAllowNull(allowNull)).build());
            return this;
        }

        public List<OptionAttributeDefinition> build() {
            return this.attributes;
        }
    }
}

