/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.csiv2;

import java.io.UnsupportedEncodingException;
import java.security.Principal;
import org.jboss.as.jacorb.JacORBLogger;
import org.jboss.as.jacorb.JacORBMessages;
import org.jboss.as.jacorb.csiv2.CSIv2Util;
import org.jboss.as.jacorb.csiv2.SecurityActions;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CSI.AuthorizationElement;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.IdentityToken;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.SASContextBodyHelper;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.GSSUP.InitialContextToken;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;

public class SASClientInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static final int sasContextId = 15;
    private static final IdentityToken absentIdentityToken;
    private static final AuthorizationElement[] noAuthorizationToken;
    private Codec codec;

    public SASClientInterceptor(Codec codec) {
        this.codec = codec;
    }

    public String name() {
        return "SASClientInterceptor";
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo ri) {
        try {
            Principal p;
            CompoundSecMech secMech = CSIv2Util.getMatchingSecurityMech(ri, this.codec, (short)64, (short)0);
            if (secMech == null) {
                return;
            }
            if ((secMech.as_context_mech.target_supports & 0x40) != 0 && (p = SecurityActions.getPrincipal()) != null) {
                String tmp;
                byte[] encodedTargetName = secMech.as_context_mech.target_name;
                String name = p.getName();
                if (name.indexOf(64) < 0) {
                    byte[] decodedTargetName = CSIv2Util.decodeGssExportedName(encodedTargetName);
                    String targetName = new String(decodedTargetName, "UTF-8");
                    name = name + "@" + targetName;
                }
                byte[] username = name.getBytes("UTF-8");
                Object credential = SecurityActions.getCredential();
                byte[] password = new byte[]{};
                if (credential instanceof char[]) {
                    tmp = new String((char[])credential);
                    password = tmp.getBytes("UTF-8");
                } else if (credential instanceof byte[]) {
                    password = (byte[])credential;
                } else if (credential != null) {
                    tmp = credential.toString();
                    password = tmp.getBytes("UTF-8");
                }
                InitialContextToken authenticationToken = new InitialContextToken(username, password, encodedTargetName);
                byte[] encodedAuthenticationToken = CSIv2Util.encodeInitialContextToken(authenticationToken, this.codec);
                EstablishContext message = new EstablishContext(0L, noAuthorizationToken, absentIdentityToken, encodedAuthenticationToken);
                SASContextBody contextBody = new SASContextBody();
                contextBody.establish_msg(message);
                Any any = ORB.init().create_any();
                SASContextBodyHelper.insert((Any)any, (SASContextBody)contextBody);
                ServiceContext sc = new ServiceContext(15, this.codec.encode_value(any));
                ri.add_request_service_context(sc, true);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw JacORBMessages.MESSAGES.unexpectedException(e);
        }
        catch (InvalidTypeForEncoding e) {
            throw JacORBMessages.MESSAGES.unexpectedException(e);
        }
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    public void receive_reply(ClientRequestInfo ri) {
        try {
            ServiceContext sc = ri.get_reply_service_context(15);
            Any msg = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
            SASContextBody contextBody = SASContextBodyHelper.extract((Any)msg);
            JacORBLogger.ROOT_LOGGER.traceReceiveReply(contextBody.discriminator());
            if (contextBody.discriminator() == 4) {
                throw JacORBMessages.MESSAGES.unexpectedContextErrorInSASReply(1245904897, CompletionStatus.COMPLETED_YES);
            }
        }
        catch (BAD_PARAM e) {
        }
        catch (FormatMismatch e) {
            throw JacORBMessages.MESSAGES.errorParsingSASReply((Exception)((Object)e), 0, CompletionStatus.COMPLETED_YES);
        }
        catch (TypeMismatch e) {
            throw JacORBMessages.MESSAGES.errorParsingSASReply((Exception)((Object)e), 0, CompletionStatus.COMPLETED_YES);
        }
    }

    public void receive_exception(ClientRequestInfo ri) {
        try {
            ServiceContext sc = ri.get_reply_service_context(15);
            Any msg = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
            SASContextBody contextBody = SASContextBodyHelper.extract((Any)msg);
            JacORBLogger.ROOT_LOGGER.traceReceiveException(contextBody.discriminator());
        }
        catch (BAD_PARAM e) {
        }
        catch (FormatMismatch e) {
            throw JacORBMessages.MESSAGES.errorParsingSASReply((Exception)((Object)e), 1245904897, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (TypeMismatch e) {
            throw JacORBMessages.MESSAGES.errorParsingSASReply((Exception)((Object)e), 1245904897, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void receive_other(ClientRequestInfo ri) {
    }

    static {
        noAuthorizationToken = new AuthorizationElement[0];
        absentIdentityToken = new IdentityToken();
        absentIdentityToken.absent(true);
    }
}

