/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.validation;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.patching.PatchLogger;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.Layer;
import org.jboss.as.patching.validation.Context;
import org.jboss.as.patching.validation.ErrorHandler;
import org.jboss.as.patching.validation.PatchArtifact;
import org.jboss.as.patching.validation.PatchElementArtifact;
import org.jboss.as.patching.validation.PatchStateHandler;
import org.jboss.as.patching.validation.PatchingHistory;

public class PatchingGarbageLocator
implements PatchStateHandler {
    private static final PatchLogger log = PatchLogger.ROOT_LOGGER;
    private static final String OVERLAYS = ".overlays";
    static final FilenameFilter ALL = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return true;
        }
    };
    private final InstallationManager manager;
    private Set<String> activeHistory = new HashSet<String>();
    private Set<File> activeOverlays = new HashSet<File>();

    public static PatchingGarbageLocator getIninitialized(InstallationManager im) {
        PatchingGarbageLocator garbageLocator = new PatchingGarbageLocator(im);
        Context ctx = PatchingGarbageLocator.getContext(im, false);
        PatchingHistory.State history = (PatchingHistory.State)PatchingHistory.getInstance().getState(ctx);
        history.handlePatches(ctx, garbageLocator);
        return garbageLocator;
    }

    public PatchingGarbageLocator(InstallationManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("Installation manager is null");
        }
        this.manager = manager;
    }

    @Override
    public void handle(PatchArtifact.State patch) {
        this.activeHistory.add(patch.getHistoryDir().getDirectory().getName());
        PatchElementArtifact.State patchElements = patch.getHistoryDir().getPatchXml().getPatchElements();
        patchElements.resetIndex();
        while (patchElements.hasNext()) {
            File modulesDir;
            File bundlesDir = ((PatchElementArtifact.ElementState)patchElements.getState()).getLayer().getBundlesDir();
            if (bundlesDir != null) {
                this.activeOverlays.add(bundlesDir);
            }
            if ((modulesDir = ((PatchElementArtifact.ElementState)patchElements.getState()).getLayer().getModulesDir()) != null) {
                this.activeOverlays.add(modulesDir);
            }
            patchElements.next();
        }
    }

    public List<File> getInactiveHistory() {
        File[] inactiveDirs = this.manager.getInstalledImage().getPatchesDir().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && !PatchingGarbageLocator.this.activeHistory.contains(pathname.getName());
            }
        });
        return inactiveDirs == null ? Collections.emptyList() : Arrays.asList(inactiveDirs);
    }

    public List<File> getInactiveOverlays() {
        ArrayList<File> inactiveDirs = null;
        for (Layer layer : this.manager.getLayers()) {
            File overlaysDir = new File(layer.getDirectoryStructure().getModuleRoot(), OVERLAYS);
            File[] inactiveLayerDirs = overlaysDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && !PatchingGarbageLocator.this.activeOverlays.contains(pathname);
                }
            });
            if (inactiveLayerDirs == null || inactiveLayerDirs.length <= 0) continue;
            if (inactiveDirs == null) {
                inactiveDirs = new ArrayList<File>();
            }
            inactiveDirs.addAll(Arrays.asList(inactiveLayerDirs));
        }
        return inactiveDirs == null ? Collections.emptyList() : inactiveDirs;
    }

    public void deleteInactiveContent() {
        List<File> dirs = this.getInactiveHistory();
        if (!dirs.isEmpty()) {
            for (File dir : dirs) {
                PatchingGarbageLocator.deleteDir(dir, ALL);
            }
        }
        if (!(dirs = this.getInactiveOverlays()).isEmpty()) {
            for (File dir : dirs) {
                PatchingGarbageLocator.deleteDir(dir, ALL);
            }
        }
    }

    protected static boolean deleteDir(File dir, FilenameFilter filter) {
        boolean success = true;
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (f.isDirectory()) {
                    if (PatchingGarbageLocator.deleteDir(f, filter)) continue;
                    success = false;
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Failed to delete dir: " + f.getAbsolutePath());
                    continue;
                }
                if (f.delete()) continue;
                success = false;
                if (!log.isDebugEnabled()) continue;
                log.debug("Failed to delete file: " + f.getAbsolutePath());
            }
        }
        if (!dir.delete()) {
            success = false;
            if (log.isDebugEnabled()) {
                log.debug("Failed to delete dir: " + dir.getAbsolutePath());
            }
        }
        return success;
    }

    private static Context getContext(final InstallationManager manager, final boolean failOnError) {
        return new Context(){

            @Override
            public InstallationManager getInstallationManager() {
                return manager;
            }

            @Override
            public ErrorHandler getErrorHandler() {
                return new ErrorHandler(){

                    @Override
                    public void error(String msg) {
                        if (failOnError) {
                            throw new IllegalStateException(msg);
                        }
                    }

                    @Override
                    public void error(String msg, Throwable t) {
                        if (failOnError) {
                            throw new IllegalStateException(msg, t);
                        }
                    }
                };
            }
        };
    }
}

