/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.mcp;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.jca.core.connectionmanager.pool.mcp.FillRequest;
import org.jboss.jca.core.connectionmanager.pool.mcp.SecurityActions;

class PoolFiller
implements Runnable {
    private static final PoolFiller FILLER = new PoolFiller();
    private final LinkedList<FillRequest> pools = new LinkedList();
    private final Thread fillerThread;
    private static final String THREAD_FILLER_NAME = "JCA PoolFiller";
    private AtomicBoolean threadStarted = new AtomicBoolean(false);

    static void fillPool(FillRequest fr) {
        FILLER.internalFillPool(fr);
    }

    PoolFiller() {
        this.fillerThread = new Thread((Runnable)this, THREAD_FILLER_NAME);
        this.fillerThread.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ClassLoader myClassLoader = this.getClass().getClassLoader();
        SecurityActions.setThreadContextClassLoader(myClassLoader);
        while (true) {
            Object fr;
            boolean empty = false;
            while (!empty) {
                fr = null;
                LinkedList<FillRequest> linkedList = this.pools;
                synchronized (linkedList) {
                    empty = this.pools.isEmpty();
                    if (!empty) {
                        fr = this.pools.removeFirst();
                    }
                }
                if (empty) continue;
                ((FillRequest)fr).getManagedConnectionPool().fillTo(((FillRequest)fr).getFillSize());
            }
            try {
                fr = this.pools;
                synchronized (fr) {
                    while (this.pools.isEmpty()) {
                        this.pools.wait();
                    }
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalFillPool(FillRequest fr) {
        if (this.threadStarted.compareAndSet(false, true)) {
            this.fillerThread.start();
        }
        LinkedList<FillRequest> linkedList = this.pools;
        synchronized (linkedList) {
            if (!this.pools.contains(fr)) {
                this.pools.addLast(fr);
                this.pools.notifyAll();
            }
        }
    }
}

